/**
 * Vehizo Modules Page JavaScript
 * * @package Vehizo
 * @version 4.1.0
 */

(function($) {
    'use strict';

    // Module Toggle Functionality
    window.vehizoToggleModule = function(element) {
        const option = element.getAttribute('data-option');
        const isChecked = element.checked;
        const status = isChecked ? '1' : '0';
        
        // Save indicator anzeigen
        const saveIndicator = document.getElementById('save-indicator');
        if (saveIndicator) {
            saveIndicator.style.display = 'block';
        }
        
        // Element deaktivieren während der Anfrage
        element.disabled = true;
        
        // AJAX Request
        $.ajax({
            url: vehizoModules.ajaxurl,
            type: 'POST',
            dataType: 'json',
            data: {
                action: 'vehizo_toggle_module_status',
                module_option: option,
                status: status,
                nonce: vehizoModules.nonces.toggle_module
            },
            success: function(response) {
                element.disabled = false;
                
                if (response.success) {
                    // Modul-Karte visuell aktualisieren
                    const moduleCard = $(element).closest('.module-card');
                    const statusElement = moduleCard.find('.module-status');
                    
                    if (isChecked) {
                        moduleCard.removeClass('inactive').addClass('active');
                        statusElement.removeClass('inactive').addClass('active');
                        statusElement.text(vehizoModules.strings.active);
                    } else {
                        moduleCard.removeClass('active').addClass('inactive');
                        statusElement.removeClass('active').addClass('inactive');
                        statusElement.text(vehizoModules.strings.inactive);
                    }

                    // Save indicator verstecken nach kurzer Verzögerung
                    setTimeout(function() {
                        if (saveIndicator) {
                            saveIndicator.style.display = 'none';
                        }
                    }, 1000);
                } else {
                    // Bei Fehler: Toggle zurücksetzen
                    element.checked = !isChecked;
                    alert(vehizoModules.strings.error_save + (response.data?.message || vehizoModules.strings.error_unknown));
                    if (saveIndicator) {
                        saveIndicator.style.display = 'none';
                    }
                }
            },
            error: function(xhr, status, error) {
                element.disabled = false;
                element.checked = !isChecked;
                alert(vehizoModules.strings.error_save_module);
                if (saveIndicator) {
                    saveIndicator.style.display = 'none';
                }
            }
        });
    };

    // Settings Modal Opening Function
    window.vehizoOpenSettings = function(element) {
        const optionName = element.getAttribute('data-option');
        const modal = $('#vehizo-settings-modal');

        // Set modal option name
        $('#vehizo-modal-option-name').val(optionName);

        // Get current setting value
        $.ajax({
            url: vehizoModules.ajaxurl,
            type: 'POST',
            dataType: 'json',
            data: {
                action: 'vehizo_get_module_setting',
                option_name: optionName,
                nonce: vehizoModules.nonces.get_setting
            },
            success: function(response) {
                if (response.success) {
                    $('#vehizo-modal-input-email').val(response.data.value || '');
                    modal.show();
                } else {
                    alert(vehizoModules.strings.error_save + (response.data?.message || vehizoModules.strings.error_unknown));
                }
            },
            error: function(xhr, status, error) {
                alert(vehizoModules.strings.error_save_module);
            }
        });
    };


    // Modal Functionality
    $(document).ready(function() {
        const modal = $('#vehizo-settings-modal');
        const closeButtons = $('.vehizo-js-close-modal');
        
        // Modal schließen
        closeButtons.on('click', function() {
            modal.hide();
        });
        
        // Modal schließen bei Klick außerhalb
        modal.on('click', function(e) {
            if (e.target === modal[0]) {
                modal.hide();
            }
        });
        
        // ESC-Taste zum Schließen
        $(document).on('keydown', function(e) {
            if (e.key === 'Escape' && modal.is(':visible')) {
                modal.hide();
            }
        });

        // Settings Button Handler (if needed for future functionality)
        $('.btn-settings').on('click', function(e) {
            e.preventDefault();
            const optionName = $(this).data('option');
            
            // Set modal option name
            $('#vehizo-modal-option-name').val(optionName);
            
            // Get current setting value
            $.ajax({
                url: vehizoModules.ajaxurl,
                type: 'POST',
                dataType: 'json',
                data: {
                    action: 'vehizo_get_module_setting',
                    option_name: optionName,
                    nonce: vehizoModules.nonces.get_setting
                },
                success: function(response) {
                    if (response.success) {
                        $('#vehizo-modal-input-email').val(response.data.value || '');
                        modal.show();
                    } else {
                        alert(vehizoModules.strings.error_save + (response.data?.message || vehizoModules.strings.error_unknown));
                    }
                },
                error: function(xhr, status, error) {
                    alert(vehizoModules.strings.error_save_module);
                }
            });
        });

        // Save Settings Button Handler
        $('#vehizo-modal-save-btn').on('click', function() {
            const optionName = $('#vehizo-modal-option-name').val();
            const settingValue = $('#vehizo-modal-input-email').val();
            const saveBtn = $(this);
            
            // Disable button during save
            saveBtn.prop('disabled', true).text(vehizoModules.strings.saving);
            
            $.ajax({
                url: vehizoModules.ajaxurl,
                type: 'POST',
                dataType: 'json',
                data: {
                    action: 'vehizo_save_module_setting',
                    option_name: optionName,
                    setting_value: settingValue,
                    nonce: vehizoModules.nonces.save_setting
                },
                success: function(response) {
                    saveBtn.prop('disabled', false).text('Save');
                    
                    if (response.success) {
                        modal.hide();
                        // Optional: Show success message
                        const successMsg = $('<div class="notice notice-success is-dismissible"><p>' + response.data.message + '</p></div>');
                        $('.wrap h1').after(successMsg);
                        setTimeout(function() {
                            successMsg.fadeOut();
                        }, 3000);
                    } else {
                        alert(vehizoModules.strings.error_save + (response.data?.message || vehizoModules.strings.error_unknown));
                    }
                },
                error: function(xhr, status, error) {
                    saveBtn.prop('disabled', false).text('Save');
                    alert(vehizoModules.strings.error_save_module);
                }
            });
        });

        // Input validation for email field
        $('#vehizo-modal-input-email').on('input', function() {
            const email = $(this).val();
            const saveBtn = $('#vehizo-modal-save-btn');
            
            if (email && !isValidEmail(email)) {
                $(this).css('border-color', '#ef4444');
                saveBtn.prop('disabled', true);
            } else {
                $(this).css('border-color', '#e5e7eb');
                saveBtn.prop('disabled', false);
            }
        });
        
        // Email validation helper
        function isValidEmail(email) {
            const emailRegex = /^[^\s@]+@[^\s@]+\.[^\s@]+$/;
            return emailRegex.test(email);
        }
    });

})(jQuery);