/**
 * Vehizo Vehicle Editor Tab Functionality
 *
 * @package Vehizo
 * @since 4.1.2
 */

jQuery(document).ready(function($) {
    'use strict';

    // Tab switching functionality
    $('.vehizo-tab-button').off('click').on('click', function(e) {
        e.preventDefault();

        var targetTab = $(this).data('tab');

        // Remove active class from all tabs and content
        $('.vehizo-tab-button').removeClass('active');
        $('.vehizo-tab-content').removeClass('active').hide();

        // Add active class to clicked tab and show content
        $(this).addClass('active');
        $('#tab-' + targetTab).addClass('active').show();
    });
});