/**
 * Vehizo Admin Sliders
 *
 * Handles the live update of slider value displays in the admin settings.
 *
 * @package      Vehizo
 * @version      4.1.3
 * @author       Thorsten Glander
 */

(function($) {
    'use strict';

    $(document).ready(function() {
        // Use event delegation for sliders that might be loaded dynamically
        $('body').on('input', '.vehizo-slider', function() {
            const $slider = $(this);
            $('#' + $slider.attr('id') + '-value').text($slider.val() + $slider.data('unit'));
        });
    });

})(jQuery);