// JAVASCRIPT FORCE RESPONSIVE - DEBUG VERSION
(function() {
    function forceResponsive() {
        console.log("🚨 VEHIZO: Forcing responsive styles with JavaScript");
        console.log("🔍 Window width:", window.innerWidth);

        // ALWAYS run (remove mobile check for testing)
        console.log("🔧 DEBUG: Running regardless of screen size");

        // Debug: Show all elements we can find
        const allTables = document.querySelectorAll("table");
        const allDivs = document.querySelectorAll("div");
        const allGrids = document.querySelectorAll("[class*=grid], [class*=Grid]");

        console.log("📊 Found tables:", allTables.length, allTables);
        console.log("📦 Found divs:", allDivs.length);
        console.log("📐 Found grids:", allGrids.length, allGrids);

        // EXTREME VISUAL TEST - Make everything RED to see if JS works
        const allElements = document.querySelectorAll("*");
        console.log("🔴 Making " + allElements.length + " elements red for visual test");

        allElements.forEach((element, index) => {
            if (index < 50) { // Only first 50 to avoid browser crash
                element.style.border = "2px solid red";
                element.style.backgroundColor = "rgba(255,0,0,0.1)";
            }
        });

        // Force all tables to be responsive
        const tables = document.querySelectorAll("table, .wp-list-table, .widefat");
        console.log("📊 Processing " + tables.length + " tables");
        tables.forEach((table, index) => {
            table.style.border = "5px solid blue";
            table.style.fontSize = "20px";
            table.style.backgroundColor = "yellow";
            console.log("📊 Table " + index + " styled:", table);
        });

            // Force all buttons to be smaller
            const buttons = document.querySelectorAll(".button, input[type=submit], input[type=button]");
            buttons.forEach(button => {
                button.style.fontSize = "10px";
                button.style.padding = "4px 6px";
                button.style.margin = "1px";
                console.log("🔘 Button resized:", button);
            });

            // Force table cells to be compact
            const cells = document.querySelectorAll("table th, table td");
            cells.forEach(cell => {
                cell.style.padding = "6px 8px";
                cell.style.fontSize = "11px";
                cell.style.minWidth = "60px";
                console.log("📋 Cell resized:", cell);
            });

            // Force admin content padding
            const adminContent = document.querySelectorAll("#wpcontent, #wpbody, #wpbody-content, .wrap");
            adminContent.forEach(element => {
                element.style.padding = "10px";
                element.style.margin = "0";
                console.log("📦 Admin area resized:", element);
            });

            // Force grids to single column
            const grids = document.querySelectorAll("[class*=grid], [class*=Grid]");
            grids.forEach(grid => {
                grid.style.gridTemplateColumns = "1fr";
                grid.style.gap = "10px";
                console.log("📐 Grid made single column:", grid);
            });

            console.log("✅ VEHIZO: Responsive styles applied successfully");
        }
    }

    // Run immediately
    forceResponsive();

    // Run after DOM is loaded
    document.addEventListener("DOMContentLoaded", forceResponsive);

    // Run after page is fully loaded
    window.addEventListener("load", forceResponsive);

    // Run when window is resized
    window.addEventListener("resize", forceResponsive);

    // Run every 2 seconds to catch dynamic content
    setInterval(forceResponsive, 2000);

    // ADD FLOATING BUTTON FOR ALL VEHICLES PAGE
    if (window.location.href.includes("edit.php") && window.location.href.includes("vehizo_vehicle")) {
        console.log("🚗 All Vehicles page detected - adding floating button");

        setTimeout(function() {
            // Check if button already exists
            if (!document.querySelector(".vehizo-floating-add")) {
                const floatingBtn = document.createElement("a");
                floatingBtn.className = "vehizo-floating-add";
                floatingBtn.href = "post-new.php?post_type=vehizo_vehicle";
                floatingBtn.innerHTML = "+";
                floatingBtn.title = "Add New Vehicle";

                document.body.appendChild(floatingBtn);
                console.log("✅ Floating button added");
            }
        }, 500);
    }
})();
