// js/visitor.js — ЛОКАЛЬНО
fetch('save_visitor.php', { cache: 'no-store' })
  .then(r => r.json())
  .then(d => {
    if (d.status === 'ok') console.log('Visitor saved');
    else console.error('Saving visitor failed');
  })
  .catch(console.error);
  // === TOTAL VISITORS counter ===
function loadTotalVisitors() {
  if (typeof VMVG === 'undefined' || !VMVG.visitors_json_url) return;

  const counterEl = document.getElementById('visitor-counter');
  if (!counterEl) return;

  fetch(VMVG.visitors_json_url + '?t=' + Date.now(), { cache: 'no-store' })
    .then(r => r.json())
    .then(data => {
      let total = 0;
      if (Array.isArray(data)) total = data.length;
      else if (typeof data === 'object' && data !== null)
        total = Object.keys(data).length;

      counterEl.textContent = 'TOTAL VISITORS: ' + total;
    })
    .catch(err => console.warn('Cannot load total visitors:', err));
}

document.addEventListener('DOMContentLoaded', loadTotalVisitors);