<?php
/**
 * Plugin Name:       V7 Product Alternatives
 * Plugin URI:        https://github.com/TheVaibhaw/v7-product-alternatives
 * Description:       Suggest alternative in-stock products for out-of-stock WooCommerce items.
 * Version:           1.0.0
 * Author:            Vaibhaw Kumar
 * Author URI:        https://vaibhawkumarparashar.in
 * License:           GPL-2.0-or-later
 * License URI:       https://www.gnu.org/licenses/gpl-2.0.html
 * Text Domain:       v7-product-alternatives
 * Domain Path:       /languages
 * Requires at least: 6.0
 * Tested up to:      6.9
 * Requires PHP:      8.0
 * WC requires at least: 8.0
 * WC tested up to:   10.4.3
 *
 * @package V7_Product_Alternatives
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

define( 'V7PA_VERSION', '1.0.0' );
define( 'V7PA_DIR', plugin_dir_path( __FILE__ ) );
define( 'V7PA_URL', plugin_dir_url( __FILE__ ) );

add_action( 'before_woocommerce_init', function() {
	if ( class_exists( \Automattic\WooCommerce\Utilities\FeaturesUtil::class ) ) {
		\Automattic\WooCommerce\Utilities\FeaturesUtil::declare_compatibility( 'custom_order_tables', __FILE__, true );
	}
} );

function v7pa_activate() {
	require_once V7PA_DIR . 'includes/class-v7-product-alt-activator.php';
	V7PA_Activator::activate();
}

function v7pa_deactivate() {
	require_once V7PA_DIR . 'includes/class-v7-product-alt-activator.php';
	V7PA_Activator::deactivate();
}

register_activation_hook( __FILE__, 'v7pa_activate' );
register_deactivation_hook( __FILE__, 'v7pa_deactivate' );

require V7PA_DIR . 'includes/class-v7-product-alt.php';

function v7pa_run() {
	$plugin = new V7PA_Core();
	$plugin->run();
}
v7pa_run();
