<?php
/**
 * Uninstall script.
 *
 * @package V7_Product_Alternatives
 */

if ( ! defined( 'WP_UNINSTALL_PLUGIN' ) ) {
	exit;
}

global $wpdb;

// phpcs:ignore WordPress.DB.DirectDatabaseQuery.DirectQuery, WordPress.DB.DirectDatabaseQuery.NoCaching
$wpdb->query(
	$wpdb->prepare(
		"DELETE FROM {$wpdb->postmeta} WHERE meta_key = %s",
		'_v7pa_alt_product'
	)
);

$v7pa_options = array(
	'v7pa_title_text',
	'v7pa_button_text',
	'v7pa_accent_color',
	'v7pa_text_color',
	'v7pa_bg_color',
	'v7pa_border_radius',
	'v7pa_show_brand',
	'v7pa_show_price',
);

foreach ( $v7pa_options as $v7pa_option ) {
	delete_option( $v7pa_option );
}
