<?php
/**
 * Core plugin class.
 *
 * @package V7_Product_Alternatives
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

class V7PA_Core {

	protected $loader;
	protected $plugin_name;
	protected $version;

	public function __construct() {
		$this->version     = defined( 'V7PA_VERSION' ) ? V7PA_VERSION : '1.0.0';
		$this->plugin_name = 'v7-product-alternatives';

		$this->load_dependencies();
		$this->set_locale();
		$this->define_admin_hooks();
		$this->define_public_hooks();
	}

	private function load_dependencies() {
		require_once V7PA_DIR . 'includes/class-v7-product-alt-loader.php';
		require_once V7PA_DIR . 'includes/class-v7-product-alt-i18n.php';
		require_once V7PA_DIR . 'admin/class-v7-product-alt-admin.php';
		require_once V7PA_DIR . 'admin/class-v7-product-alt-settings.php';
		require_once V7PA_DIR . 'public/class-v7-product-alt-public.php';

		$this->loader = new V7PA_Loader();
	}

	private function set_locale() {
		$plugin_i18n = new V7PA_I18n();
		$this->loader->add_action( 'plugins_loaded', $plugin_i18n, 'load_plugin_textdomain' );
	}

	private function define_admin_hooks() {
		$plugin_admin    = new V7PA_Admin( $this->plugin_name, $this->version );
		$plugin_settings = new V7PA_Settings( $this->plugin_name, $this->version );

		$this->loader->add_action( 'admin_enqueue_scripts', $plugin_admin, 'enqueue_styles' );
		$this->loader->add_action( 'woocommerce_product_options_general_product_data', $plugin_admin, 'add_alternative_product_field' );
		$this->loader->add_action( 'woocommerce_process_product_meta', $plugin_admin, 'save_alternative_product_field' );
		$this->loader->add_filter( 'plugin_action_links_v7-product-alternatives/v7-product-alternatives.php', $plugin_settings, 'add_plugin_action_links' );
		$this->loader->add_action( 'admin_menu', $plugin_settings, 'add_settings_page' );
		$this->loader->add_action( 'admin_init', $plugin_settings, 'register_settings' );
		$this->loader->add_action( 'admin_enqueue_scripts', $plugin_settings, 'enqueue_color_picker' );
	}

	private function define_public_hooks() {
		$plugin_public = new V7PA_Public( $this->plugin_name, $this->version );

		$this->loader->add_action( 'wp_enqueue_scripts', $plugin_public, 'enqueue_styles' );
		$this->loader->add_action( 'woocommerce_single_product_summary', $plugin_public, 'display_alternative_block', 35 );
	}

	public function run() {
		$this->loader->run();
	}

	public function get_plugin_name() {
		return $this->plugin_name;
	}

	public function get_loader() {
		return $this->loader;
	}

	public function get_version() {
		return $this->version;
	}
}
