<?php
/**
 * Activator class.
 *
 * @package V7_Product_Alternatives
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

class V7PA_Activator {

	public static function activate() {
		if ( ! class_exists( 'WooCommerce' ) ) {
			deactivate_plugins( plugin_basename( __FILE__ ) );
			wp_die(
				esc_html__( 'V7 Product Alternatives requires WooCommerce to be installed and active.', 'v7-product-alternatives' ),
				'Plugin dependency check',
				array( 'back_link' => true )
			);
		}

		$defaults = array(
			'v7pa_title_text'    => __( 'We recommend a similar alternative:', 'v7-product-alternatives' ),
			'v7pa_button_text'   => __( 'View Product', 'v7-product-alternatives' ),
			'v7pa_accent_color'  => '#2271b1',
			'v7pa_text_color'    => '#333333',
			'v7pa_bg_color'      => '#ffffff',
			'v7pa_border_radius' => '6',
			'v7pa_show_brand'    => '1',
			'v7pa_show_price'    => '1',
		);

		foreach ( $defaults as $key => $value ) {
			if ( false === get_option( $key ) ) {
				add_option( $key, $value );
			}
		}
	}

	public static function deactivate() {
	}
}
