<?php
/**
 * Admin class.
 *
 * @package V7_Product_Alternatives
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

class V7PA_Admin {

	private $plugin_name;
	private $version;

	public function __construct( $plugin_name, $version ) {
		$this->plugin_name = $plugin_name;
		$this->version     = $version;
	}

	public function enqueue_styles() {
		$screen = get_current_screen();
		if ( $screen && 'product' === $screen->id ) {
			wp_enqueue_style(
				$this->plugin_name . '-admin',
				V7PA_URL . 'admin/css/admin.css',
				array(),
				$this->version
			);
		}
	}

	public function add_alternative_product_field() {
		global $product_object;

		if ( ! $product_object ) {
			return;
		}

		$alternative_id = get_post_meta( $product_object->get_id(), '_v7pa_alt_product', true );
		wp_nonce_field( 'v7pa_save_alt_product', 'v7pa_alt_product_nonce' );
		?>
		<div class="options_group">
			<p class="form-field">
				<label for="v7pa_alt_product">
					<?php esc_html_e( 'Alternative Product', 'v7-product-alternatives' ); ?>
				</label>
				<select
					class="wc-product-search"
					id="v7pa_alt_product"
					name="v7pa_alt_product"
					data-placeholder="<?php esc_attr_e( 'Search for a product...', 'v7-product-alternatives' ); ?>"
					data-action="woocommerce_json_search_products"
					data-exclude="<?php echo intval( $product_object->get_id() ); ?>"
				>
					<?php if ( $alternative_id ) : ?>
						<option value="<?php echo esc_attr( $alternative_id ); ?>" selected="selected">
							<?php echo esc_html( get_the_title( $alternative_id ) . ' (#' . $alternative_id . ')' ); ?>
						</option>
					<?php endif; ?>
				</select>
			</p>
		</div>
		<?php
	}

	public function save_alternative_product_field( $post_id ) {
		if ( ! isset( $_POST['v7pa_alt_product_nonce'] ) || ! wp_verify_nonce( sanitize_text_field( wp_unslash( $_POST['v7pa_alt_product_nonce'] ) ), 'v7pa_save_alt_product' ) ) {
			return;
		}

		if ( ! current_user_can( 'edit_post', $post_id ) ) {
			return;
		}

		if ( ! isset( $_POST['v7pa_alt_product'] ) ) {
			delete_post_meta( $post_id, '_v7pa_alt_product' );
			return;
		}

		$alternative_id = sanitize_text_field( wp_unslash( $_POST['v7pa_alt_product'] ) );
		update_post_meta( $post_id, '_v7pa_alt_product', $alternative_id );
	}
}
