# V7 Product Alternatives

[![Version](https://img.shields.io/badge/version-1.0.0-blue.svg)](https://wordpress.org/plugins/v7-product-alternatives/)
[![License](https://img.shields.io/badge/license-GPL--2.0--or--later-green.svg)](https://www.gnu.org/licenses/gpl-2.0.html)
[![PHP](https://img.shields.io/badge/php-%3E%3D8.0-8892BF.svg)](https://php.net/)
[![WooCommerce](https://img.shields.io/badge/WooCommerce-%3E%3D8.0-96588a.svg)](https://woocommerce.com/)

Suggest alternative in-stock products for out-of-stock WooCommerce items.

## Features

- ✅ Native WooCommerce integration
- ✅ Automatic display based on stock status
- ✅ Variable product support
- ✅ Full customization (text, colors, styles)
- ✅ Responsive design
- ✅ Translation ready
- ✅ GDPR compliant

## Requirements

- WordPress 6.0+
- WooCommerce 8.0+
- PHP 8.0+

## Installation

1. Upload to `/wp-content/plugins/v7-product-alternatives/`
2. Activate the plugin
3. Configure via WooCommerce > Product Alternatives
4. Edit products and set Alternative Product field

## Settings

Customize via WooCommerce > Product Alternatives:

| Setting | Description |
|---------|-------------|
| Title Text | Recommendation title |
| Button Text | CTA button text |
| Accent Color | Border and button color |
| Text Color | Text color |
| Background Color | Card background |
| Border Radius | Corner rounding |
| Show Brand | Toggle brand display |
| Show Price | Toggle price display |

## License

GPL-2.0-or-later

## Author

**Vaibhaw Kumar** - [vaibhawkumarparashar.in](https://vaibhawkumarparashar.in)
