/* eslint-disable max-len */
import { chakra, IconProps } from "@chakra-ui/react";
import React from "react";


export const URMLogo = React.forwardRef((props, ref) => (
  <chakra.svg
    xmlns="http://www.w3.org/2000/svg"
    fill="none"
    viewBox="0 0 164 42"
    {...props}
  >
    <path
      fill="#475bb2"
      d="M35.343 2.959c-2.795 1.644-5.425 3.78-7.727 6.082-2.3 2.301-4.438 4.932-6.082 7.562 1.15 2.301 2.137 4.602 2.96 7.068 1.479-3.123 3.287-5.918 5.588-8.383v8.876c0 5.425-3.616 10.192-8.876 11.672h-.33c-.328-4.274-1.314-8.384-2.794-12.33A40.8 40.8 0 0 0 8.384 9.042C6.082 6.74 3.452 4.767.658 2.96L0 2.63V24c0 8.712 6.247 16.274 14.959 17.753h.164c1.973.33 3.946.33 5.754 0h.164C29.753 40.274 36 32.713 36 24V2.63zM5.918 24v-8.712c5.096 5.753 8.219 12.822 8.877 20.383-5.26-1.48-8.877-6.246-8.877-11.671m12-24a4.42 4.42 0 0 0-4.439 4.438 4.42 4.42 0 0 0 4.439 4.439 4.42 4.42 0 0 0 4.438-4.439A4.42 4.42 0 0 0 17.918 0"
    />
    <path
      fill="#222"
      d="M56.635 11.031q0 4.425-4.19 4.424-4.013 0-4.013-4.255V4.776h1.743v6.065q0 3.09 2.403 3.09 2.314 0 2.314-2.98V4.776h1.743zM58.444 15.045V13.47q.953.726 2.102.725 1.538 0 1.538-.908a.7.7 0 0 0-.131-.432 1.2 1.2 0 0 0-.36-.322 2.7 2.7 0 0 0-.527-.25l-.673-.248a8 8 0 0 1-.835-.389 2.7 2.7 0 0 1-.616-.46 1.8 1.8 0 0 1-.366-.594 2.2 2.2 0 0 1-.124-.77q0-.54.256-.951.255-.418.689-.696a3.2 3.2 0 0 1 .98-.425 4.4 4.4 0 0 1 1.136-.146q1.041 0 1.86.314v1.487q-.79-.542-1.816-.542-.322 0-.586.066-.255.066-.44.183a.9.9 0 0 0-.285.286.65.65 0 0 0-.102.359q0 .242.102.41a1 1 0 0 0 .3.3q.205.124.484.235.285.102.652.227.483.197.864.402.388.205.66.47.27.255.417.6.146.337.146.806 0 .57-.264.996-.263.424-.703.703a3.2 3.2 0 0 1-1.018.41 5 5 0 0 1-1.208.14q-1.23 0-2.132-.411M71.738 11.99h-5.112q.028 1.041.637 1.605.615.564 1.684.564 1.201 0 2.205-.718v1.37q-1.026.645-2.71.644-1.655 0-2.6-1.018-.938-1.026-.938-2.878 0-1.75 1.033-2.85 1.04-1.105 2.578-1.105t2.38.988.843 2.747zm-1.64-1.2q-.009-.915-.433-1.421-.425-.513-1.172-.513a1.66 1.66 0 0 0-1.245.535q-.505.534-.623 1.399zM77.707 9.398q-.307-.242-.886-.242-.754 0-1.26.681-.505.681-.505 1.853v3.59h-1.7v-7.5h1.7v1.545h.029q.249-.792.762-1.23a1.73 1.73 0 0 1 1.157-.448q.461 0 .703.14zM91.345 15.28h-2.036l-1.678-2.813a5 5 0 0 0-.446-.66 2.4 2.4 0 0 0-.44-.453 1.4 1.4 0 0 0-.483-.257 2 2 0 0 0-.594-.08h-.703v4.262H83.23V4.776h3.457a5 5 0 0 1 1.363.176q.622.176 1.084.535.461.351.718.886.263.528.263 1.238 0 .556-.168 1.025a2.6 2.6 0 0 1-.469.828q-.3.36-.732.615-.425.256-.96.396v.029q.286.16.498.359.213.19.403.395t.374.47q.19.255.417.6zm-6.38-9.09v3.413h1.45q.404 0 .74-.124.344-.124.594-.36.249-.234.388-.57.14-.338.139-.755 0-.754-.476-1.18-.477-.424-1.37-.424zM98.34 11.99h-5.113q.03 1.041.637 1.605.615.564 1.685.564 1.2 0 2.204-.718v1.37q-1.025.645-2.71.644-1.655 0-2.6-1.018-.937-1.026-.937-2.878 0-1.75 1.033-2.85 1.04-1.105 2.578-1.105t2.38.988.842 2.747zm-1.641-1.2q-.008-.915-.432-1.421-.426-.513-1.172-.513a1.66 1.66 0 0 0-1.245.535q-.506.534-.623 1.399zM106.784 14.679q0 4.13-4.153 4.13-1.464 0-2.556-.49v-1.553q1.23.703 2.337.703 2.673 0 2.673-2.63v-.82h-.029q-.843 1.437-2.535 1.436-1.37 0-2.211-.996-.835-1.003-.835-2.688 0-1.912.9-3.04.901-1.127 2.476-1.127 1.487 0 2.205 1.215h.029V7.78h1.699zm-1.684-2.835v-.974q0-.79-.528-1.348a1.7 1.7 0 0 0-1.303-.563q-.967 0-1.517.717-.542.711-.542 1.992 0 1.107.52 1.773.528.66 1.392.66.879 0 1.428-.63.55-.639.55-1.627M109.853 6.205q-.418 0-.718-.271a.9.9 0 0 1-.293-.689q0-.417.293-.696.3-.278.718-.278.432 0 .732.278a.9.9 0 0 1 .301.696q0 .395-.301.681-.3.279-.732.279m.842 9.074h-1.699v-7.5h1.699zM112.453 15.045V13.47q.953.726 2.102.725 1.538 0 1.538-.908a.7.7 0 0 0-.132-.432 1.2 1.2 0 0 0-.358-.322 2.7 2.7 0 0 0-.528-.25l-.674-.248a8 8 0 0 1-.835-.389 2.7 2.7 0 0 1-.615-.46 1.8 1.8 0 0 1-.366-.594 2.2 2.2 0 0 1-.125-.77q0-.54.257-.951.256-.418.688-.696.433-.285.982-.425a4.4 4.4 0 0 1 1.135-.146q1.04 0 1.86.314v1.487q-.79-.542-1.816-.542-.322 0-.586.066a1.5 1.5 0 0 0-.439.183.9.9 0 0 0-.286.286.66.66 0 0 0-.103.359q0 .242.103.41a1 1 0 0 0 .3.3 3 3 0 0 0 .484.235q.285.102.651.227.484.197.865.402.387.205.659.47.272.255.417.6.147.337.147.806 0 .57-.264.996a2.2 2.2 0 0 1-.703.703 3.2 3.2 0 0 1-1.018.41q-.572.14-1.209.14-1.23 0-2.131-.411M123.352 15.199q-.498.249-1.311.249-2.183 0-2.183-2.095v-4.24h-1.253V7.778h1.253V6.043l1.699-.483v2.22h1.795v1.332h-1.795v3.75q0 .667.242.953t.805.285q.433 0 .748-.249zM129.167 9.398q-.307-.242-.886-.242-.755 0-1.26.681t-.505 1.853v3.59h-1.7v-7.5h1.7v1.545h.029q.249-.792.762-1.23a1.73 1.73 0 0 1 1.157-.448q.461 0 .703.14zM136.125 15.28h-1.648v-1.173h-.029q-.777 1.348-2.278 1.348-1.106 0-1.736-.6-.622-.6-.622-1.59 0-2.124 2.446-2.475l2.226-.315q0-1.605-1.523-1.604-1.34 0-2.417.922V8.307q1.186-.704 2.739-.703 2.842 0 2.842 2.797zm-1.641-3.685-1.574.22q-.733.095-1.106.359-.366.256-.366.908 0 .476.336.784.345.3.916.3.777 0 1.282-.542.512-.549.512-1.377zM142.16 15.199q-.498.249-1.311.249-2.182 0-2.182-2.095v-4.24h-1.253V7.778h1.253V6.043l1.699-.483v2.22h1.794v1.332h-1.794v3.75q0 .667.241.953.243.285.806.285.432 0 .747-.249zM144.482 6.205q-.417 0-.718-.271a.9.9 0 0 1-.293-.689q0-.417.293-.696.3-.278.718-.278.432 0 .732.278a.9.9 0 0 1 .301.696q0 .395-.301.681-.3.279-.732.279m.842 9.074h-1.699v-7.5h1.699zM150.876 15.455q-1.736 0-2.776-1.047-1.032-1.055-1.033-2.79 0-1.89 1.077-2.952 1.084-1.062 2.915-1.062 1.758 0 2.739 1.032.982 1.033.982 2.864 0 1.795-1.062 2.878-1.055 1.077-2.842 1.077m.081-6.496q-.997 0-1.575.695-.579.696-.579 1.92 0 1.178.586 1.86.586.673 1.568.673 1.002 0 1.538-.666.542-.667.542-1.897 0-1.238-.542-1.912-.536-.673-1.538-.673M163.195 15.28h-1.699v-4.227q0-2.102-1.487-2.102-.776 0-1.281.586-.506.579-.506 1.465v4.277h-1.706v-7.5h1.706v1.245h.029q.843-1.42 2.432-1.42 1.224 0 1.868.798.644.79.644 2.292zM55.749 34.287l-.96-1.018q-.315.278-.703.505a5.253 5.253 0 0 1-1.7.608 5.4 5.4 0 0 1-.929.08 4.7 4.7 0 0 1-1.428-.205 3.3 3.3 0 0 1-1.092-.578 2.7 2.7 0 0 1-.695-.909A2.8 2.8 0 0 1 48 31.6q0-1.81 2.402-3.047-1.106-1.37-1.106-2.432 0-.55.213-1.01.22-.462.608-.792.388-.336.923-.527.54-.19 1.179-.19.608 0 1.098.168.498.168.85.469.351.3.542.718.19.409.19.893 0 .476-.124.864a2.2 2.2 0 0 1-.388.718q-.264.338-.703.645-.432.308-1.062.615.578.623 1.164 1.238.594.615 1.201 1.238.154-.236.279-.528.13-.293.22-.615a4.9 4.9 0 0 0 .197-1.34h1.487q0 2.014-1.275 3.522.33.352.828.865.506.513 1.187 1.216zm-2.38-8.306q0-.241-.096-.454a1.1 1.1 0 0 0-.241-.366 1.1 1.1 0 0 0-.36-.25 1 1 0 0 0-.439-.095q-.307 0-.564.096a1.19 1.19 0 0 0-.71.666 1.4 1.4 0 0 0-.095.52q0 .674.96 1.743 1.545-.79 1.545-1.86m.534 6.335q-.857-.886-2.68-2.856-.807.417-1.165.893a1.82 1.82 0 0 0-.352 1.114q0 .388.14.703.147.307.395.527t.586.337q.344.117.74.117 1.377 0 2.336-.835M74.704 34.28h-1.728v-6.798q0-.834.102-2.043h-.03q-.16.688-.285.989l-3.135 7.851h-1.2l-3.143-7.793q-.131-.344-.278-1.047h-.03q.06.63.06 2.058v6.782h-1.612V23.776h2.453l2.762 6.995q.314.806.41 1.201h.036q.272-.828.44-1.23l2.812-6.966h2.366zM83.457 30.99h-5.113q.03 1.041.637 1.605.615.564 1.685.564 1.2 0 2.205-.718v1.37q-1.026.645-2.71.644-1.656 0-2.6-1.018-.939-1.026-.938-2.878 0-1.75 1.033-2.85 1.04-1.105 2.578-1.105t2.38.988.843 2.747zm-1.641-1.2q-.007-.915-.432-1.421-.425-.513-1.172-.513a1.66 1.66 0 0 0-1.245.535q-.506.534-.623 1.399zM96.289 34.28h-1.7v-4.088q0-1.18-.337-1.706-.33-.527-1.12-.527-.667 0-1.135.666-.462.666-.462 1.597v4.057H89.83v-4.226q0-2.094-1.48-2.094-.688 0-1.135.63-.44.63-.44 1.633v4.057h-1.699v-7.5h1.7v1.187h.029q.813-1.363 2.365-1.363.777 0 1.355.433.586.424.799 1.12.835-1.552 2.49-1.552 2.476 0 2.476 3.054zM100.09 33.195h-.029v1.084h-1.7V23.176h1.7v4.922h.029q.872-1.494 2.549-1.494 1.42 0 2.219 1.01.806 1.005.806 2.696 0 1.882-.901 3.017-.901 1.128-2.461 1.128-1.465 0-2.212-1.26m-.044-2.98v.93q0 .82.52 1.391.527.571 1.333.571.945 0 1.479-.732.542-.74.542-2.058 0-1.106-.505-1.729-.498-.63-1.355-.63-.908 0-1.465.645-.549.645-.549 1.611M113.75 30.99h-5.113q.03 1.041.637 1.605.616.564 1.685.564 1.202 0 2.205-.718v1.37q-1.026.645-2.71.644-1.656 0-2.6-1.018-.938-1.026-.938-2.878 0-1.75 1.033-2.85 1.04-1.105 2.578-1.105t2.38.988q.843.99.843 2.747zm-1.641-1.2q-.007-.915-.432-1.421-.425-.513-1.172-.513-.732 0-1.245.535-.506.534-.623 1.399zM119.719 28.398q-.308-.242-.886-.242-.754 0-1.26.681t-.506 1.853v3.59h-1.699v-7.5h1.699v1.545h.03q.25-.792.761-1.23a1.74 1.74 0 0 1 1.158-.447q.461 0 .703.139zM120.554 34.045V32.47a3.4 3.4 0 0 0 2.102.725q1.538 0 1.538-.908a.7.7 0 0 0-.132-.432 1.2 1.2 0 0 0-.359-.322 2.6 2.6 0 0 0-.527-.25l-.674-.248a7 7 0 0 1-.835-.389 2.7 2.7 0 0 1-.615-.46 1.8 1.8 0 0 1-.366-.594 2.2 2.2 0 0 1-.125-.77q0-.54.256-.951.257-.418.689-.696a3.2 3.2 0 0 1 .981-.425 4.4 4.4 0 0 1 1.136-.146q1.04 0 1.86.315v1.486q-.791-.542-1.816-.542-.323 0-.586.066a1.5 1.5 0 0 0-.44.183.9.9 0 0 0-.286.286.66.66 0 0 0-.102.359q0 .242.102.41a1 1 0 0 0 .301.3q.205.124.483.235.286.102.652.227.483.198.864.402.389.206.659.47.271.255.418.6.147.337.146.805 0 .571-.263.997a2.2 2.2 0 0 1-.703.703 3.2 3.2 0 0 1-1.018.41q-.572.14-1.209.14-1.23 0-2.131-.411M134.162 34.28h-1.699v-4.102q0-2.227-1.487-2.227-.747 0-1.26.645-.512.645-.512 1.648v4.035h-1.707V23.176h1.707v4.848h.029q.85-1.42 2.432-1.42 2.497 0 2.497 3.054zM137.084 25.205q-.417 0-.717-.271a.9.9 0 0 1-.293-.689q0-.417.293-.696.3-.278.717-.278.433 0 .733.278.3.279.3.696 0 .395-.3.681-.3.279-.733.279m.843 9.074h-1.699v-7.5h1.699zM141.882 33.173h-.029v4.556h-1.7v-10.95h1.7v1.319h.029q.871-1.494 2.549-1.494 1.428 0 2.226 1.003.799 1.003.799 2.695 0 1.875-.901 3.003t-2.461 1.128q-1.436 0-2.212-1.26m-.044-2.959v.93q0 .82.52 1.392.527.571 1.333.571.945 0 1.479-.732.542-.74.542-2.058 0-1.106-.505-1.729-.498-.63-1.355-.63-.908 0-1.465.645-.549.645-.549 1.611"
    />
  </chakra.svg>
));

export const AdvancedFieldsLogo = React.forwardRef((props, ref) => (
	<chakra.svg
		viewBox="0 0 24 24"
		xmlns="https://www.w3.org/2000/svg"
		height="24px"
		width="24px"
		ref={ref}
		{...props}
	>
		<path
			d="M17.2503 12.7496C17.2503 13.1946 17.1183 13.6296 16.8711 13.9997C16.6239 14.3697 16.2725 14.6581 15.8614 14.8284C15.4502 14.9987 14.9978 15.0433 14.5614 14.9565C14.1249 14.8696 13.724 14.6554 13.4093 14.3407C13.0946 14.026 12.8803 13.6251 12.7935 13.1887C12.7067 12.7522 12.7512 12.2998 12.9215 11.8887C13.0918 11.4776 13.3802 11.1261 13.7502 10.8789C14.1202 10.6317 14.5552 10.4997 15.0002 10.4997C15.597 10.4997 16.1693 10.7367 16.5912 11.1586C17.0132 11.5806 17.2503 12.1529 17.2503 12.7496ZM19.5004 19.4996L10.5004 19.4998L10.5004 17.7823C11.0634 17.1438 11.7559 16.6325 12.5317 16.2822C13.3076 15.932 14.1491 15.7508 15.0003 15.7508C15.8516 15.7508 16.6931 15.9319 17.469 16.2821C18.2449 16.6323 18.9373 17.1436 19.5004 17.7821L19.5004 19.4996ZM3.00018 8.99996L6.00018 8.99989L6.00029 13.4999L4.50029 13.4999L4.50032 14.9999L9.00032 14.9998L9.00029 13.4998L7.50029 13.4999L7.50018 8.99986L21.0002 8.99953L21.0005 20.9995L3.00047 21L3.00018 8.99996ZM1.5005 22.5L22.5005 22.4995L22.5001 7.4995L7.50014 7.49986L7.50004 2.99986L9.00004 2.99982L9 1.49982L4.5 1.49993L4.50004 2.99993L6.00004 2.99989L6.00014 7.49989L1.50014 7.5L1.5005 22.5Z"
			fill="#475BB2"
		/>
	</chakra.svg>
));
export const CustomizeMyAccountLogo = React.forwardRef((props, ref) => (
	<chakra.svg
		viewBox="0 0 24 24"
		xmlns="https://www.w3.org/2000/svg"
		height="24px"
		width="24px"
		ref={ref}
		{...props}
		fill="none"
	>
		<path
			d="M12.886 2H12.446C11.9156 2 11.4069 2.21071 11.0318 2.58579C10.6567 2.96086 10.446 3.46957 10.446 4V4.18C10.4457 4.53073 10.3531 4.87519 10.1776 5.17884C10.002 5.48248 9.74975 5.73464 9.44602 5.91L9.01602 6.16C8.71198 6.33554 8.36709 6.42795 8.01602 6.42795C7.66494 6.42795 7.32006 6.33554 7.01602 6.16L6.86602 6.08C6.40708 5.81526 5.86185 5.74344 5.35002 5.88031C4.83818 6.01717 4.40157 6.35154 4.13602 6.81L3.91602 7.19C3.65128 7.64893 3.57946 8.19416 3.71633 8.706C3.85319 9.21783 4.18755 9.65445 4.64602 9.92L4.79602 10.02C5.09829 10.1945 5.34964 10.4451 5.52507 10.7468C5.7005 11.0486 5.79391 11.391 5.79602 11.74V12.25C5.79742 12.6024 5.70567 12.949 5.53006 13.2545C5.35445 13.5601 5.10123 13.8138 4.79602 13.99L4.64602 14.08C4.18755 14.3456 3.85319 14.7822 3.71633 15.294C3.57946 15.8058 3.65128 16.3511 3.91602 16.81L4.13602 17.19C4.40157 17.6485 4.83818 17.9828 5.35002 18.1197C5.86185 18.2566 6.40708 18.1847 6.86602 17.92L7.01602 17.84C7.32006 17.6645 7.66494 17.5721 8.01602 17.5721C8.36709 17.5721 8.71198 17.6645 9.01602 17.84L9.44602 18.09C9.74975 18.2654 10.002 18.5175 10.1776 18.8212C10.3531 19.1248 10.4457 19.4693 10.446 19.82V20C10.446 20.5304 10.6567 21.0391 11.0318 21.4142C11.4069 21.7893 11.9156 22 12.446 22H12.886C13.4165 22 13.9252 21.7893 14.3002 21.4142C14.6753 21.0391 14.886 20.5304 14.886 20V19.82C14.8864 19.4693 14.979 19.1248 15.1545 18.8212C15.33 18.5175 15.5823 18.2654 15.886 18.09L16.316 17.84C16.6201 17.6645 16.9649 17.5721 17.316 17.5721C17.6671 17.5721 18.012 17.6645 18.316 17.84L18.466 17.92C18.925 18.1847 19.4702 18.2566 19.982 18.1197C20.4939 17.9828 20.9305 17.6485 21.196 17.19L21.416 16.8C21.6808 16.3411 21.7526 15.7958 21.6157 15.284C21.4788 14.7722 21.1445 14.3356 20.686 14.07L20.536 13.99C20.2308 13.8138 19.9776 13.5601 19.802 13.2545C19.6264 12.949 19.5346 12.6024 19.536 12.25V11.75C19.5346 11.3976 19.6264 11.051 19.802 10.7455C19.9776 10.4399 20.2308 10.1862 20.536 10.01L20.686 9.92C21.1445 9.65445 21.4788 9.21783 21.6157 8.706C21.7526 8.19416 21.6808 7.64893 21.416 7.19L21.196 6.81C20.9305 6.35154 20.4939 6.01717 19.982 5.88031C19.4702 5.74344 18.925 5.81526 18.466 6.08L18.316 6.16C18.012 6.33554 17.6671 6.42795 17.316 6.42795C16.9649 6.42795 16.6201 6.33554 16.316 6.16L15.886 5.91C15.5823 5.73464 15.33 5.48248 15.1545 5.17884C14.979 4.87519 14.8864 4.53073 14.886 4.18V4C14.886 3.46957 14.6753 2.96086 14.3002 2.58579C13.9252 2.21071 13.4165 2 12.886 2Z"
			stroke="#475BB2"
			strokeWidth="1.5"
			strokeLinecap="round"
			strokeLinejoin="round"
		/>
		<path
			d="M12.666 15C14.3229 15 15.666 13.6569 15.666 12C15.666 10.3431 14.3229 9 12.666 9C11.0092 9 9.66602 10.3431 9.66602 12C9.66602 13.6569 11.0092 15 12.666 15Z"
			stroke="#475BB2"
			strokeWidth="1.5"
			strokeLinecap="round"
			strokeLinejoin="round"
		/>
	</chakra.svg>
));

export const WooCommerceLogo = React.forwardRef((props, ref) => (
	<chakra.svg
		xmlns="https://www.w3.org/2000/svg"
		height="24px"
		width="27px"
		ref={ref}
		viewBox="0 0 27 24"
		{...props}
	>
		<path
			fill="#475BB2"
			d="M5.03703 4.41602C3.39276 4.41602 1.72266 5.7541 1.72266 7.39837V15.3513C1.72266 16.9956 3.39276 18.3337 5.03703 18.3337H12.6172L18.9547 20.3219L18.4867 18.3337H22.9311C24.5754 18.3337 25.9135 16.9956 25.9135 15.3513V7.39837C25.9135 5.7541 24.5754 4.41602 22.9311 4.41602H5.03703ZM5.03897 5.90719L14.1491 5.90719L22.9311 5.90719C23.4789 5.90719 24.5874 6.85061 24.5874 7.39837V15.3513C24.5874 15.8991 23.4789 17.0472 22.9311 17.0472H18.5411H16.1665L17.1315 18.3337L13.322 17.0472H12.9317H12.6172L5.03897 17.0472C4.49121 17.0472 2.91482 15.8991 2.91482 15.3513V7.40031C2.91482 6.85255 4.49121 5.90719 5.03897 5.90719ZM12.2424 7.39837C11.9528 7.39963 11.6736 7.57223 11.5551 7.85853C11.1187 8.90733 10.8124 10.2311 10.6464 11.767C10.1474 10.3643 9.87279 9.01432 9.86782 8.99245C9.8032 8.66936 9.53468 8.42719 9.2096 8.39637C8.87757 8.35959 8.57374 8.55333 8.44848 8.85653L7.08739 12.1845C6.83887 10.9935 6.58686 9.49173 6.5282 8.11289C6.5123 7.70132 6.15014 7.36651 5.75349 7.40031C5.34193 7.41621 5.02108 7.76346 5.03897 8.17502C5.16522 11.2111 6.14278 14.6644 6.18453 14.8096C6.27102 15.1158 6.54504 15.3315 6.86216 15.3494C7.17432 15.3683 7.47193 15.1815 7.59222 14.8873L8.98437 11.4855C9.36114 12.6894 9.92327 14.1235 10.6639 15.0659C10.809 15.2488 11.0256 15.3513 11.2503 15.3513C11.3318 15.3513 11.4134 15.3374 11.493 15.3105C11.7932 15.2061 11.9958 14.9228 11.9958 14.6057C11.9958 12.0737 12.3293 9.87979 12.9317 8.42938C13.0898 8.05062 12.9105 7.61468 12.5298 7.45662C12.4361 7.4171 12.339 7.39795 12.2424 7.39837ZM15.7238 8.39248C14.6362 8.39646 13.6252 9.44964 13.322 10.9438C13.1301 11.8942 13.2749 12.8507 13.7103 13.5048C14.0056 13.9472 14.409 14.2307 14.8792 14.3242C14.9905 14.3461 15.1028 14.3572 15.2131 14.3572C16.3017 14.3572 17.3243 13.3079 17.6285 11.8078C17.8204 10.8574 17.6756 9.90093 17.2402 9.2468C16.945 8.80442 16.5406 8.52088 16.0694 8.42743C15.9531 8.40357 15.8381 8.39248 15.7238 8.39248ZM20.9429 8.39248C19.8563 8.39646 18.8453 9.44964 18.5411 10.9438C18.3492 11.8942 18.494 12.8507 18.9294 13.5048C19.2247 13.9472 19.6281 14.2307 20.0983 14.3242C20.2096 14.3461 20.3219 14.3572 20.4323 14.3572C21.5208 14.3572 22.5434 13.3079 22.8476 11.8078C23.0395 10.8574 22.8947 9.90093 22.4593 9.2468C22.1641 8.80442 21.7597 8.52088 21.2885 8.42743C21.1722 8.40357 21.0572 8.39248 20.9429 8.39248ZM15.7413 9.8856C15.7532 9.8856 15.7662 9.8875 15.7782 9.88948C15.8716 9.90837 15.9508 9.99943 15.9995 10.072C16.1615 10.3166 16.3037 10.8397 16.1665 11.5127C15.9806 12.4352 15.4318 12.9079 15.1724 12.8621C15.0789 12.8432 15.0017 12.7522 14.953 12.6796C14.7909 12.4351 14.6488 11.9119 14.786 11.2389C14.9639 10.3571 15.4818 9.8856 15.7413 9.8856ZM20.9604 9.8856C20.9723 9.8856 20.9853 9.8875 20.9973 9.88948C21.0907 9.90837 21.1699 9.99943 21.2186 10.072C21.3807 10.3166 21.5228 10.8397 21.3856 11.5127C21.1997 12.4352 20.644 12.9079 20.3915 12.8621C20.298 12.8432 20.2208 12.7522 20.1721 12.6796C20.01 12.4351 19.8679 11.9119 20.0051 11.2389C20.183 10.3571 20.7009 9.8856 20.9604 9.8856Z"
		/>
	</chakra.svg>
));

export const ContentRestrictionLogo = React.forwardRef((props, ref) => (
	<chakra.svg
		viewBox="0 0 24 24"
		xmlns="https://www.w3.org/2000/svg"
		height="24px"
		width="24px"
		ref={ref}
		fill="none"
		{...props}
	>
		<path
			d="M12 17C12.5523 17 13 16.5523 13 16C13 15.4477 12.5523 15 12 15C11.4477 15 11 15.4477 11 16C11 16.5523 11.4477 17 12 17Z"
			stroke="#475BB2"
			strokeWidth="1.5"
			strokeLinecap="round"
			strokeLinejoin="round"
		/>
		<path
			d="M19 10H5C3.89543 10 3 10.8954 3 12V20C3 21.1046 3.89543 22 5 22H19C20.1046 22 21 21.1046 21 20V12C21 10.8954 20.1046 10 19 10Z"
			stroke="#475BB2"
			strokeWidth="1.5"
			strokeLinecap="round"
			strokeLinejoin="round"
		/>
		<path
			d="M7 10V7C7 5.67392 7.52678 4.40215 8.46447 3.46447C9.40215 2.52678 10.6739 2 12 2C13.3261 2 14.5979 2.52678 15.5355 3.46447C16.4732 4.40215 17 5.67392 17 7V10"
			stroke="#475BB2"
			strokeWidth="1.5"
			strokeLinecap="round"
			strokeLinejoin="round"
		/>
	</chakra.svg>
));
export const StyleCustomizerLogo = React.forwardRef((props, ref) => (
	<chakra.svg
		viewBox="0 0 25 24"
		xmlns="https://www.w3.org/2000/svg"
		height="24px"
		width="25px"
		ref={ref}
		fill="none"
		{...props}
	>
		<path
			d="M15.2874 17.8974L4.60742 14.9844"
			stroke="#475BB2"
			strokeWidth="1.5"
			strokeLinecap="round"
			strokeLinejoin="round"
		/>
		<path
			d="M19.0414 2.62173C19.2386 2.42462 19.4726 2.26826 19.7301 2.16158C19.9876 2.05491 20.2637 2 20.5424 2C20.8212 2 21.0972 2.05491 21.3548 2.16158C21.6123 2.26826 21.8463 2.42462 22.0434 2.62173C22.2406 2.81885 22.3969 3.05286 22.5036 3.3104C22.6103 3.56794 22.6652 3.84397 22.6652 4.12273C22.6652 4.4015 22.6103 4.67753 22.5036 4.93507C22.3969 5.19261 22.2406 5.42662 22.0434 5.62373L18.0254 9.64273C17.9317 9.7365 17.879 9.86365 17.879 9.99623C17.879 10.1288 17.9317 10.256 18.0254 10.3497L18.9694 11.2937C19.4213 11.7457 19.6752 12.3586 19.6752 12.9977C19.6752 13.6368 19.4213 14.2498 18.9694 14.7017L18.0254 15.6457C17.9317 15.7395 17.8045 15.7921 17.6719 15.7921C17.5394 15.7921 17.4122 15.7395 17.3184 15.6457L9.01944 7.34773C8.92571 7.25397 8.87305 7.12682 8.87305 6.99424C8.87305 6.86165 8.92571 6.7345 9.01944 6.64073L9.96344 5.69673C10.4154 5.24485 11.0283 4.99099 11.6674 4.99099C12.3065 4.99099 12.9195 5.24485 13.3714 5.69673L14.3154 6.64073C14.4092 6.73447 14.5364 6.78713 14.6689 6.78713C14.8015 6.78713 14.9287 6.73447 15.0224 6.64073L19.0414 2.62173Z"
			stroke="#475BB2"
			strokeWidth="1.5"
			strokeLinecap="round"
			strokeLinejoin="round"
		/>
		<path
			d="M9.66691 8C7.86291 10.71 5.69691 11.46 3.08391 11.948C2.99723 11.9638 2.91617 12.002 2.84872 12.0587C2.78127 12.1154 2.72976 12.1887 2.69928 12.2713C2.66879 12.354 2.66038 12.4432 2.67487 12.5301C2.68936 12.617 2.72626 12.6987 2.78191 12.767L10.1019 21.65C10.2506 21.8079 10.4466 21.9132 10.6603 21.95C10.8741 21.9868 11.094 21.9531 11.2869 21.854C13.4019 20.405 16.6669 16.792 16.6669 15"
			stroke="#475BB2"
			strokeWidth="1.5"
			strokeLinecap="round"
			strokeLinejoin="round"
		/>
	</chakra.svg>
));

export const CheckIcon = React.forwardRef((props, ref) => (
	<chakra.svg
		viewBox="0 0 34 34"
		xmlns="https://www.w3.org/2000/svg"
		height="34px"
		width="34px"
		ref={ref}
		fill="none"
		{...props}
	>
		<path
			d="M26.293 10.125L24.4023 12.0156L20.6211 15.7969L13.0586 23.3594L9.62109 19.9219L7.90234 18.2031L7.04297 17.3438"
			stroke="#4CA772"
			strokeWidth="3.4375"
			strokeLinecap="round"
			strokeLinejoin="round"
		/>
	</chakra.svg>
));

export const RightArrowIcon = React.forwardRef((props, ref) => (
	<chakra.svg
		viewBox="0 0 18 18"
		xmlns="https://www.w3.org/2000/svg"
		height="18px"
		width="18px"
		ref={ref}
		fill="none"
		{...props}
	>
		<path
			d="M3.75 9H14.25"
			stroke="#383838"
			strokeWidth="1.5"
			strokeLinecap="round"
			strokeLinejoin="round"
		/>
		<path
			d="M9 3.75L14.25 9L9 14.25"
			stroke="#383838"
			strokeWidth="1.5"
			strokeLinecap="round"
			strokeLinejoin="round"
		/>
	</chakra.svg>
));

export const DeleteIcon = React.forwardRef((props, ref) => (
		<chakra.svg
			viewBox="0 0 16 16"
			xmlns="http://www.w3.org/2000/svg"
			height="16px"
			width="16px"
			ref={ref}
			fill="none"
			{...props}
		>
			<g fill="currentColor" clipPath="url(#delete-icon-clip)">
				<path d="M6 11.334v-4a.667.667 0 0 1 1.334 0v4a.667.667 0 0 1-1.334 0M8.666 11.334v-4a.667.667 0 0 1 1.334 0v4a.667.667 0 0 1-1.334 0" />
				<path d="M2.666 13.333V4A.667.667 0 0 1 4 4v9.333a.667.667 0 0 0 .666.667h6.667a.667.667 0 0 0 .667-.667V4a.667.667 0 1 1 1.333 0v9.333a2 2 0 0 1-2 2H4.666a2 2 0 0 1-2-2" />
				<path d="M14 3.333a.667.667 0 0 1 0 1.334H2a.667.667 0 0 1 0-1.334z" />
				<path d="M10 4V2.667A.667.667 0 0 0 9.333 2H6.666A.666.666 0 0 0 6 2.667V4a.667.667 0 0 1-1.334 0V2.667a2 2 0 0 1 2-2h2.667a2 2 0 0 1 2 2V4A.667.667 0 0 1 10 4" />
			</g>
			<defs>
				<clipPath id="delete-icon-clip">
					<path fill="#fff" d="M0 0h16v16H0z" />
				</clipPath>
			</defs>
		</chakra.svg>
	)
);

URMLogo.displayName = "URMLogo";
AdvancedFieldsLogo.displayName = "AdvancedFieldsLogo";
WooCommerceLogo.displayName = "WooCommerceLogo";
AdvancedFieldsLogo.displayName = "AdvancedFieldsLogo";
ContentRestrictionLogo.displayName = "ContentRestrictionLogo";
StyleCustomizerLogo.displayName = "StyleCustomizerLogo";
CheckIcon.displayName = "CheckIcon";
RightArrowIcon.displayName = "RightArrowIcon";
DeleteIcon.displayName = "DeleteIcon";
