/* eslint-disable max-len */
import { chakra, IconProps } from "@chakra-ui/react";
import React from "react";

export const Logo = React.forwardRef((props, ref) => (
	<chakra.svg
		viewBox="0 0 36 36"
		xmlns="https://www.w3.org/2000/svg"
		ref={ref}
		{...props}
	>
		<path
			fill="#475BB2"
			fillRule="evenodd"
			d="M32.8951 2.53619C30.4998 3.94519 28.2454 5.77691 26.2728 7.74951C24.3002 9.72212 22.4685 11.9765 21.0595 14.2309C22.0458 16.2035 22.8912 18.1761 23.5957 20.2896C24.8638 17.6125 26.4137 15.2172 28.3863 13.1037V20.7123C28.3863 25.362 25.2865 29.4481 20.7777 30.7162H20.4959C20.2141 27.0528 19.3687 23.5303 18.1006 20.1487C16.2689 15.499 13.4508 11.272 9.78744 7.74951C7.81484 5.77691 5.56046 4.08609 3.16515 2.53619L2.60156 2.25437V20.5714C2.60156 28.0391 7.95574 34.5205 15.4234 35.7887H15.5644C17.2552 36.0704 18.946 36.0704 20.4959 35.7887H20.6368C28.1045 34.5205 33.4587 28.0391 33.4587 20.5714V2.25437L32.8951 2.53619ZM7.67394 20.5714V13.1037C12.0418 18.0352 14.719 24.0939 15.2826 30.5753C10.7738 29.3072 7.67394 25.2211 7.67394 20.5714ZM17.9597 0C15.8462 0 14.1554 1.69078 14.1554 3.80428C14.1554 5.91778 15.8462 7.6086 17.9597 7.6086C20.0732 7.6086 21.764 5.91778 21.764 3.80428C21.764 1.69078 20.0732 0 17.9597 0Z"
			clipRule="evenodd"
		/>
	</chakra.svg>
));

export const Shortcode = React.forwardRef((props, ref) => (
	<chakra.svg
		viewBox="0 0 36 36"
		xmlns="https://www.w3.org/2000/svg"
		ref={ref}
		{...props}
	>
		<path
			fillRule="evenodd"
			d="M23.293 9.96a1 1 0 0 1 1.414 0l5.333 5.332a1 1 0 0 1 0 1.415l-5.333 5.333a1 1 0 0 1-1.414-1.414L27.919 16l-4.626-4.627a1 1 0 0 1 0-1.414Zm-14.587 0a1 1 0 0 1 0 1.413L4.08 16l4.626 4.626a1 1 0 0 1-1.414 1.414L1.96 16.707a1 1 0 0 1 0-1.415L7.292 9.96a1 1 0 0 1 1.414 0Zm10.925-5.582a1 1 0 0 1 .656 1.253l-6.666 21.333a1 1 0 0 1-1.91-.597l6.667-21.333a1 1 0 0 1 1.253-.656Z"
			clipRule="evenodd"
		/>
	</chakra.svg>
));

export const SmartTag = React.forwardRef((props, ref) => (
	<chakra.svg
		viewBox="0 0 36 36"
		xmlns="https://www.w3.org/2000/svg"
		ref={ref}
		{...props}
	>
		<path
			fillRule="evenodd"
			d="M5.408 2.742A3.667 3.667 0 0 1 8 1.668h12a1 1 0 0 1 .707.293l6.666 6.667a1 1 0 0 1 .293.707v17.333A3.667 3.667 0 0 1 24 30.335H5.334a1 1 0 1 1 0-2h18.667a1.667 1.667 0 0 0 1.666-1.667V9.748l-6.08-6.08H8a1.667 1.667 0 0 0-1.667 1.667v5.333a1 1 0 1 1-2 0V5.335c0-.973.386-1.905 1.074-2.593Z"
			clipRule="evenodd"
		/>
		<path
			fillRule="evenodd"
			d="M18.666 1.668a1 1 0 0 1 1 1v5.333a1.667 1.667 0 0 0 1.667 1.667h5.333a1 1 0 0 1 0 2h-5.333a3.666 3.666 0 0 1-3.667-3.667V2.668a1 1 0 0 1 1-1ZM3.683 15.684a2.333 2.333 0 0 1 1.65-.683 1 1 0 1 1 0 2 .333.333 0 0 0-.334.333v1.334c0 .48-.148.944-.418 1.333.27.389.418.853.418 1.333v1.334a.333.333 0 0 0 .334.333 1 1 0 1 1 0 2 2.334 2.334 0 0 1-2.334-2.333v-1.334a.333.333 0 0 0-.333-.333 1 1 0 1 1 0-2 .333.333 0 0 0 .333-.333v-1.334c0-.619.246-1.212.684-1.65Zm5.983.317a1 1 0 0 1 1-1 2.333 2.333 0 0 1 2.333 2.333v1.334a.333.333 0 0 0 .334.333 1 1 0 1 1 0 2 .333.333 0 0 0-.334.333v1.334A2.333 2.333 0 0 1 10.666 25a1 1 0 1 1 0-2 .333.333 0 0 0 .333-.333v-1.334c0-.48.148-.944.419-1.333a2.334 2.334 0 0 1-.419-1.333v-1.334a.333.333 0 0 0-.333-.333 1 1 0 0 1-1-1Z"
			clipRule="evenodd"
		/>
	</chakra.svg>
));

export const Search = React.forwardRef((props, ref) => (
	<chakra.svg
		viewBox="0 0 18 18"
		xmlns="https://www.w3.org/2000/svg"
		ref={ref}
		{...props}
	>
		<path
			fill="white"
			fillRule="evenodd"
			d="M7.33333 12.6667C10.2789 12.6667 12.6667 10.2789 12.6667 7.33333C12.6667 4.38781 10.2789 2 7.33333 2C4.38781 2 2 4.38781 2 7.33333C2 10.2789 4.38781 12.6667 7.33333 12.6667Z"
			stroke="#909090"
			strokeWidth="1.33333"
			strokeLinecap="round"
			strokeLinejoin="round"
			clipRule="evenodd"
		/>
		<path
			fillRule="evenodd"
			d="M13.9995 14.0005L11.1328 11.1338"
			stroke="#909090"
			strokeWidth="1.33333"
			strokeLinecap="round"
			strokeLinejoin="round"
			clipRule="evenodd"
		/>
	</chakra.svg>
));

export const Cog = React.forwardRef((props, ref) => (
	<chakra.svg
		viewBox="0 0 24 24"
		xmlns="https://www.w3.org/2000/svg"
		ref={ref}
		{...props}
	>
		<path
			fillRule="evenodd"
			d="M12 9.738a2.262 2.262 0 1 0 0 4.524 2.262 2.262 0 0 0 0-4.524ZM8.833 12a3.167 3.167 0 1 1 6.334 0 3.167 3.167 0 0 1-6.334 0Z"
			clipRule="evenodd"
		/>
		<path
			fillRule="evenodd"
			// eslint-disable-next-line
			d="M12 3.405a1.192 1.192 0 0 0-1.193 1.192v.143a1.81 1.81 0 0 1-1.096 1.656.452.452 0 0 1-.154.036 1.81 1.81 0 0 1-1.904-.4l-.003-.003-.05-.05a1.194 1.194 0 1 0-1.688 1.688l.053.053a1.81 1.81 0 0 1 .368 1.983 1.81 1.81 0 0 1-1.651 1.171h-.085a1.192 1.192 0 1 0 0 2.385h.142a1.81 1.81 0 0 1 1.655 1.095 1.81 1.81 0 0 1-.363 1.994l-.003.003-.05.05a1.194 1.194 0 1 0 1.688 1.688l.053-.053a1.81 1.81 0 0 1 1.983-.368 1.81 1.81 0 0 1 1.171 1.651v.084a1.192 1.192 0 1 0 2.385 0v-.143a1.81 1.81 0 0 1 1.095-1.655 1.809 1.809 0 0 1 1.994.363l.003.003.05.05a1.194 1.194 0 1 0 1.688-1.688l-.053-.053a1.81 1.81 0 0 1-.363-1.994 1.81 1.81 0 0 1 1.655-1.094h.076a1.192 1.192 0 1 0 0-2.386h-.143a1.81 1.81 0 0 1-1.656-1.096.453.453 0 0 1-.036-.154 1.81 1.81 0 0 1 .4-1.904l.003-.003.05-.05a1.193 1.193 0 1 0-1.688-1.688l-.053.053a1.81 1.81 0 0 1-1.994.363 1.81 1.81 0 0 1-1.094-1.655v-.076A1.192 1.192 0 0 0 12 3.405Zm-1.483-.29a2.097 2.097 0 0 1 3.58 1.482v.073a.905.905 0 0 0 .549.828l.004.002a.905.905 0 0 0 .997-.18l.047-.047A2.098 2.098 0 1 1 18.66 8.24l-.047.048a.905.905 0 0 0-.18.996c.02.045.033.093.037.142a.904.904 0 0 0 .793.477h.139a2.098 2.098 0 0 1 0 4.194h-.073a.905.905 0 0 0-.828.549l-.002.004a.905.905 0 0 0 .18.997l.047.047a2.097 2.097 0 0 1-1.483 3.582 2.097 2.097 0 0 1-1.484-.615l-.048-.047a.906.906 0 0 0-.996-.18l-.004.003a.905.905 0 0 0-.549.827v.139a2.098 2.098 0 0 1-4.195 0v-.069a.905.905 0 0 0-.618-.834.906.906 0 0 0-.997.18l-.001.001-.046.046a2.097 2.097 0 0 1-3.423-.68 2.098 2.098 0 0 1 .456-2.287l.047-.048a.905.905 0 0 0 .18-.996l-.003-.004a.905.905 0 0 0-.827-.549h-.139a2.098 2.098 0 0 1 0-4.195h.069A.905.905 0 0 0 5.5 9.35a.905.905 0 0 0-.18-.997l-.047-.047A2.098 2.098 0 1 1 8.24 5.34l.048.047a.905.905 0 0 0 .996.18.453.453 0 0 1 .142-.037.905.905 0 0 0 .477-.793v-.139c0-.556.22-1.09.614-1.483Z"
			clipRule="evenodd"
		/>
	</chakra.svg>
));

export const Meter = React.forwardRef((props, ref) => (
	<chakra.svg
		viewBox="0 0 24 24"
		xmlns="https://www.w3.org/2000/svg"
		{...props}
		ref={ref}
	>
		<path
			fillRule="evenodd"
			d="M16.425 9.576a.6.6 0 0 1 0 .848l-4 4a.6.6 0 0 1-.849-.848l4-4a.6.6 0 0 1 .849 0Z"
			clipRule="evenodd"
		/>
		<path
			fillRule="evenodd"
			d="M12 4.6a9.4 9.4 0 0 0-8.14 14.1.6.6 0 0 1-1.04.6 10.6 10.6 0 1 1 18.36 0 .6.6 0 0 1-1.04-.6A9.4 9.4 0 0 0 12 4.6Z"
			clipRule="evenodd"
		/>
	</chakra.svg>
));

export const ArrowsRepeat = React.forwardRef((props, ref) => (
	<chakra.svg
		viewBox="0 0 24 24"
		xmlns="https://www.w3.org/2000/svg"
		{...props}
		ref={ref}
	>
		<path
			fillRule="evenodd"
			d="M11.998 2.4H12a9.6 9.6 0 0 1 9.6 9.6.6.6 0 1 1-1.2 0 8.4 8.4 0 0 0-8.398-8.4A9.15 9.15 0 0 0 5.68 6.168L3.425 8.425a.6.6 0 0 1-.849-.849L4.843 5.31a10.35 10.35 0 0 1 7.155-2.91Z"
			clipRule="evenodd"
		/>
		<path
			fillRule="evenodd"
			d="M3 2.4a.6.6 0 0 1 .6.6v4.4H8a.6.6 0 0 1 0 1.2H3a.6.6 0 0 1-.6-.6V3a.6.6 0 0 1 .6-.6Zm0 9a.6.6 0 0 1 .6.6 8.4 8.4 0 0 0 8.4 8.4 9.15 9.15 0 0 0 6.32-2.567l2.256-2.257a.6.6 0 0 1 .849.849l-2.268 2.267a10.35 10.35 0 0 1-7.154 2.908H12A9.6 9.6 0 0 1 2.4 12a.6.6 0 0 1 .6-.6Z"
			clipRule="evenodd"
		/>
		<path
			fillRule="evenodd"
			d="M15.4 16a.6.6 0 0 1 .6-.6h5a.6.6 0 0 1 .6.6v5a.6.6 0 1 1-1.2 0v-4.4H16a.6.6 0 0 1-.6-.6Z"
			clipRule="evenodd"
		/>
	</chakra.svg>
));

export const ArrowsUpDown = React.forwardRef((props, ref) => (
	<chakra.svg
		viewBox="0 0 30 28"
		fill="none"
		xmlns="https://www.w3.org/2000/svg"
		{...props}
		ref={ref}
	>
		<path d="M17.295 19.794a.498.498 0 0 1-.354-.146l-4.706-4.706a.5.5 0 1 1 .707-.707l3.854 3.854V4a.5.5 0 1 1 1 0v14.085l3.85-3.85a.5.5 0 0 1 .708.707l-4.68 4.678a.5.5 0 0 1-.379.174ZM6.325 3.675a.499.499 0 0 1 .734-.028l4.706 4.706a.5.5 0 1 1-.707.707L7.204 5.206v14.09a.5.5 0 1 1-1 0V5.21l-3.85 3.85a.5.5 0 0 1-.708-.707l4.68-4.678Z" />
	</chakra.svg>
));

export const Links = React.forwardRef((props, ref) => (
	<chakra.svg
		viewBox="0 0 24 24"
		xmlns="https://www.w3.org/2000/svg"
		{...props}
		ref={ref}
	>
		<path d="M7.5 22c-.3 0-.5-.1-.7-.3-.4-.4-.4-1 0-1.4l8.3-8.3-8.3-8.3c-.4-.4-.4-1 0-1.4s1-.4 1.4 0l9 9c.4.4.4 1 0 1.4l-9 9c-.2.2-.4.3-.7.3z" />
	</chakra.svg>
));

export const ArrowRight = React.forwardRef((props, ref) => (
	<chakra.svg
		viewBox="0 0 18 18"
		fill="none"
		xmlns="https://www.w3.org/2000/svg"
		{...props}
		ref={ref}
	>
		<path
			stroke="currentColor"
			strokeLinecap="round"
			strokeLinejoin="round"
			strokeWidth="2"
			d="m6.75 13.5 4.5-4.5-4.5-4.5"
		/>
	</chakra.svg>
));

export const DotsHorizontal = React.forwardRef((props, ref) => (
	<chakra.svg
		viewBox="0 0 24 24"
		xmlns="https://www.w3.org/2000/svg"
		strokeWidth="0"
		{...props}
		ref={ref}
	>
		<path d="M12 10c-1.1 0-2 .9-2 2s.9 2 2 2 2-.9 2-2-.9-2-2-2zm6 0c-1.1 0-2 .9-2 2s.9 2 2 2 2-.9 2-2-.9-2-2-2zM6 10c-1.1 0-2 .9-2 2s.9 2 2 2 2-.9 2-2-.9-2-2-2z"></path>
	</chakra.svg>
));

export const ArrowRightFill = React.forwardRef((props, ref) => (
	<chakra.svg
		viewBox="0 0 24 24"
		xmlns="https://www.w3.org/2000/svg"
		fill="none"
		{...props}
		ref={ref}
	>
		<path
			fillRule="evenodd"
			d="M12 24c6.627 0 12-5.373 12-12S18.627 0 12 0 0 5.373 0 12s5.373 12 12 12Zm1.646-7.646a.5.5 0 1 0 .707-.707L10.707 12l3.646-3.646a.5.5 0 1 0-.707-.708l-4 4a.503.503 0 0 0-.146.392c.01.115.059.228.146.316l4 4Z"
			clipRule="evenodd"
		></path>
	</chakra.svg>
));
export const ArrowLeftFill = React.forwardRef((props, ref) => (
	<chakra.svg
		viewBox="0 0 35 35"
		xmlns="https://www.w3.org/2000/svg"
		fill="none"
		{...props}
		ref={ref}
	>
		<rect
			fillRule="evenodd"
			width="30"
			height="30"
			rx="15"
			fill="#F4F4F4"
			clipRule="evenodd"
		/>
		<path
			fillRule="evenodd"
			d="M20.2493 14.4164H11.1552L15.4135 10.1639C15.4679 10.1096 15.511 10.045 15.5405 9.97393C15.5699 9.90287 15.5851 9.8267 15.5851 9.74978C15.5851 9.67286 15.5699 9.5967 15.5405 9.52564C15.511 9.45457 15.4679 9.39001 15.4135 9.33562C15.3591 9.28123 15.2946 9.23808 15.2235 9.20865C15.1524 9.17921 15.0763 9.16406 14.9993 9.16406C14.844 9.16406 14.695 9.22577 14.5852 9.33562L9.33518 14.5856C9.28116 14.6404 9.23941 14.706 9.21268 14.7781C9.18279 14.8482 9.16694 14.9236 9.16602 14.9998C9.16747 15.0778 9.18329 15.155 9.21268 15.2273C9.24246 15.2944 9.28394 15.3556 9.33518 15.4081L14.5852 20.6581C14.6394 20.7128 14.7039 20.7562 14.775 20.7858C14.8461 20.8154 14.9223 20.8307 14.9993 20.8307C15.0764 20.8307 15.1526 20.8154 15.2237 20.7858C15.2948 20.7562 15.3593 20.7128 15.4135 20.6581C15.4682 20.6039 15.5116 20.5394 15.5412 20.4683C15.5708 20.3972 15.5861 20.321 15.5861 20.2439C15.5861 20.1669 15.5708 20.0907 15.5412 20.0196C15.5116 19.9485 15.4682 19.884 15.4135 19.8298L11.1552 15.5831H20.2493C20.4041 15.5831 20.5524 15.5217 20.6618 15.4123C20.7712 15.3029 20.8327 15.1545 20.8327 14.9998C20.8327 14.8451 20.7712 14.6967 20.6618 14.5873C20.5524 14.4779 20.4041 14.4164 20.2493 14.4164Z"
			fill="#6B6B6B"
			clipRule="evenodd"
		/>
	</chakra.svg>
));

export const QuestionCircleFill = React.forwardRef((props, ref) => (
	<chakra.svg
		viewBox="0 0 16 16"
		xmlns="https://www.w3.org/2000/svg"
		strokeWidth="0"
		{...props}
		ref={ref}
	>
		<path d="M8 1.332a6.667 6.667 0 1 0 0 13.333A6.667 6.667 0 0 0 8 1.332Zm0 10.333a.667.667 0 1 1 0-1.333.667.667 0 0 1 0 1.333Zm.16-2.433a.793.793 0 0 1-.214.033.675.675 0 1 1-.206-1.333c.433-.147 1.333-.627 1.333-1.167a1.133 1.133 0 0 0-2.2-.38A.667.667 0 0 1 5.62 6a2.467 2.467 0 0 1 4.793.82c0 1.613-2.02 2.333-2.253 2.413Z" />
	</chakra.svg>
));

export const Buttons = React.forwardRef((props, ref) => (
	<chakra.svg
		viewBox="0 0 24 24"
		xmlns="https://www.w3.org/2000/svg"
		{...props}
		ref={ref}
	>
		<path d="M19.27 12.91H4.73a1.83 1.83 0 0 0-1.82 1.82v5.45A1.83 1.83 0 0 0 4.73 22h14.54a1.83 1.83 0 0 0 1.82-1.82v-5.45a1.83 1.83 0 0 0-1.82-1.82Zm0 7.27H4.73v-5.45h14.54Z" />
		<path d="M7.45 18.36h9.1a.91.91 0 0 0 0-1.81h-9.1a.91.91 0 0 0 0 1.81ZM19.27 2H4.73a1.83 1.83 0 0 0-1.82 1.82v5.45a1.83 1.83 0 0 0 1.82 1.82h14.54a1.83 1.83 0 0 0 1.82-1.82V3.82A1.83 1.83 0 0 0 19.27 2Zm0 7.27H4.73V3.82h14.54Z" />
		<path d="M7.45 7.45h9.1a.85.85 0 0 0 .9-.9.85.85 0 0 0-.9-.91h-9.1a.85.85 0 0 0-.9.91.85.85 0 0 0 .9.9Z" />
	</chakra.svg>
));

export const ThreeCircleNodes = React.forwardRef((props, ref) => (
	<chakra.svg
		viewBox="0 0 24 24"
		xmlns="https://www.w3.org/2000/svg"
		{...props}
		ref={ref}
	>
		<path
			fillRule="evenodd"
			d="M12 15.6a2.4 2.4 0 1 0 0 4.8 2.4 2.4 0 0 0 0-4.8ZM8.4 18a3.6 3.6 0 1 1 7.2 0 3.6 3.6 0 0 1-7.2 0ZM6 3.6a2.4 2.4 0 1 0 0 4.8 2.4 2.4 0 0 0 0-4.8ZM2.4 6a3.6 3.6 0 1 1 7.2 0 3.6 3.6 0 0 1-7.2 0ZM18 3.6a2.4 2.4 0 1 0 0 4.8 2.4 2.4 0 0 0 0-4.8ZM14.4 6a3.6 3.6 0 1 1 7.2 0 3.6 3.6 0 0 1-7.2 0Z"
			clipRule="evenodd"
		/>
		<path
			fillRule="evenodd"
			d="M6 8.4a.6.6 0 0 1 .6.6v1A1.4 1.4 0 0 0 8 11.4h8a1.4 1.4 0 0 0 1.4-1.4V9a.6.6 0 1 1 1.2 0v1a2.6 2.6 0 0 1-2.6 2.6H8A2.6 2.6 0 0 1 5.4 10V9a.6.6 0 0 1 .6-.6Z"
			clipRule="evenodd"
		/>
		<path
			fillRule="evenodd"
			d="M12 11.4a.6.6 0 0 1 .6.6v3a.6.6 0 1 1-1.2 0v-3a.6.6 0 0 1 .6-.6Z"
			clipRule="evenodd"
		/>
	</chakra.svg>
));

export const Countdown = React.forwardRef((props, ref) => (
	<chakra.svg
		viewBox="0 0 24 24"
		xmlns="https://www.w3.org/2000/svg"
		xmlSpace="preserve"
		{...props}
		ref={ref}
	>
		{/* eslint-disable-next-line */}
		<path d="m20.1 8.8.9-.9c.4-.4.4-1 0-1.4-.4-.4-1-.4-1.4 0l-1 1c-1-.6-2.3-1-3.6-1-3.9 0-7 3.1-7 7.1 0 3.7 3.2 6.9 6.9 6.9 3.9 0 7.1-3.1 7.1-7 0-1.8-.7-3.4-1.9-4.7zM15 18.5c-2.8 0-5-2.2-5-5s2.2-5 5-5 5 2.2 5 5-2.2 5-5 5zm0-8c.6 0 1 .4 1 1v2c0 .5-.4 1-1 1-.5 0-1-.4-1-1v-2c0-.6.4-1 1-1zm-1-7h2c.5 0 1 .4 1 1 0 .5-.4 1-1 1h-2c-.5 0-1-.4-1-1s.4-1 1-1zm-10 5h2c.5 0 1 .4 1 1 0 .5-.4 1-1 1H4c-.5 0-1-.4-1-1s.4-1 1-1zm0 8h2c.5 0 1 .4 1 1 0 .5-.4 1-1 1H4c-.5 0-1-.4-1-1s.4-1 1-1zm-1-4h2c.5 0 1 .4 1 1 0 .5-.4 1-1 1H3c-.5 0-1-.4-1-1s.4-1 1-1z" />
	</chakra.svg>
));

export const Counter = React.forwardRef((props, ref) => (
	<chakra.svg
		viewBox="0 0 24 24"
		xmlns="https://www.w3.org/2000/svg"
		xmlSpace="preserve"
		{...props}
		ref={ref}
	>
		{/* eslint-disable-next-line */}
		<path d="M19.664 17.739V7.646l1.316 1.316a.575.575 0 0 0 .812-.811l-2.296-2.295a.573.573 0 0 0-.403-.169h-.005a.572.572 0 0 0-.406.169l-2.294 2.295a.573.573 0 1 0 .812.811l1.315-1.316v10.092a.574.574 0 0 0 1.149.001zm-15.64-.866a.58.58 0 0 1-.42-.16.527.527 0 0 1-.165-.396v-4.603l.128.201-.667.493a.502.502 0 0 1-.32.101.526.526 0 0 1-.383-.164.537.537 0 0 1-.165-.393c0-.195.094-.353.283-.475L3.63 10.6a.6.6 0 0 1 .206-.091.929.929 0 0 1 .214-.027.56.56 0 0 1 .42.16.548.548 0 0 1 .155.397v5.279c0 .158-.057.29-.169.396a.604.604 0 0 1-.432.159zm6.018-1.005a.496.496 0 0 1 .511.511.472.472 0 0 1-.146.352.502.502 0 0 1-.365.142H6.937a.493.493 0 0 1-.375-.146c-.091-.097-.137-.222-.137-.374s.055-.286.164-.401l1.991-2.129c.225-.242.403-.492.534-.748s.197-.478.197-.667c0-.304-.088-.549-.265-.735s-.411-.278-.703-.278a.86.86 0 0 0-.356.082 1.467 1.467 0 0 0-.352.228c-.113.098-.218.21-.315.338a.482.482 0 0 1-.219.183.547.547 0 0 1-.571-.113.459.459 0 0 1-.169-.352c0-.104.035-.204.105-.302a2.763 2.763 0 0 1 1.355-.972c.2-.064.396-.096.584-.096.408 0 .763.081 1.064.242s.534.39.699.685c.164.295.247.644.247 1.045 0 .335-.099.708-.297 1.119a4.647 4.647 0 0 1-.799 1.155l-1.233 1.315-.1-.083h2.056zm2.493-.283a.662.662 0 0 1 .393.137c.104.079.227.149.369.21.144.061.311.091.498.091.189 0 .367-.047.535-.142a1.138 1.138 0 0 0 .58-1.027c0-.23-.049-.423-.143-.575s-.219-.268-.375-.347a1.073 1.073 0 0 0-.496-.118c-.135 0-.246.012-.334.035-.088.025-.174.051-.256.078s-.178.041-.287.041a.389.389 0 0 1-.325-.146.546.546 0 0 1-.114-.346.51.51 0 0 1 .05-.229c.033-.067.083-.141.151-.22l1.607-1.708.246.21h-2.246a.496.496 0 0 1-.511-.511c0-.14.049-.257.146-.352a.502.502 0 0 1 .365-.142h2.795c.188 0 .33.052.424.155a.555.555 0 0 1 .143.393c0 .079-.021.157-.064.233s-.094.145-.154.206l-1.617 1.735-.246-.311c.066-.03.16-.058.277-.082a1.596 1.596 0 0 1 1.235.242c.264.186.469.426.611.721s.215.613.215.954c0 .451-.102.841-.303 1.169a1.966 1.966 0 0 1-.848.758c-.365.177-.793.266-1.279.266-.226 0-.447-.028-.667-.083a2.213 2.213 0 0 1-.566-.219.626.626 0 0 1-.27-.242.555.555 0 0 1-.068-.251c0-.14.05-.272.151-.397a.465.465 0 0 1 .378-.186z" />
	</chakra.svg>
));

export const Minus = React.forwardRef((props, ref) => (
	<chakra.svg
		viewBox="0 0 24 24"
		xmlns="https://www.w3.org/2000/svg"
		xmlSpace="preserve"
		{...props}
		ref={ref}
	>
		<rect width="32" height="32" rx="16" fill="#F8F8FE" />
		<path
			d="M21.9337 16.6663H10.0671C9.66706 16.6663 9.40039 16.3997 9.40039 15.9997C9.40039 15.5997 9.66706 15.333 10.0671 15.333H21.9337C22.3337 15.333 22.6004 15.5997 22.6004 15.9997C22.6004 16.3997 22.3337 16.6663 21.9337 16.6663Z"
			fill="#383838"
			fillRule="evenodd"
			clipRule="evenodd"
		/>
	</chakra.svg>
));

export const Add = React.forwardRef((props, ref) => (
	<chakra.svg
		viewBox="0 0 24 24"
		xmlns="https://www.w3.org/2000/svg"
		xmlSpace="preserve"
		{...props}
		ref={ref}
	>
		<path
			d="M16.0004 23.6329C15.6004 23.6329 15.3337 23.3662 15.3337 22.9662V17.6329H10.0671C9.66706 17.6329 9.40039 17.3662 9.40039 16.9662C9.40039 16.5662 9.66706 16.2995 10.0671 16.2995H15.3337V11.0329C15.3337 10.6329 15.6004 10.3662 16.0004 10.3662C16.4004 10.3662 16.6671 10.6329 16.6671 11.0329V16.2995H21.9337C22.3337 16.2995 22.6004 16.5662 22.6004 16.9662C22.6004 17.3662 22.3337 17.6329 21.9337 17.6329H16.6671V22.9662C16.6671 23.3662 16.4004 23.6329 16.0004 23.6329Z"
			fill="#383838"
			fillRule="evenodd"
			clipRule="evenodd"
		/>
	</chakra.svg>
));

export const Heading = React.forwardRef((props, ref) => (
	<chakra.svg
		viewBox="0 0 24 24"
		xmlns="https://www.w3.org/2000/svg"
		{...props}
		ref={ref}
	>
		<path d="M17 19V5a1 1 0 0 0-1-1 1 1 0 0 0-1 1v6H9V5a1 1 0 0 0-1-1 .94.94 0 0 0-1 1v14a1 1 0 0 0 1 1 1 1 0 0 0 1-1v-6h6v6a1 1 0 0 0 1 1 .94.94 0 0 0 1-1z" />
	</chakra.svg>
));

export const Paragraph = React.forwardRef((props, ref) => (
	<chakra.svg
		viewBox="0 0 24 24"
		xmlns="https://www.w3.org/2000/svg"
		{...props}
		ref={ref}
	>
		<path d="M9.15 17h2.3v4.1a.9.9 0 0 0 .9.9.9.9 0 0 0 .9-.9v-17h2.8v17a.9.9 0 0 0 .9.9h.1a.9.9 0 0 0 .9-.9v-17h3.1a.9.9 0 0 0 .9-.9V3a.9.9 0 0 0-.9-.9h-12a7.2 7.2 0 0 0-7 7.5 7.2 7.2 0 0 0 7.1 7.4zm-.1-12.9h2.3V15h-2.2a5.79 5.79 0 0 1-5.1-5.5 5.69 5.69 0 0 1 5-5.45z" />
	</chakra.svg>
));

export const Section = React.forwardRef((props, ref) => (
	<chakra.svg
		viewBox="0 0 24 24"
		xmlns="https://www.w3.org/2000/svg"
		{...props}
		ref={ref}
	>
		<path d="M4 2a2 2 0 0 0-2 2v3a2 2 0 0 0 2 2h16a2 2 0 0 0 2-2V4a2 2 0 0 0-2-2zm16 5H4V4h16zM2 12v8a2 2 0 0 0 2 2h16a2 2 0 0 0 2-2v-8a2 2 0 0 0-2-2H4a2 2 0 0 0-2 2zm18 0v8H4v-8zm-9 5H9v-2h2v-2h2v2h2v2h-2v2h-2z" />
	</chakra.svg>
));

export const Spacing = React.forwardRef((props, ref) => (
	<chakra.svg
		viewBox="0 0 24 24"
		xmlns="https://www.w3.org/2000/svg"
		{...props}
		ref={ref}
	>
		<path d="M21 2H3a1 1 0 0 0-1 1 .94.94 0 0 0 1 1h18a.94.94 0 0 0 1-1 .94.94 0 0 0-1-1ZM2 21a.94.94 0 0 0 1 1h18a.94.94 0 0 0 1-1 .94.94 0 0 0-1-1H3a.94.94 0 0 0-1 1Zm7-6V9a.94.94 0 0 0-1-1 1 1 0 0 0-1 1v6a.94.94 0 0 0 1 1 1 1 0 0 0 1-1Zm8 0V9a.94.94 0 0 0-1-1 .94.94 0 0 0-1 1v6a.94.94 0 0 0 1 1 1.08 1.08 0 0 0 1-1Zm-4 2V7a.94.94 0 0 0-1-1 .94.94 0 0 0-1 1v10a.94.94 0 0 0 1 1 .94.94 0 0 0 1-1Z" />
	</chakra.svg>
));

export const Tabs = React.forwardRef((props, ref) => (
	<chakra.svg
		viewBox="0 0 24 24"
		xmlns="https://www.w3.org/2000/svg"
		{...props}
		ref={ref}
	>
		<path
			fillRule="evenodd"
			d="M6 10V4H4v16h16V10H6Zm16-2v14H2V2h6v6h14Z"
			clipRule="evenodd"
		/>
		<path
			fillRule="evenodd"
			d="M13.5 3.5h-3v2h3v-2ZM9 2v5h6V2H9Zm11.5 1.5h-3v2h3v-2ZM16 2v5h6V2h-6Z"
			clipRule="evenodd"
		/>
	</chakra.svg>
));

export const Lottie = React.forwardRef((props, ref) => (
	<chakra.svg
		viewBox="0 0 24 24"
		xmlns="https://www.w3.org/2000/svg"
		{...props}
		ref={ref}
	>
		<path d="M20 4v16H4V4h16m0-2H4a2 2 0 0 0-2 2v16a2 2 0 0 0 2 2h16a2 2 0 0 0 2-2V4a2 2 0 0 0-2-2zM7 18a1 1 0 0 1 0-2c1.66 0 2.856-2.177 4.124-4.482C12.616 8.805 14.159 6 17 6a1 1 0 0 1 0 2c-1.66 0-2.856 2.177-4.124 4.482C11.384 15.195 9.841 18 7 18z" />
	</chakra.svg>
));

export const InfoBox = React.forwardRef((props, ref) => (
	<chakra.svg
		viewBox="0 0 24 24"
		xmlns="https://www.w3.org/2000/svg"
		{...props}
		ref={ref}
	>
		<path d="M22 4V3c0-.6-.4-1-1-1H3c-.6 0-1 .4-1 1v18c0 .6.4 1 1 1h18c.6 0 1-.4 1-1V4zM4 4h16v16H4V4zm8 5.5a2 2 0 1 0 .001-3.999A2 2 0 0 0 12 9.5zm3 1H9c-.6 0-1 .4-1 1s.4 1 1 1h6c.6 0 1-.4 1-1s-.5-1-1-1zm-4 8h2c.6 0 1-.4 1-1s-.4-1-1-1h-2c-.6 0-1 .4-1 1 0 .5.4 1 1 1zm-5-4c0 .6.4 1 1 1h10c.6 0 1-.4 1-1s-.4-1-1-1H7c-.6 0-1 .5-1 1z" />
	</chakra.svg>
));

export const Image = React.forwardRef((props, ref) => (
	<chakra.svg
		viewBox="0 0 24 24"
		xmlns="https://www.w3.org/2000/svg"
		{...props}
		ref={ref}
	>
		<path d="M19.9 2.2H4.3c-1.2 0-2 .8-2 2v15.6c0 1.2.7 2.1 2 2.1h15.6c1.2 0 2-.8 2-2V4.3c-.1-1.3-.8-2.1-2-2.1zM4.3 19.8V4.2h15.6v15.6H4.3z" />
		<path d="m10.1 14-1-1-3 4h12l-5-7-3 4z" />
	</chakra.svg>
));

export const TableOfContents = React.forwardRef((props, ref) => (
	<chakra.svg
		viewBox="0 0 24 24"
		xmlns="https://www.w3.org/2000/svg"
		{...props}
		ref={ref}
	>
		{/* eslint-disable-next-line */}
		<path d="M16.8 9h-6.5c-.2 0-.3-.1-.3-.2V7.3c0-.2.1-.3.3-.3h6.5c.1 0 .2.1.2.3v1.5c0 .1-.1.2-.2.2zm-.8 3.8v-1.5c0-.1-.1-.3-.3-.3h-5.5c-.1 0-.3.1-.3.3v1.5c0 .1.1.3.3.3h5.5c.2-.1.3-.2.3-.3zm-2 4v-1.5c0-.1-.1-.3-.3-.3h-3.5c-.1 0-.3.1-.3.3v1.5c0 .1.1.3.3.3h3.5c.2-.1.3-.2.3-.3zm-5-8V7.3c0-.2-.1-.3-.2-.3H7.3c-.2 0-.3.1-.3.3v1.5c0 .1.1.2.3.2h1.5c.1 0 .2-.1.2-.2zm0 4v-1.5c0-.2-.1-.3-.2-.3H7.3c-.2 0-.3.1-.3.3v1.5c0 .1.1.2.3.2h1.5c.1 0 .2-.1.2-.2zm0 4v-1.5c0-.2-.1-.3-.2-.3H7.3c-.2 0-.3.1-.3.3v1.5c0 .1.1.2.3.2h1.5c.1 0 .2-.1.2-.2zm9 5.2H6c-1.7 0-3-1.3-3-3V5c0-1.7 1.3-3 3-3h12c1.7 0 3 1.3 3 3v14c0 1.7-1.3 3-3 3zM6 4c-.6 0-1 .4-1 1v14c0 .6.4 1 1 1h12c.6 0 1-.4 1-1V5c0-.6-.4-1-1-1H6z" />
	</chakra.svg>
));

export const SocialShare = React.forwardRef((props, ref) => (
	<chakra.svg
		viewBox="0 0 24 24"
		xmlns="https://www.w3.org/2000/svg"
		{...props}
		ref={ref}
	>
		{/* eslint-disable-next-line */}
		<path d="M6 15c.9 0 1.7-.3 2.4-.9l6.3 3.6c-.1.3-.1.6-.1.9 0 1.9 1.6 3.5 3.5 3.6 1.9 0 3.5-1.6 3.6-3.5 0-1.9-1.6-3.5-3.5-3.6-.9 0-1.8.3-2.4.9l-6.3-3.6c.1-.2.1-.5.1-.8l6.1-3.5c1.4 1.3 3.6 1.2 4.9-.2 1.3-1.4 1.2-3.6-.2-4.9-1.4-1.3-3.6-1.2-4.9.2-.6.6-.9 1.5-.9 2.4 0 .3 0 .6.1.8L8.9 9.6c-1-1.6-3.2-2.1-4.8-1C2.5 9.7 2 11.8 3 13.4c.7 1 1.8 1.6 3 1.6Zm12 2c.8 0 1.5.7 1.5 1.5S18.8 20 18 20s-1.5-.7-1.5-1.5.6-1.5 1.5-1.5Zm0-13c.8 0 1.5.7 1.5 1.5S18.8 7 18 7s-1.5-.7-1.5-1.5S17.1 4 18 4ZM6 10c.8 0 1.5.7 1.5 1.5S6.8 13 6 13s-1.5-.7-1.5-1.5S5.1 10 6 10Z" />
	</chakra.svg>
));

export const Team = React.forwardRef((props, ref) => (
	<chakra.svg
		viewBox="0 0 24 24"
		xmlns="https://www.w3.org/2000/svg"
		{...props}
		ref={ref}
	>
		<path
			fillRule="evenodd"
			// eslint-disable-next-line
			d="M6.81 14.425a4.077 4.077 0 0 1 2.882-1.194h4.616a4.077 4.077 0 0 1 4.076 4.077v1.538a1 1 0 0 1-2 0v-1.538a2.077 2.077 0 0 0-2.076-2.077H9.692a2.077 2.077 0 0 0-2.077 2.077v1.538a1 1 0 0 1-2 0v-1.538c0-1.082.43-2.119 1.194-2.883ZM12 6a2.077 2.077 0 1 0 0 4.154A2.077 2.077 0 0 0 12 6ZM7.923 8.077a4.077 4.077 0 1 1 8.154 0 4.077 4.077 0 0 1-8.154 0Zm10.801 5.903a1 1 0 0 1 1.218-.718A4.077 4.077 0 0 1 23 17.207v1.54a1 1 0 0 1-2 0v-1.539a2.077 2.077 0 0 0-1.558-2.009 1 1 0 0 1-.718-1.218Zm-2.308-9.228a1 1 0 0 1 1.217-.72 4.077 4.077 0 0 1 0 7.898 1 1 0 1 1-.496-1.937 2.077 2.077 0 0 0 0-4.024 1 1 0 0 1-.721-1.217ZM5.276 13.98a1 1 0 0 0-1.218-.718A4.078 4.078 0 0 0 1 17.207v1.54a1 1 0 0 0 2 0v-1.539A2.077 2.077 0 0 1 4.558 15.2a1 1 0 0 0 .718-1.218Zm2.308-9.228a1 1 0 0 0-1.217-.72 4.077 4.077 0 0 0 0 7.898 1 1 0 1 0 .496-1.937 2.077 2.077 0 0 1 0-4.024 1 1 0 0 0 .721-1.217Z"
			clipRule="evenodd"
		/>
	</chakra.svg>
));

export const CirclesInsideCircle = React.forwardRef((props, ref) => (
	<chakra.svg
		viewBox="0 0 24 24"
		xmlns="https://www.w3.org/2000/svg"
		{...props}
		ref={ref}
	>
		{/* eslint-disable-next-line  */}
		<path d="M11.402 2h1.196c.084.03.17.052.259.067a9.92 9.92 0 0 1 8.745 7.282c.181.67.266 1.368.398 2.053v1.196c-.03.084-.052.17-.067.259a9.923 9.923 0 0 1-7.282 8.745c-.672.18-1.368.266-2.053.398h-1.196a1.511 1.511 0 0 0-.259-.067 9.934 9.934 0 0 1-8.824-7.589c-.14-.574-.215-1.164-.319-1.746v-1.196c.03-.084.052-.17.067-.259A9.931 9.931 0 0 1 9.656 2.32c.575-.14 1.164-.215 1.746-.319Zm-8.545 9.986c-.01 4.965 4.045 9.071 8.88 9.17 5.1.104 9.271-3.97 9.41-8.883.145-5.13-3.99-9.295-8.905-9.422-5.103-.134-9.418 4.028-9.385 9.136Z" />
		{/* eslint-disable-next-line  */}
		<path d="M7.258 10.008c1.115.015 1.963.892 1.952 2.024-.011 1.124-.883 1.97-2.013 1.96a1.971 1.971 0 0 1-1.978-2.042c.021-1.11.91-1.957 2.039-1.942Zm1.154 2.005c.006-.697-.498-1.206-1.196-1.207-.68 0-1.182.486-1.195 1.163-.015.697.478 1.216 1.172 1.226.694.01 1.213-.488 1.219-1.182Zm5.58-.011a1.992 1.992 0 1 1-1.98-1.992 1.955 1.955 0 0 1 1.98 1.992Zm-.797 0c0-.696-.508-1.2-1.204-1.195a1.155 1.155 0 0 0-1.185 1.174c-.01.697.491 1.21 1.184 1.215.694.005 1.204-.5 1.204-1.195l.001.001Zm3.585-1.994a1.957 1.957 0 0 1 1.993 1.983c0 1.144-.868 2.01-2.014 2.002a1.992 1.992 0 0 1 .021-3.984Zm-.006 3.187c.697 0 1.203-.5 1.201-1.195a1.155 1.155 0 0 0-1.168-1.191c-.697-.012-1.213.486-1.22 1.178-.008.693.493 1.205 1.187 1.208Z" />
	</chakra.svg>
));

export const ExternalLink = React.forwardRef((props, ref) => (
	<chakra.svg
		viewBox="0 0 12 12"
		xmlns="https://www.w3.org/2000/svg"
		{...props}
		ref={ref}
	>
		<path
			fill="#64748B"
			fillRule="evenodd"
			d="M2.5 4a.5.5 0 0 0-.5.5V10a.5.5 0 0 0 .5.5H8a.5.5 0 0 0 .5-.5V7a.5.5 0 0 1 1 0v3A1.5 1.5 0 0 1 8 11.5H2.5A1.5 1.5 0 0 1 1 10V4.5A1.5 1.5 0 0 1 2.5 3h3a.5.5 0 0 1 0 1h-3ZM7 2a.5.5 0 0 1 .5-.5h3a.5.5 0 0 1 .5.5v3a.5.5 0 0 1-1 0V2.5H7.5A.5.5 0 0 1 7 2Z"
			clipRule="evenodd"
		/>
		<path
			fill="#64748B"
			fillRule="evenodd"
			d="M10.854 1.646a.5.5 0 0 1 0 .708l-5.5 5.5a.5.5 0 1 1-.708-.708l5.5-5.5a.5.5 0 0 1 .708 0Z"
			clipRule="evenodd"
		/>
	</chakra.svg>
));

export const Docs = React.forwardRef((props, ref) => (
	<chakra.svg
		viewBox="0 0 12 12"
		xmlns="https://www.w3.org/2000/svg"
		{...props}
		ref={ref}
	>
		<path
			fillRule="evenodd"
			d="M1.94 1.44A1.5 1.5 0 0 1 3 1h4.25a.5.5 0 0 1 .354.146l2.75 2.75a.5.5 0 0 1 .146.354v6.25A1.5 1.5 0 0 1 9 12H3a1.5 1.5 0 0 1-1.5-1.5v-8c0-.398.158-.78.44-1.06ZM3 2a.5.5 0 0 0-.5.5v8a.5.5 0 0 0 .5.5h6a.5.5 0 0 0 .5-.5V4.457L7.043 2H3Z"
			clipRule="evenodd"
		/>
		<path
			fillRule="evenodd"
			d="M7 1a.5.5 0 0 1 .5.5V4H10a.5.5 0 0 1 0 1H7a.5.5 0 0 1-.5-.5v-3A.5.5 0 0 1 7 1Z"
			clipRule="evenodd"
		/>
	</chakra.svg>
));

export const DocsLines = React.forwardRef((props, ref) => (
	<chakra.svg
		viewBox="0 0 32 32"
		xmlns="https://www.w3.org/2000/svg"
		{...props}
		ref={ref}
	>
		<path
			fillRule="evenodd"
			d="M16 3.666c-6.812 0-12.334 5.522-12.334 12.333 0 6.812 5.522 12.334 12.333 12.334 6.812 0 12.334-5.522 12.334-12.334 0-6.811-5.522-12.333-12.334-12.333ZM1.665 15.999c0-7.916 6.417-14.333 14.333-14.333s14.334 6.417 14.334 14.333-6.418 14.334-14.334 14.334c-7.916 0-14.333-6.418-14.333-14.334Z"
			clipRule="evenodd"
		/>
		<path
			fillRule="evenodd"
			d="M16.4 10.37a3 3 0 0 0-3.337 1.962 1 1 0 0 1-1.887-.664 5 5 0 0 1 9.716 1.666c0 1.864-1.385 3.125-2.445 3.832a10.409 10.409 0 0 1-2.175 1.094l-.043.015-.013.005-.004.001h-.002s-.001.001-.31-.922l.309.923a1 1 0 0 1-.634-1.897l.004-.001.023-.008a8.193 8.193 0 0 0 .509-.206 8.53 8.53 0 0 0 1.227-.669c.94-.626 1.554-1.365 1.554-2.168v-.001a3 3 0 0 0-2.492-2.961ZM15 22.666a1 1 0 0 1 1-1h.013a1 1 0 1 1 0 2h-.014a1 1 0 0 1-1-1Z"
			clipRule="evenodd"
		/>
	</chakra.svg>
));

export const Video = React.forwardRef((props, ref) => (
	<chakra.svg
		viewBox="0 0 20 20"
		xmlns="https://www.w3.org/2000/svg"
		{...props}
		ref={ref}
	>
		<path
			fillRule="evenodd"
			d="M4.167 3.25a.917.917 0 0 0-.917.917v11.666c0 .507.41.917.917.917h11.666c.507 0 .917-.41.917-.917V4.167a.917.917 0 0 0-.917-.917H4.167Zm-2.417.917A2.417 2.417 0 0 1 4.167 1.75h11.666a2.417 2.417 0 0 1 2.417 2.417v11.666a2.417 2.417 0 0 1-2.417 2.417H4.167a2.417 2.417 0 0 1-2.417-2.417V4.167Z"
			clipRule="evenodd"
		/>
		<path
			fillRule="evenodd"
			d="M7.146 6.005a.75.75 0 0 1 .77.037l5 3.333a.75.75 0 0 1 0 1.248l-5 3.334a.75.75 0 0 1-1.166-.624V6.666a.75.75 0 0 1 .396-.661ZM8.25 8.067v3.864L11.148 10 8.25 8.067Z"
			clipRule="evenodd"
		/>
	</chakra.svg>
));

export const Star = React.forwardRef((props, ref) => (
	<chakra.svg
		viewBox="0 0 20 20"
		xmlns="https://www.w3.org/2000/svg"
		{...props}
		ref={ref}
	>
		<path
			fillRule="evenodd"
			d="M10 .917a.75.75 0 0 1 .672.418l2.4 4.864 5.37.784a.75.75 0 0 1 .414 1.28l-3.884 3.783.917 5.344a.75.75 0 0 1-1.089.79L10 15.657l-4.802 2.525a.75.75 0 0 1-1.088-.79l.917-5.345-3.884-3.783a.75.75 0 0 1 .415-1.28L6.926 6.2l2.4-4.864A.75.75 0 0 1 10 .917Zm0 2.444L8.096 7.216a.75.75 0 0 1-.564.41l-4.256.622 3.079 2.998a.75.75 0 0 1 .216.664l-.726 4.236 3.804-2.001a.75.75 0 0 1 .698 0l3.805 2-.726-4.235a.75.75 0 0 1 .216-.664l3.078-2.998-4.255-.622a.75.75 0 0 1-.564-.41L9.999 3.36Z"
			clipRule="evenodd"
		></path>
	</chakra.svg>
));

export const Bulb = React.forwardRef((props, ref) => (
	<chakra.svg
		viewBox="0 0 20 20"
		xmlns="https://www.w3.org/2000/svg"
		{...props}
		ref={ref}
	>
		<path
			fillRule="evenodd"
			// eslint-disable-next-line
			d="M5.934 2.601a5.75 5.75 0 0 1 9.816 4.066c0 1.262-.483 2.551-1.483 3.46-.608.61-.907 1.064-1.032 1.687a.75.75 0 1 1-1.47-.294c.207-1.04.738-1.75 1.455-2.467a.726.726 0 0 1 .028-.027c.656-.59 1.002-1.461 1.002-2.359a4.25 4.25 0 0 0-8.5 0c0 .687.12 1.477 1.03 2.386.626.626 1.246 1.42 1.455 2.467a.75.75 0 1 1-1.47.294c-.125-.62-.504-1.159-1.045-1.7-1.257-1.257-1.47-2.467-1.47-3.447a5.75 5.75 0 0 1 1.684-4.066ZM6.75 15a.75.75 0 0 1 .75-.75h5a.75.75 0 0 1 0 1.5h-5a.75.75 0 0 1-.75-.75Zm.833 3.333a.75.75 0 0 1 .75-.75h3.334a.75.75 0 0 1 0 1.5H8.333a.75.75 0 0 1-.75-.75Z"
			clipRule="evenodd"
		></path>
	</chakra.svg>
));

export const Chat = React.forwardRef((props, ref) => (
	<chakra.svg
		viewBox="0 0 32 32"
		xmlns="https://www.w3.org/2000/svg"
		{...props}
		ref={ref}
	>
		<path
			fillRule="evenodd"
			d="M5.333 3.666c-.914 0-1.667.753-1.667 1.667v12.252l3.627-3.626A1 1 0 0 1 8 13.666h8A1.666 1.666 0 0 0 17.666 12V5.333A1.667 1.667 0 0 0 16 3.666H5.333ZM1.666 5.333a3.675 3.675 0 0 1 3.667-3.667H16a3.667 3.667 0 0 1 3.666 3.667V12A3.667 3.667 0 0 1 16 15.666H8.414l-5.04 5.04A1 1 0 0 1 1.666 20V5.333Z"
			clipRule="evenodd"
		></path>
		<path
			fillRule="evenodd"
			d="M23 12a1 1 0 0 1 1-1h2.667a3.667 3.667 0 0 1 3.666 3.667v14.666a1 1 0 0 1-1.707.708L23.586 25H16a3.667 3.667 0 0 1-3.667-3.668V20a1 1 0 1 1 2 0v1.333A1.667 1.667 0 0 0 16 23h8a1 1 0 0 1 .707.293l3.626 3.626V14.667A1.667 1.667 0 0 0 26.667 13H24a1 1 0 0 1-1-1Z"
			clipRule="evenodd"
		></path>
	</chakra.svg>
));

export const UR = React.forwardRef((props, ref) => (
	<chakra.svg
		viewBox="0 0 40 40"
		xmlns="https://www.w3.org/2000/svg"
		{...props}
		ref={ref}
	>
		<path
			fill="#475BB2"
			d="M0 3.636A3.636 3.636 0 0 1 3.636 0h32.728A3.636 3.636 0 0 1 40 3.636v32.728A3.636 3.636 0 0 1 36.364 40H3.636A3.636 3.636 0 0 1 0 36.364V3.636Z"
		/>
		<path
			fill="#fff"
			// eslint-disable-next-line
			d="M28.99 10.623c-1.45.852-2.813 1.96-4.006 3.154-1.194 1.193-2.301 2.556-3.154 3.92a27.715 27.715 0 0 1 1.534 3.665c.767-1.62 1.705-3.068 2.898-4.347v4.602a6.29 6.29 0 0 1-4.602 6.052h-.17c-.171-2.216-.682-4.347-1.45-6.393a21.151 21.151 0 0 0-5.028-7.5c-1.193-1.193-2.557-2.215-4.006-3.153l-.34-.17v11.08c0 4.516 3.238 8.437 7.755 9.204h.085c1.023.17 2.046.17 2.983 0h.086c4.517-.767 7.755-4.688 7.755-9.205v-11.08l-.34.171Zm-15.256 10.91v-4.518c2.642 2.983 4.261 6.648 4.602 10.568a6.29 6.29 0 0 1-4.602-6.05Zm6.221-12.444a2.292 2.292 0 0 0-2.3 2.301 2.292 2.292 0 0 0 2.3 2.301 2.292 2.292 0 0 0 2.301-2.3 2.292 2.292 0 0 0-2.3-2.302Z"
		/>
	</chakra.svg>
));

export const Blockart = React.forwardRef((props, ref) => (
	<chakra.svg
		viewBox="0 0 40 40"
		xmlns="https://www.w3.org/2000/svg"
		fill="none"
		{...props}
		ref={ref}
	>
		<path
			fill="#2563EB"
			fillRule="evenodd"
			d="M0 36h38V0H0v36Zm35.946-2.057H2.054V2.057h33.892v31.886Zm-16.611-28.8 2.548 8.561-5.108.023 2.56-8.584Zm-4.232 14.242h8.475l1.508 7.662.14 2.782H13.222l.105-2.816 1.777-7.628Z"
			clipRule="evenodd"
		/>
	</chakra.svg>
));

export const MagazineBlocks = React.forwardRef((props, ref) => (
	<chakra.svg
		viewBox="0 0 40 40"
		xmlns="https://www.w3.org/2000/svg"
		{...props}
		ref={ref}
	>
		<rect width="40" height="40" fill="#8D42CE" rx="3.636" />
		<path
			fill="#fff"
			d="M19.781 26.7h-7.025V13.797l7.025 4.387V26.7Zm7.01 0h-7.01v-8.517l7.01-4.387V26.7Z"
		/>
		<path
			fill="#fff"
			d="M30.077 30.576h-21V9.5h21v21.076Zm-20.05-.95h19.115V10.45H10.027v19.176Z"
		/>
	</chakra.svg>
));

export const EVF = React.forwardRef((props, ref) => (
	<chakra.svg
		viewBox="0 0 40 40"
		xmlns="https://www.w3.org/2000/svg"
		{...props}
		ref={ref}
	>
		<rect width="40" height="40" fill="#7545BB" rx="3.636" />
		<path
			fill="#fff"
			d="M26.72 11h-4.31l1.32 2.224h4.309L26.72 11Zm2.71 4.447h-4.308l1.39 2.224h4.308l-1.39-2.224Zm-.069 11.119h-16.4l6.88-11.258 2.849 4.587h-2.85l-1.32 2.223h8.13l-6.81-10.98L9 28.79h21.751l-1.39-2.223Z"
		/>
	</chakra.svg>
));

export const Headphones = React.forwardRef((props, ref) => (
	<chakra.svg
		viewBox="0 0 20 20"
		xmlns="https://www.w3.org/2000/svg"
		{...props}
		ref={ref}
	>
		<path
			fillRule="evenodd"
			// eslint-disable-next-line
			d="M10 3.25A6.75 6.75 0 0 0 3.25 10v.917H5a2.417 2.417 0 0 1 2.417 2.416v2.5A2.417 2.417 0 0 1 5 18.25h-.833a2.417 2.417 0 0 1-2.417-2.417V10a8.25 8.25 0 1 1 16.5 0v5.833a2.417 2.417 0 0 1-2.417 2.417H15a2.417 2.417 0 0 1-2.417-2.417v-2.5A2.416 2.416 0 0 1 15 10.917h1.75V10A6.75 6.75 0 0 0 10 3.25Zm6.75 9.167H15a.916.916 0 0 0-.917.916v2.5a.917.917 0 0 0 .917.917h.833a.917.917 0 0 0 .917-.917v-3.416Zm-13.5 0v3.416a.917.917 0 0 0 .917.917H5a.917.917 0 0 0 .917-.917v-2.5A.916.916 0 0 0 5 12.417H3.25Z"
			clipRule="evenodd"
		/>
	</chakra.svg>
));

export const Masteriyo = React.forwardRef((props, ref) => (
	<chakra.svg
		viewBox="0 0 40 40"
		xmlns="https://www.w3.org/2000/svg"
		{...props}
		ref={ref}
	>
		<rect width="40" height="40" fill="#E9E3FD" rx="3.636" />
		<path
			fill="#787DFF"
			d="m14.163 11.898 3.851 4.281c.607.64.946 1.489.946 2.37v10.009l-4.8-3.353.003-13.307Z"
			opacity=".3"
		/>
		<path
			fill="#787DFF"
			d="m11.173 11.3 6.346 4.519a3.373 3.373 0 0 1 1.438 2.559V28.55l-7.785-4.102.001-13.148Z"
			opacity=".5"
		/>
		<path
			fill="#787DFF"
			d="m18.96 28.656-7.014-2.245A3.48 3.48 0 0 1 9.5 23.305V12.953l7.62 2.943a2.831 2.831 0 0 1 1.835 2.452v.16l.005 10.148Z"
		/>
		<path
			fill="#FD739C"
			d="m25.837 11.898-3.851 4.281a3.444 3.444 0 0 0-.946 2.364v10.008l4.8-3.353-.003-13.3Z"
			opacity=".3"
		/>
		<path
			fill="#FD739C"
			d="m28.828 11.3-6.346 4.519a3.374 3.374 0 0 0-1.438 2.559V28.55l7.785-4.102-.001-13.148Z"
			opacity=".5"
		/>
		<path
			fill="#FD739C"
			d="m21.04 28.656 7.013-2.245c1.373-.44 2.377-1.667 2.447-3.106V12.953l-7.617 2.943a2.832 2.832 0 0 0-1.836 2.452v.16l-.007 10.148Z"
		/>
	</chakra.svg>
));

export const Blockquote = React.forwardRef((props, ref) => (
	<chakra.svg
		viewBox="0 0 24 24"
		xmlns="https://www.w3.org/2000/svg"
		{...props}
		ref={ref}
	>
		<path
			xmlns="http://www.w3.org/2000/svg"
			fillRule="evenodd"
			d="M2 6a1 1 0 0 1 1-1h14a1 1 0 1 1 0 2H3a1 1 0 0 1-1-1Zm5 6a1 1 0 0 1 1-1h13a1 1 0 1 1 0 2H8a1 1 0 0 1-1-1Zm0 6a1 1 0 0 1 1-1h13a1 1 0 1 1 0 2H8a1 1 0 0 1-1-1Zm-4-7a1 1 0 0 1 1 1v6a1 1 0 1 1-2 0v-6a1 1 0 0 1 1-1Z"
			clipRule="evenodd"
		/>
	</chakra.svg>
));

export const Timeline = React.forwardRef((props, ref) => (
	<chakra.svg
		viewBox="0 0 24 24"
		xmlns="https://www.w3.org/2000/svg"
		{...props}
		ref={ref}
	>
		<path d="M11 3a1 1 0 1 1 2 0v18a1 1 0 1 1-2 0V3Z"></path>
		<path
			fillRule="evenodd"
			d="M16.037 7.397 15 6.517l.953-.789c.262-.436.74-.728 1.286-.728H20.5a1.5 1.5 0 0 1 0 3h-3.261c-.492 0-.929-.237-1.202-.603Zm0 11L15 17.517l1.025-.898A1.498 1.498 0 0 1 17.239 16H20.5a1.5 1.5 0 0 1 0 3h-3.261c-.492 0-.929-.237-1.202-.603ZM8 12.847l1-.83-.966-.811A1.499 1.499 0 0 0 6.76 10.5H3.5a1.5 1.5 0 0 0 0 3h3.261c.514 0 .968-.259 1.238-.653Z"
			clipRule="evenodd"
		></path>
	</chakra.svg>
));

export const Progress = React.forwardRef((props, ref) => (
	<chakra.svg
		viewBox="0 0 24 24"
		xmlns="https://www.w3.org/2000/svg"
		{...props}
		ref={ref}
	>
		<path
			fillRule="evenodd"
			d="M20 9.7H4a.3.3 0 0 0-.3.3v4a.3.3 0 0 0 .3.3h16a.3.3 0 0 0 .3-.3v-4a.3.3 0 0 0-.3-.3ZM4 8a2 2 0 0 0-2 2v4a2 2 0 0 0 2 2h16a2 2 0 0 0 2-2v-4a2 2 0 0 0-2-2H4Z"
			clipRule="evenodd"
		></path>
		<path d="M3 9h7v6H3V9Z"></path>
	</chakra.svg>
));

export const CTA = React.forwardRef((props, ref) => (
	<chakra.svg
		viewBox="0 0 24 24"
		xmlns="https://www.w3.org/2000/svg"
		{...props}
		ref={ref}
	>
		<path
			fillRule="evenodd"
			d="M3 5a2 2 0 0 1 2-2h14a2 2 0 0 1 2 2v7a2 2 0 0 1-2 2h-4v-2h4V5H5v7h7.5v2H5a2 2 0 0 1-2-2V5Z"
			clipRule="evenodd"
		></path>
		<path
			fillRule="evenodd"
			d="M12.046 9.848a.699.699 0 0 1 .786.124l7.25 6.897a.703.703 0 0 1 .158.793.696.696 0 0 1-.692.413l-3.638-.292-2.085 3.045a.696.696 0 0 1-.753.28.703.703 0 0 1-.52-.617l-.897-9.95a.699.699 0 0 1 .392-.693Zm1.168 2.417.556 6.164 1.215-1.774a.696.696 0 0 1 .63-.301l2.072.166-4.473-4.255Z"
			clipRule="evenodd"
		></path>
		<path d="M7 8.25c0 .45.333.75.833.75h8.334c.5 0 .833-.3.833-.75s-.333-.75-.833-.75H7.833c-.5 0-.833.375-.833.75Z"></path>
	</chakra.svg>
));

export const Slider = React.forwardRef((props, ref) => (
	<chakra.svg
		viewBox="0 0 24 24"
		xmlns="https://www.w3.org/2000/svg"
		{...props}
		ref={ref}
	>
		<path d="M16.2 22H7.8c-1 0-1.8-.9-1.8-2V4c0-1.1.8-2 1.8-2h8.3c1 0 1.8.9 1.8 2v16c.1 1.1-.7 2-1.7 2zM8 20h8V4H8v16zm-3-3H4V7h1V5H3.7C2.7 5 2 5.7 2 6.7v10.7c0 .9.7 1.6 1.7 1.6H5v-2zm14 2h1.3c.9 0 1.7-.7 1.7-1.7V6.7c0-1-.7-1.7-1.7-1.7H19v2h1v10h-1v2z"></path>
	</chakra.svg>
));

export const Map = React.forwardRef((props, ref) => (
	<chakra.svg
		viewBox="0 0 24 24"
		xmlns="https://www.w3.org/2000/svg"
		{...props}
		ref={ref}
	>
		<path d="M12 14c2.206 0 4-1.794 4-4s-1.794-4-4-4-4 1.794-4 4 1.794 4 4 4Zm0-6c1.103 0 2 .897 2 2s-.897 2-2 2-2-.897-2-2 .897-2 2-2Z"></path>
		<path d="M11.42 21.814a.998.998 0 0 0 1.16 0C12.884 21.599 20.029 16.44 20 10c0-4.411-3.589-8-8-8S4 5.589 4 9.995c-.029 6.445 7.116 11.604 7.42 11.819ZM12 4c3.309 0 6 2.691 6 6.005.021 4.438-4.388 8.423-6 9.73-1.611-1.308-6.021-5.294-6-9.735 0-3.309 2.691-6 6-6Z"></path>
	</chakra.svg>
));

export const Testimonial = React.forwardRef((props, ref) => (
	<chakra.svg
		viewBox="0 0 24 24"
		xmlns="https://www.w3.org/2000/svg"
		{...props}
		ref={ref}
	>
		<path d="M20.2 1.5H4.8c-1.2 0-2.2 1-2.2 2.2v12.9c0 1.2 1 2.2 2.2 2.2h3.9l3.8 3.7 3.8-3.7h3.9c1.2 0 2.2-1 2.2-2.2V3.7c0-1.2-1-2.2-2.2-2.2Zm0 15.1h-4.9l-2.8 2.8-2.8-2.8H4.8V3.7h15.4v12.9Z"></path>
		<path d="M8 11.6a1.5 1.5 0 1 0 0-3 1.5 1.5 0 0 0 0 3Zm4.5 0a1.5 1.5 0 1 0 0-3 1.5 1.5 0 0 0 0 3Zm4.5 0a1.5 1.5 0 1 0 0-3 1.5 1.5 0 0 0 0 3Z"></path>
	</chakra.svg>
));

export const Notice = React.forwardRef((props, ref) => (
	<chakra.svg
		viewBox="0 0 24 24"
		xmlns="https://www.w3.org/2000/svg"
		{...props}
		ref={ref}
	>
		<path
			fillRule="evenodd"
			d="M12 3a9 9 0 1 0 0 18 9 9 0 0 0 0-18ZM1 12C1 5.925 5.925 1 12 1s11 4.925 11 11-4.925 11-11 11S1 18.075 1 12Z"
			clipRule="evenodd"
		/>
		<path
			fillRule="evenodd"
			d="M12 7a1 1 0 0 1 1 1v4a1 1 0 0 1-2 0V8a1 1 0 0 1 1-1Zm-1 9a1 1 0 0 1 1-1h.01a1 1 0 0 1 0 2H12a1 1 0 0 1-1-1Z"
			clipRule="evenodd"
		/>
	</chakra.svg>
));

export const IconList = React.forwardRef((props, ref) => (
	<chakra.svg
		viewBox="0 0 24 24"
		xmlns="http://www.w3.org/2000/svg"
		{...props}
		ref={ref}
	>
		<path d="M7.1 9H21c.5 0 1-.5 1-1s-.5-1-1-1H7.1C6.5 7 6 7.4 6 8s.5 1 1.1 1zM21 11H7.1c-.6 0-1.1.4-1.1 1s.5 1 1.1 1H21c.6 0 1.1-.4 1.1-1s-.6-1-1.1-1zM21 15H7.1c-.6 0-1.1.5-1.1 1 0 .6.5 1 1.1 1H21c.6 0 1.1-.4 1.1-1-.1-.5-.6-1-1.1-1zM3.3 7.6L3.1 7H3l-.1.1-.2.5h-.6c-.1 0-.1.1-.1.1v.1l.4.4-.1.7c0 .1 0 .1.1.1h.1l.5-.4.5.4h.1v-.1l-.1-.7.5-.4v-.1s0-.1-.1-.1h-.6zM3.3 11.6l-.2-.5c0-.1-.1-.1-.1-.1l-.1.1-.2.5h-.6c-.1 0-.1.1-.1.2v.1l.4.4-.1.6c0 .1 0 .1.1.1h.1l.5-.4.5.4h.1v-.1l-.2-.6.6-.5v-.1s0-.1-.1-.1h-.6zM3.3 15.6l-.2-.5c0-.1-.1-.1-.1-.1l-.1.1-.2.5h-.6c-.1.1-.1.1-.1.2v.1l.4.4-.1.6c0 .1 0 .1.1.1h.1l.5-.4.5.4h.1v-.1l-.2-.6.6-.5v-.1s0-.1-.1-.1h-.6z" />
		<path
			fillRule="evenodd"
			d="M12 7a1 1 0 0 1 1 1v4a1 1 0 0 1-2 0V8a1 1 0 0 1 1-1Zm-1 9a1 1 0 0 1 1-1h.01a1 1 0 0 1 0 2H12a1 1 0 0 1-1-1Z"
			clipRule="evenodd"
		/>
	</chakra.svg>
));

export const Icon = React.forwardRef((props, ref) => (
	<chakra.svg
		viewBox="0 0 24 24"
		xmlns="http://www.w3.org/2000/svg"
		{...props}
		ref={ref}
	>
		<path
			// eslint-disable-next-line max-len
			d="m6.516 14.323-1.49 6.452a.998.998 0 0 0 1.529 1.057L12 18.202l5.445 3.63a1.001 1.001 0 0 0 1.517-1.106l-1.829-6.4 4.536-4.082a1 1 0 0 0-.59-1.74l-5.701-.454-2.467-5.461a.998.998 0 0 0-1.822 0L8.622 8.05l-5.701.453a1 1 0 0 0-.619 1.713l4.214 4.107zm2.853-4.326a.998.998 0 0 0 .832-.586L12 5.43l1.799 3.981a.998.998 0 0 0 .832.586l3.972.315-3.271 2.944c-.284.256-.397.65-.293 1.018l1.253 4.385-3.736-2.491a.995.995 0 0 0-1.109 0l-3.904 2.603 1.05-4.546a1 1 0 0 0-.276-.94l-3.038-2.962 4.09-.326z"
		/>
	</chakra.svg>
));

export const Lock = React.forwardRef((props, ref) => (
	<chakra.svg
		viewBox="0 0 150 131"
		xmlns="http://www.w3.org/2000/svg"
		{...props}
		ref={ref}
	>
		<path
			fill="#4584FF"
			d="M115.352 14.993 74.652 0l-40.31 14.795c-5.146 2.49-9.66 3.986-9.66 8.9v24.503A94.35 94.35 0 0 0 37.965 96.93c7.517 12.515 19.152 25.401 37.108 33.594 16.477-5.488 28.776-20.122 36.294-32.643a94.32 94.32 0 0 0 13.281-48.725V27.12c-.03-7.015-3.651-10.438-9.295-12.126Z"
		/>
		<path
			fill="#fff"
			d="M115.352 14.993 74.652 0l-40.31 14.795c-5.146 2.49-9.66 3.986-9.66 8.9v24.503A94.35 94.35 0 0 0 37.965 96.93c7.517 12.515 19.152 25.401 37.108 33.594 16.477-5.488 28.776-20.122 36.294-32.643a94.32 94.32 0 0 0 13.281-48.725V27.12c-.03-7.015-3.651-10.438-9.295-12.126Z"
			opacity=".8"
		/>
		<path
			fill="#4584FF"
			d="M99.503 76.975h-7.481V36.276a17.378 17.378 0 1 0-34.756 0v40.7h-7.482v-40.7a24.864 24.864 0 0 1 34.463-23.318 24.863 24.863 0 0 1 15.256 23.318v40.7Z"
		/>
		<path
			fill="#000"
			d="M99.503 76.975h-7.481V36.276a17.378 17.378 0 1 0-34.756 0v40.7h-7.482v-40.7a24.864 24.864 0 0 1 34.463-23.318 24.863 24.863 0 0 1 15.256 23.318v40.7Z"
			opacity=".4"
		/>
		<path
			fill="#4584FF"
			d="M104.669 58.864H44.62a3.477 3.477 0 0 0-3.477 3.478v36.03a3.478 3.478 0 0 0 3.477 3.478h60.049a3.477 3.477 0 0 0 3.477-3.478v-36.03a3.477 3.477 0 0 0-3.477-3.478Z"
		/>
		<path
			fill="#000"
			d="M80.243 74.76a5.603 5.603 0 1 0-7.128 5.388v8.379h3.058v-8.38a5.584 5.584 0 0 0 4.07-5.386Z"
			opacity=".5"
		/>
		<path
			fill="#FAFAFA"
			d="M44.715 97.773c-.156 0-.276-7.182-.276-16.01 0-8.828.12-16.01.276-16.01.155 0 .281 7.182.281 16.01 0 8.828-.126 16.01-.281 16.01ZM70.26 81.936s-.264-.084-.659-.37a6.722 6.722 0 0 1-1.442-1.473 7.847 7.847 0 0 1 2.789-11.779 6.884 6.884 0 0 1 1.975-.664c.246-.068.503-.082.754-.042 0 .108-1.06.21-2.514 1.053a7.781 7.781 0 0 0-2.65 11.21 16.391 16.391 0 0 0 1.747 2.065Z"
		/>
		<path
			fill="#4584FF"
			d="M2.58 107.847a2.58 2.58 0 1 0 0-5.16 2.58 2.58 0 0 0 0 5.16ZM150 23.48a2.576 2.576 0 0 1-3.086 2.523 2.581 2.581 0 0 1-1.876-3.517 2.577 2.577 0 0 1 3.371-1.395 2.588 2.588 0 0 1 1.396 1.4c.13.314.196.65.195.99ZM20.697 111.928a.657.657 0 1 1-1.315 0 .657.657 0 0 1 1.315 0Zm14-72.313a.659.659 0 1 1-1.318 0 .659.659 0 0 1 1.318 0Zm102.339 35.152a.655.655 0 0 1-.407.609.66.66 0 0 1-.897-.485.654.654 0 0 1 .285-.675.657.657 0 0 1 .618-.057.653.653 0 0 1 .401.608Zm9.116-25.579a.659.659 0 1 1-1.318.01.659.659 0 0 1 1.318-.01Z"
		/>
	</chakra.svg>
));

export const Megaphone = React.forwardRef((props, ref) => (
	<chakra.svg
		viewBox="0 0 42 42"
		xmlns="https://www.w3.org/2000/svg"
		{...props}
		fill="none"
		ref={ref}
	>
		<rect width="41" height="41" x=".5" y=".5" fill="#fff" rx="19.5" />
		<rect width="41" height="41" x=".5" y=".5" stroke="#DDD" rx="19.5" />
		<g clipPath="url(#a)">
			<path
				fill="#fff"
				d="M22.394 19.247c-1.098-4.806-.549-9.232 1.176-11.163a1.054 1.054 0 0 0-.502.242l-6.584 5.768-2.23 1.959a6.76 6.76 0 0 0-.497.816c-.66 1.276-1.39 2.887-1.157 4.451.336 2.276 2.13 4.059 3.91 5.049.275.153.56.285.855.395l2.372.359 8.4 1.645.126-.024c-2.38-.995-4.777-4.713-5.87-9.497Z"
			/>
			<path
				stroke="#E2E2E2"
				strokeMiterlimit="10"
				strokeWidth=".068"
				d="m30.987 28.236-2.726.509c-2.38-.991-4.775-4.713-5.868-9.497-1.098-4.806-.549-9.23 1.176-11.162l2.069-.38 5.349 20.53Z"
			/>
			<path
				fill="#E2E2E2"
				d="m13.812 23.726 9.819-.648 4.63 5.644-11.227-2.053s-3.132-.806-3.222-2.943Z"
			/>
			<path
				fill="#2E5DAD"
				d="M30.078 28.938a2.933 2.933 0 0 1-1.817-.193c-2.38-.991-4.775-4.713-5.868-9.497-1.098-4.806-.549-9.23 1.176-11.162.398-.47.932-.802 1.526-.952 2.868-.668 6.308 3.674 7.685 9.69 1.377 6.017.168 11.444-2.702 12.114Z"
			/>
			<path
				stroke="#fff"
				strokeMiterlimit="10"
				strokeWidth=".068"
				d="M22.394 19.247c-1.098-4.806-.549-9.232 1.176-11.163l-.284.052-6.802 5.958-2.23 1.959a6.76 6.76 0 0 0-.497.816c-.66 1.276-1.39 2.887-1.157 4.451.336 2.276 2.13 4.059 3.91 5.049.275.153.56.285.855.395l.631.013 1.744.341 8.4 1.646.127-.024c-2.385-.99-4.78-4.709-5.873-9.493Z"
			/>
			<path
				fill="#CBDEFA"
				d="M30.415 27.887c-.979.228-2.078-.456-3.101-1.776-.728-.935-1.419-2.19-2.003-3.663a23.67 23.67 0 0 1-1.069-3.465 24.559 24.559 0 0 1-.485-2.906 18.492 18.492 0 0 1-.056-3.417c.206-2.421.983-4.122 2.225-4.413 2.17-.505 4.932 3.48 6.171 8.904 1.24 5.423.486 10.23-1.683 10.736Z"
			/>
			<path
				fill="#B8C9E4"
				d="M28.982 25.042c-.492.741-1.243.984-1.668 1.066-1.249-1.606-2.388-4.15-3.068-7.132-.535-2.315-.694-4.519-.541-6.323.419-.416 1.069-.686 1.136-.686 1.71 0 3.448 2.567 4.31 6.341.657 2.889.549 5.507-.169 6.734Z"
			/>
			<path
				fill="#fff"
				d="m27.94 20.402-2.63 2.045a23.67 23.67 0 0 1-1.07-3.464 24.559 24.559 0 0 1-.485-2.907l3.116-.104v.018l1.056 4.376.013.036Z"
			/>
			<path
				fill="#2E5DAD"
				d="m14.253 16.08-4.918 2.161s-3.207 1.513-1.71 6.915c0 0 1.817 4.539 5.132 3.134l4.32-1.641S9.87 23.21 14.252 16.08Z"
			/>
			<path
				fill="#CEDAF7"
				d="M27.71 20.494c.522-.122.716-1.23.432-2.473-.284-1.244-.939-2.153-1.462-2.031-.523.122-.716 1.23-.432 2.473.284 1.244.938 2.153 1.461 2.031Z"
			/>
			<path
				stroke="#2E5DAD"
				strokeMiterlimit="10"
				strokeWidth=".137"
				d="M22.914 19.214c-1.098-4.806.856-11.237.856-11.237-.253.07-.49.19-.7.35l-6.584 5.767-2.232 1.96c-.185.26-.35.532-.497.815-.66 1.276-1.39 2.887-1.157 4.452.336 2.275 2.13 4.058 3.91 5.048.275.154.56.286.855.396l2.372.358 8.272 1.621c.19.003.382-.005.572-.022-2.379-.99-4.574-4.725-5.667-9.508Z"
			/>
			<path
				fill="#3C5385"
				d="m8.053 26.008 5.757-2.281s1.727 2.51 3.224 2.942l-4.672 1.762s-2.599 1.021-4.31-2.424Z"
			/>
			<path
				fill="#C9DDFB"
				d="m12.361 28.432 2 6.109c.125.381.206.821.778.784a1.36 1.36 0 0 1 .278.011l.107.017a.86.86 0 0 1 .673.53c.148.371.252.864-.126 1.051l.346-.027c.227-.017.441-.11.61-.265l.513-.466a.799.799 0 0 0 .25-.735 2.522 2.522 0 0 0-.067-.282.698.698 0 0 0-.582-.494 9.618 9.618 0 0 0-.573-.046.637.637 0 0 1-.578-.448l-.997-3.115-1.969-2.928-.663.304Z"
			/>
			<path
				fill="#2E5DAD"
				d="m15.638 30.794-.033.1-.014.044-1.604.432-.934-3.188 2.002-.756v.007l.577 1.713a2.62 2.62 0 0 1 .006 1.648Z"
			/>
			<path
				fill="#3E5589"
				d="m15.644 30.792-.034.108-1.57.416c.21-.634.228-1.317.054-1.961l-.374-1.389 1.337-.54.576 1.712c.183.535.186 1.116.011 1.654Z"
			/>
		</g>
		<defs>
			<clipPath id="a">
				<path fill="#fff" d="M7 7h27v30H7z" />
			</clipPath>
		</defs>
	</chakra.svg>
));

export const Support = React.forwardRef((props, ref) => (
	<chakra.svg
		viewBox="0 0 32 32"
		xmlns="http://www.w3.org/2000/svg"
		{...props}
		ref={ref}
	>
		<path
			fillRule="evenodd"
			d="M5.333 3.666c-.915 0-1.667.752-1.667 1.667v12.252l3.626-3.626A1 1 0 0 1 8 13.666h8a1.667 1.667 0 0 0 1.667-1.667V5.333A1.667 1.667 0 0 0 16 3.666H5.333ZM1.666 5.333a3.674 3.674 0 0 1 3.667-3.667h10.666a3.667 3.667 0 0 1 3.667 3.667v6.666a3.667 3.667 0 0 1-3.667 3.667H8.414l-5.04 5.04A1 1 0 0 1 1.665 20V5.333Z"
			clipRule="evenodd"
		/>
		<path
			fillRule="evenodd"
			d="M23 12a1 1 0 0 1 1-1h2.667a3.667 3.667 0 0 1 3.667 3.667v14.666a1 1 0 0 1-1.707.708L23.587 25H16a3.667 3.667 0 0 1-3.667-3.667V20a1 1 0 1 1 2 0v1.333A1.667 1.667 0 0 0 16.001 23h8a1 1 0 0 1 .707.293l3.626 3.626V14.667A1.666 1.666 0 0 0 26.667 13h-2.666a1 1 0 0 1-1-1Z"
			clipRule="evenodd"
		/>
	</chakra.svg>
));

export const PageNotFound = (props) => (
	<chakra.svg
		xmlns="http://www.w3.org/2000/svg"
		width="60px"
		height="60px"
		viewBox="0 0 60 60"
		fill="none"
	>
		<g clipPath="url(#clip0_6182_31901)">
			<path
				d="M58.2669 58.2843C57.5643 58.9862 56.6117 59.3805 55.6185 59.3805C54.6252 59.3805 53.6727 58.9862 52.97 58.2843L40.9512 46.2618L46.2481 40.9648L58.2669 53.002C58.9644 53.704 59.3559 54.6535 59.3559 55.6431C59.3559 56.6327 58.9644 57.5822 58.2669 58.2843Z"
				fill="#D3D3D3"
			/>
			<path
				d="M7.60839 7.627C3.97368 11.2654 1.49924 15.8997 0.497831 20.9441C-0.503575 25.9885 0.0130159 31.2166 1.98231 35.9675C3.9516 40.7184 7.28518 44.7788 11.5617 47.6355C15.8382 50.4921 20.8656 52.0168 26.0084 52.0168C31.1513 52.0168 36.1787 50.4921 40.4552 47.6355C44.7317 44.7788 48.0653 40.7184 50.0346 35.9675C52.0038 31.2166 52.5204 25.9885 51.519 20.9441C50.5176 15.8997 48.0432 11.2654 44.4085 7.627C41.993 5.20911 39.1247 3.29099 35.9675 1.98229C32.8103 0.673599 29.4261 0 26.0084 0C22.5907 0 19.2066 0.673599 16.0494 1.98229C12.8922 3.29099 10.0238 5.20911 7.60839 7.627ZM42.9066 42.9252C39.5648 46.2669 35.3072 48.5426 30.6721 49.4646C26.0369 50.3865 21.2325 49.9133 16.8663 48.1047C12.5002 46.2962 8.76833 43.2335 6.14276 39.3041C3.51719 35.3746 2.1158 30.7548 2.1158 26.0289C2.1158 21.303 3.51719 16.6832 6.14276 12.7537C8.76833 8.82423 12.5002 5.76157 16.8663 3.95302C21.2325 2.14447 26.0369 1.67125 30.6721 2.5932C35.3072 3.51515 39.5648 5.79086 42.9066 9.13256C45.1255 11.3514 46.8856 13.9856 48.0864 16.8846C49.2873 19.7837 49.9053 22.8909 49.9053 26.0289C49.9053 29.1668 49.2873 32.274 48.0864 35.1731C46.8856 38.0722 45.1255 40.7064 42.9066 42.9252Z"
				fill="#D3D3D3"
			/>
		</g>
		<defs>
			<clipPath id="clip0_6182_31901">
				<rect width="60" height="60" fill="white" />
			</clipPath>
		</defs>
	</chakra.svg>
);

Logo.displayName = "Logo";
Shortcode.displayName = "Shortcode";
SmartTag.displayName = "SmartTag";
ArrowRight.displayName = "ArrowRight";
Lock.displayName = "Lock";
Megaphone.displayName = "Megaphone";
Notice.displayName = "Notice";
Testimonial.displayName = "Testimonial";
Map.displayName = "Map";
Slider.displayName = "Slider";
CTA.displayName = "CTA";
Progress.displayName = "Progress";
Timeline.displayName = "Timeline";
Blockquote.displayName = "Blockquote";
Headphones.displayName = "Headphones";
EVF.displayName = "EVF";
MagazineBlocks.displayName = "MagazineBlocks";
Blockart.displayName = "Blockart";
Masteriyo.displayName = "Masteriyo";
UR.displayName = "UR";
Chat.displayName = "Chat";
Bulb.displayName = "Bulb";
Star.displayName = "Star";
Video.displayName = "Video";
DocsLines.displayName = "DocsLines";
Docs.displayName = "Docs";
ExternalLink.displayName = "ExternalLink";
CirclesInsideCircle.displayName = "CirclesInsideCircle";
DotsHorizontal.displayName = "DotsHorizontal";
Search.displayName = "Search";
Cog.displayName = "Cog";
Meter.displayName = "Meter";
ArrowsRepeat.displayName = "ArrowsRepeat";
ArrowsUpDown.displayName = "ArrowsUpDown";
Links.displayName = "Links";
ArrowRightFill.displayName = "ArrowRightFill";
ArrowLeftFill.displayName = "ArrowLeftFill";
QuestionCircleFill.displayName = "QuestionCircleFill";
Buttons.displayName = "Buttons";
Countdown.displayName = "Countdown";
Counter.displayName = "Counter";
Minus.displayName = "Minus";
Add.displayName = "Add";
Heading.displayName = "Heading";
Paragraph.displayName = "Paragraph";
Section.displayName = "Section";
Spacing.displayName = "Spacing";
Tabs.displayName = "Tabs";
Lottie.displayName = "Lottie";
InfoBox.displayName = "InfoBox";
Image.displayName = "Image";
TableOfContents.displayName = "TableOfContents";
SocialShare.displayName = "SocialShare";
Team.displayName = "Team";
ThreeCircleNodes.displayName = "ThreeCircleNodes";
IconList.displayName = "IconList";
Icon.displayName = "Icon";
PageNotFound.displayName = "PageNotFound";
Support.displayName = "Support";
