import React from "react";
import { chakra, forwardRef } from "@chakra-ui/react";
import { createElement } from "@wordpress/element";

export const Icon = () => {
	const Icon = createElement(
		"svg",
		{ width: 24, height: 24, viewBox: "0 0 32 32" },
		createElement("path", {
			fill: "currentColor",
			d: "M27.58 4a27.9 27.9 0 0 0-5.17 4 27 27 0 0 0-4.09 5.08 33.06 33.06 0 0 1 2 4.65A23.78 23.78 0 0 1 24 12.15V18a8 8 0 0 1-5.89 7.72l-.21.05a27 27 0 0 0-1.9-8.16A27.9 27.9 0 0 0 9.59 8a27.9 27.9 0 0 0-5.17-4L4 3.77V18a12 12 0 0 0 9.93 11.82h.14a11.72 11.72 0 0 0 3.86 0h.14A12 12 0 0 0 28 18V3.77zM8 18v-5.85a23.86 23.86 0 0 1 5.89 13.57A8 8 0 0 1 8 18zm8-16a3 3 0 1 0 3 3 3 3 0 0 0-3-3z"
		})
	);
	return Icon;
};

export const RegistrationForm = (props) => (
	<chakra.svg
		xmlns="http://www.w3.org/2000/svg"
		viewBox="0 0 24 24"
		fill="#475BB2"
		h="6"
		w="6"
		{...props}
	>
		<path
			fillRule="evenodd"
			d="M9.455 2a1.818 1.818 0 0 0-1.819 1.818h-.909A2.727 2.727 0 0 0 4 6.545v12.728A2.727 2.727 0 0 0 6.727 22h10.91a2.727 2.727 0 0 0 2.727-2.727V6.545a2.727 2.727 0 0 0-2.728-2.727h-.909A1.818 1.818 0 0 0 14.91 2H9.455Zm7.272 3.636a1.818 1.818 0 0 1-1.818 1.819H9.455a1.818 1.818 0 0 1-1.819-1.819h-.909a.91.91 0 0 0-.909.91v12.727a.91.91 0 0 0 .91.909h10.908a.91.91 0 0 0 .91-.91V6.546a.91.91 0 0 0-.91-.909h-.909Zm-7.272-.909v.91h5.454v-1.82H9.455v.91Zm-1.819 6.364a.91.91 0 0 1 .91-.91h7.272a.91.91 0 1 1 0 1.819H8.545a.91.91 0 0 1-.909-.91Zm.91 3.636a.91.91 0 1 0 0 1.819h7.272a.91.91 0 0 0 0-1.819H8.545Z"
			clipRule="evenodd"
		></path>
	</chakra.svg>
);

export const LoginForm = (props) => (
	<chakra.svg
		xmlns="http://www.w3.org/2000/svg"
		viewBox="0 0 24 24"
		fill="#475BB2"
		h="6"
		w="6"
		{...props}
	>
		<path
			fillRule="evenodd"
			d="M8.545 9.273a.91.91 0 1 0 0 1.818h7.273a.91.91 0 1 0 0-1.818H8.545Zm-.909 4.545a.91.91 0 0 1 .91-.909h7.272a.91.91 0 1 1 0 1.818H8.545a.91.91 0 0 1-.909-.909Zm.909 2.728a.91.91 0 1 0 0 1.818h1.819a.91.91 0 1 0 0-1.819H8.545Z"
			clipRule="evenodd"
		></path>
		<path
			fillRule="evenodd"
			d="M7.636 3.818C7.636 2.814 8.45 2 9.455 2h5.454c1.004 0 1.818.814 1.818 1.818h.91a2.727 2.727 0 0 1 2.727 2.727v12.728A2.727 2.727 0 0 1 17.636 22H6.727A2.727 2.727 0 0 1 4 19.273V6.545a2.727 2.727 0 0 1 2.727-2.727h.91Zm7.273 3.637a1.818 1.818 0 0 0 1.818-1.819h.91a.91.91 0 0 1 .909.91v12.727a.91.91 0 0 1-.91.909H6.727a.91.91 0 0 1-.909-.91V6.546a.91.91 0 0 1 .91-.909h.908c0 1.005.814 1.819 1.819 1.819h5.454ZM9.455 5.636V3.818h5.454v1.818H9.455Z"
			clipRule="evenodd"
		></path>
	</chakra.svg>
);

export const Myaccount = (props) => (
	<chakra.svg
		xmlns="http://www.w3.org/2000/svg"
		viewBox="0 0 24 24"
		fill="#475BB2"
		h="6"
		w="6"
		{...props}
	>
		<path
			fillRule="evenodd"
			d="M4 5a1 1 0 0 1 1-1h14a1 1 0 0 1 1 1v14a1 1 0 0 1-1 1h-.072a6.999 6.999 0 0 0-3.678-5.2 5 5 0 1 0-6.5 0A6.997 6.997 0 0 0 5.072 20H5a1 1 0 0 1-1-1V5Zm2 17H5a3 3 0 0 1-3-3V5a3 3 0 0 1 3-3h14a3 3 0 0 1 3 3v14a3 3 0 0 1-3 3H6Zm10.899-2H7.101a5 5 0 0 1 9.798 0ZM12 8a3 3 0 1 0 0 6 3 3 0 0 0 0-6Z"
			clipRule="evenodd"
		></path>
	</chakra.svg>
);

export const EditProfile = (props) => (
	<chakra.svg
		xmlns="http://www.w3.org/2000/svg"
		viewBox="0 0 24 24"
		fill="#475BB2"
		h="6"
		w="6"
		{...props}
	>
		<path
			fillRule="evenodd"
			d="M10.295 3.843a3.687 3.687 0 1 0 0 7.374 3.687 3.687 0 0 0 0-7.374ZM4.765 7.53a5.53 5.53 0 1 1 8.618 4.588.922.922 0 0 1-1.125 1.247 6.452 6.452 0 0 0-8.415 6.146.922.922 0 0 1-1.843 0 8.295 8.295 0 0 1 4.94-7.585A5.521 5.521 0 0 1 4.764 7.53Zm11.06 9.216a1.843 1.843 0 1 1 3.687 0 1.843 1.843 0 0 1-3.687 0Zm-1.812-.482a3.716 3.716 0 0 0 0 .965l-.13.057a.922.922 0 0 0 .75 1.685l.071-.032c.218.294.478.554.772.772l-.033.072a.922.922 0 1 0 1.685.749l.058-.13a3.712 3.712 0 0 0 .965 0l.058.13a.922.922 0 0 0 1.684-.749l-.032-.073c.293-.217.554-.477.771-.771l.072.032a.922.922 0 0 0 .748-1.685l-.129-.057a3.73 3.73 0 0 0 0-.965l.13-.058a.922.922 0 1 0-.75-1.684l-.071.032a3.708 3.708 0 0 0-.77-.771l.031-.072a.922.922 0 0 0-1.684-.748l-.058.128a3.72 3.72 0 0 0-.966 0l-.057-.128a.922.922 0 1 0-1.684.748l.031.072a3.707 3.707 0 0 0-.77.77l-.073-.031a.922.922 0 0 0-.748 1.684l.129.058Z"
			clipRule="evenodd"
		></path>
	</chakra.svg>
);
export const EditPassword = (props) => (
	<chakra.svg
		xmlns="http://www.w3.org/2000/svg"
		viewBox="0 0 24 24"
		fill="#475BB2"
		h="6"
		w="6"
		{...props}
	>
		<path
			fillRule="evenodd"
			d="M5.636 4a.91.91 0 0 0 0 1.818h.91a1.818 1.818 0 0 1 1.818 1.818v3.527a.993.993 0 0 0-.367.237l-.384.383-.383-.383c-.289-.29-.681-.365-.877-.17-.195.196-.12.588.17.877l.383.383-.383.384c-.29.288-.365.68-.17.876.196.195.588.12.877-.169l.383-.384.384.384c.112.112.24.193.367.237v2.91a1.818 1.818 0 0 1-1.819 1.817h-.909a.91.91 0 1 0 0 1.819h.91a3.637 3.637 0 0 0 2.727-1.232A3.637 3.637 0 0 0 12 20.364h.91a.91.91 0 1 0 0-1.817H12a1.818 1.818 0 0 1-1.818-1.819v-9.09A1.818 1.818 0 0 1 12 5.817h.91a.91.91 0 1 0 0-1.818H12A3.637 3.637 0 0 0 9.273 5.23 3.635 3.635 0 0 0 6.545 4h-.909Zm2.728 8.534v-.087l-.044.043.044.043Zm-3.637-3.08a.91.91 0 0 0-.909.91V14a.91.91 0 0 0 .91.91h.908a.91.91 0 1 1 0 1.817h-.909A2.728 2.728 0 0 1 2 14v-3.636a2.727 2.727 0 0 1 2.727-2.728h.91a.91.91 0 0 1 0 1.819h-.91Zm8.182-1.818a.91.91 0 1 0 0 1.819h6.364a.91.91 0 0 1 .909.909V14a.91.91 0 0 1-.91.91H12.91a.91.91 0 1 0 0 1.817h6.364A2.728 2.728 0 0 0 22 14v-3.636a2.727 2.727 0 0 0-2.727-2.728h-6.364Zm.795 5.238-.384-.384.384-.383c.289-.289.364-.681.17-.877-.196-.195-.588-.119-.877.17l-.384.383-.383-.383c-.289-.29-.681-.365-.877-.17-.195.196-.12.588.17.877l.383.383-.383.384c-.29.288-.365.68-.17.876.196.195.588.12.877-.169l.383-.384.384.384c.288.289.68.364.876.169.195-.195.12-.588-.17-.876Zm3.13-1.475.383.384.384-.383c.289-.289.68-.365.876-.17.195.196.12.588-.169.877l-.384.383.384.384c.288.288.364.68.169.876-.195.195-.588.12-.876-.17l-.384-.383-.383.384c-.289.289-.681.364-.877.17-.195-.196-.12-.588.17-.877l.383-.384-.384-.383c-.288-.289-.364-.681-.169-.877.196-.195.588-.12.877.17Z"
			clipRule="evenodd"
		></path>
	</chakra.svg>
);
export const ViewProfileDetails = (props) => (
	<chakra.svg
		xmlns="http://www.w3.org/2000/svg"
		viewBox="0 0 24 24"
		fill="#475BB2"
		h="6"
		w="6"
		{...props}
	>
		<path
			fillRule="evenodd"
			d="M14.911 8.874c0 .828-.31 1.583-.822 2.156a4.531 4.531 0 0 1 1.734 2.13 4.5 4.5 0 0 1 .314 1.736l-1.818-.032a2.704 2.704 0 0 0-2.523-2.747 2.703 2.703 0 0 0-2.523 2.747l-1.818.032a4.522 4.522 0 0 1 1.898-3.764 3.238 3.238 0 1 1 5.558-2.258Zm-4.657 0a1.42 1.42 0 1 1 1.44 1.42h-.02a1.42 1.42 0 0 1-1.42-1.42Z"
			clipRule="evenodd"
		></path>
		<path
			fillRule="evenodd"
			d="M9.273 16.546a.91.91 0 1 0 0 1.818h5.3a.91.91 0 1 0 0-1.819h-5.3Z"
			clipRule="evenodd"
		></path>
		<path
			fillRule="evenodd"
			d="M4.727 2A2.727 2.727 0 0 0 2 4.727v14.546A2.727 2.727 0 0 0 4.727 22h14.546A2.727 2.727 0 0 0 22 19.273V4.727A2.727 2.727 0 0 0 19.273 2H4.727Zm-.909 2.727a.91.91 0 0 1 .91-.909h14.545a.91.91 0 0 1 .909.91v14.545a.91.91 0 0 1-.91.909H4.728a.91.91 0 0 1-.909-.91V4.728Z"
			clipRule="evenodd"
		></path>
	</chakra.svg>
);
export const Popup = (props) => (
	<chakra.svg
		xmlns="http://www.w3.org/2000/svg"
		viewBox="0 0 24 24"
		fill="#475BB2"
		h="6"
		w="6"
		{...props}
	>
		<path
			fillRule="evenodd"
			d="M7.2 13.8a.84.84 0 0 1 .84-.84h7.92a.84.84 0 0 1 0 1.68H8.04a.84.84 0 0 1-.84-.84Zm0 3.36a.84.84 0 0 1 .84-.84h7.92a.84.84 0 0 1 0 1.68H8.04a.84.84 0 0 1-.84-.84Zm10.685-7.111a.72.72 0 0 0 0-1.018l-.949-.95.949-.948a.72.72 0 1 0-1.018-1.018l-.95.949-.948-.95a.72.72 0 1 0-1.018 1.019l.949.949-.95.949a.72.72 0 1 0 1.019 1.018l.949-.949.949.949a.72.72 0 0 0 1.018 0Z"
			clipRule="evenodd"
		></path>
		<path
			fillRule="evenodd"
			d="M1.92 4.8A2.88 2.88 0 0 1 4.8 1.92h14.4a2.88 2.88 0 0 1 2.88 2.88v14.4a2.88 2.88 0 0 1-2.88 2.88H4.8a2.88 2.88 0 0 1-2.88-2.88V4.8Zm2.88-.878h14.4c.485 0 .878.393.878.878v14.4a.878.878 0 0 1-.878.878H4.8a.878.878 0 0 1-.878-.878V4.8c0-.485.393-.878.878-.878Z"
			clipRule="evenodd"
		></path>
	</chakra.svg>
);
export const FrontendListing = (props) => (
	<chakra.svg
		xmlns="http://www.w3.org/2000/svg"
		viewBox="0 0 24 24"
		fill="#475BB2"
		h="6"
		w="6"
		{...props}
	>
		<path
			fillRule="evenodd"
			d="M4 2a2 2 0 0 0-2 2v5a2 2 0 0 0 2 2h5a2 2 0 0 0 2-2V4a2 2 0 0 0-2-2H4Zm0 2h5v5H4V4Zm0 9a2 2 0 0 0-2 2v5a2 2 0 0 0 2 2h5a2 2 0 0 0 2-2v-5a2 2 0 0 0-2-2H4Zm0 2h5v5H4v-5Z"
			clipRule="evenodd"
		></path>
		<path
			fillRule="evenodd"
			d="M13 4a1 1 0 0 1 1-1h7a1 1 0 1 1 0 2h-7a1 1 0 0 1-1-1Zm1 4a1 1 0 1 0 0 2h7a1 1 0 1 0 0-2h-7Zm-1 7a1 1 0 0 1 1-1h7a1 1 0 1 1 0 2h-7a1 1 0 0 1-1-1Zm1 4a1 1 0 1 0 0 2h7a1 1 0 1 0 0-2h-7Z"
			clipRule="evenodd"
		></path>
	</chakra.svg>
);
export const DownloadPdfButton = (props) => (
	<chakra.svg
		xmlns="http://www.w3.org/2000/svg"
		viewBox="0 0 24 24"
		fill="#475BB2"
		h="6"
		w="6"
		{...props}
	>
		<path
			fillRule="evenodd"
			d="M8.46 22H5.2a2.8 2.8 0 0 1-2.8-2.8V4.8A2.8 2.8 0 0 1 5.2 2h6.3a1 1 0 0 1 .7.29l6.3 6.3a1 1 0 0 1 .3.71v5.54a1 1 0 0 1-2 0V10.3h-5.3a1 1 0 0 1-1-1V4H5.2a.8.8 0 0 0-.8.8v14.4a.8.8 0 0 0 .8.8h3.26a1 1 0 0 1 0 2Zm4-13.7h2.89l-2.86-2.89-.03 2.89Zm.28 8.19a1.73 1.73 0 0 0-.74-.19h-1.9V22h.9v-2.2h1c.28.007.559-.055.81-.18.223-.12.407-.3.53-.52a1.65 1.65 0 0 0 .18-.79v-.47a1.73 1.73 0 0 0-.22-.84 1.26 1.26 0 0 0-.53-.51h-.03Zm-.2 1.75a.74.74 0 0 1-.17.5.54.54 0 0 1-.43.19H11v-1.77h1a.549.549 0 0 1 .44.19.78.78 0 0 1 .16.51l-.06.38Zm3.35-1.94h-1.63V22h1.65a2 2 0 0 0 .94-.19c.25-.12.456-.316.59-.56a1.87 1.87 0 0 0 .2-.88v-2.43a1.58 1.58 0 0 0-.45-1.21 1.81 1.81 0 0 0-1.27-.43h-.03Zm.81 4a.778.778 0 0 1-.22.58.81.81 0 0 1-.6.21h-.75v-4h.75a.81.81 0 0 1 .6.21.77.77 0 0 1 .22.58v2.42Zm2.7-3.18v1.63h1.86v.85h-1.83V22h-.9v-5.7h3.07v.86l-2.2-.04Z"
			clipRule="evenodd"
		></path>
	</chakra.svg>
);
export const ContentRestriction = (props) => (
	<chakra.svg
		xmlns="http://www.w3.org/2000/svg"
		viewBox="0 0 24 24"
		fill="#475BB2"
		h="6"
		w="6"
		{...props}
	>
		<path
			fillRule="evenodd"
			d="M7.5 2c-.716 0-1.403.287-1.91.799a2.741 2.741 0 0 0-.79 1.928v.91c0 .501.403.908.9.908s.9-.407.9-.909v-.909c0-.24.095-.472.264-.643a.895.895 0 0 1 .636-.266h6.3v2.727c0 .724.284 1.417.79 1.929a2.686 2.686 0 0 0 1.91.799h2.7v10a.914.914 0 0 1-.264.643.896.896 0 0 1-.636.266H5.7c-.497 0-.9.407-.9.909s.403.909.9.909h12.6c.716 0 1.403-.287 1.91-.799.505-.511.79-1.205.79-1.928V7.455a.914.914 0 0 0-.264-.643l-4.5-4.546A.895.895 0 0 0 15.6 2H7.5Zm8.1 2.195v2.35c0 .242.095.473.264.643.168.17.397.267.636.267h2.327L15.6 4.195Z"
			clipRule="evenodd"
		></path>
		<path
			fillRule="evenodd"
			d="M3 13.818A1.81 1.81 0 0 1 4.8 12v-.91c0-.722.284-1.416.79-1.928a2.686 2.686 0 0 1 1.91-.798 2.69 2.69 0 0 1 1.91.798c.506.512.79 1.206.79 1.929V12c.994 0 1.8.814 1.8 1.818v2.728a1.81 1.81 0 0 1-1.8 1.818H4.8A1.81 1.81 0 0 1 3 16.545v-2.727ZM8.4 12v-.91a.914.914 0 0 0-.264-.642.895.895 0 0 0-1.272 0 .914.914 0 0 0-.264.643V12h1.8Zm1.8 1.818v2.728H4.8v-2.728h5.4Z"
			clipRule="evenodd"
		></path>
	</chakra.svg>
);
export const LoginLogoutIcon = (props) => (
	<chakra.svg
		xmlns="http://www.w3.org/2000/svg"
		viewBox="0 0 24 24"
		fill="#475BB2"
		h="6"
		w="6"
		{...props}
	>
		<path
			fillRule="evenodd"
			d="M3 12a.9.9 0 0 1 .9-.9h9.3a.9.9 0 0 1 0 1.8H3.9A.9.9 0 0 1 3 12Zm10.23-5.32a.9.9 0 0 1 1.28 0l4.5 4.5a.9.9 0 0 1 0 1.28l-4.5 4.5a.9.9 0 1 1-1.28-1.28L16.72 12l-3.49-3.5a.9.9 0 0 1 0-1.28Z"
			clipRule="evenodd"
		/>
		<path
			fillRule="evenodd"
			d="M5.1 3A2.1 2.1 0 0 0 3 5.1v13.8A2.1 2.1 0 0 0 5.1 21h8.1a.9.9 0 0 0 0-1.8H5.1a.3.3 0 0 1-.3-.3V5.1a.3.3 0 0 1 .3-.3h8.1a.9.9 0 0 0 0-1.8H5.1Z"
			clipRule="evenodd"
		/>
	</chakra.svg>
);
export const ThankYou = (props) => (
	<chakra.svg
		xmlns="http://www.w3.org/2000/svg"
		viewBox="0 0 24 24"
		fill="#475BB2"
		h="6"
		w="6"
		{...props}
	>
		<path fillRule="evenodd" clipRule="evenodd" d="M15.1404 15.1464C15.3942 14.8926 15.8058 14.8926 16.0596 15.1464C16.2972 15.3841 16.4857 15.6662 16.6144 15.9767C16.743 16.2872 16.8092 16.62 16.8092 16.9561C16.8092 17.2921 16.743 17.6249 16.6144 17.9354C16.4857 18.2459 16.2972 18.528 16.0596 18.7657C15.822 19.0033 15.5398 19.1918 15.2293 19.3204C14.9188 19.449 14.5861 19.5152 14.25 19.5152C13.9139 19.5152 13.5811 19.449 13.2706 19.3204C12.9601 19.1918 12.678 19.0033 12.4404 18.7657L10.6404 16.9657C10.3865 16.7118 10.3865 16.3003 10.6404 16.0464C10.8942 15.7926 11.3058 15.7926 11.5596 16.0464L13.3596 17.8464C13.4765 17.9634 13.6153 18.0561 13.7681 18.1194C13.9209 18.1827 14.0846 18.2152 14.25 18.2152C14.4153 18.2152 14.5791 18.1827 14.7318 18.1194C14.8846 18.0561 15.0234 17.9634 15.1404 17.8464C15.2573 17.7295 15.35 17.5907 15.4133 17.4379C15.4766 17.2852 15.5092 17.1214 15.5092 16.9561C15.5092 16.7907 15.4766 16.627 15.4133 16.4742C15.35 16.3214 15.2573 16.1826 15.1404 16.0657C14.8865 15.8118 14.8865 15.4003 15.1404 15.1464Z" />
		<path fillRule="evenodd" clipRule="evenodd" d="M16.4994 5.20196C15.6283 4.68113 14.6084 4.46573 13.601 4.58986C12.5939 4.71398 11.6569 5.17041 10.9383 5.88694V5.88694L8.40958 8.41569C8.17344 8.65183 8.04077 8.97211 8.04077 9.30607C8.04077 9.64003 8.17344 9.96031 8.40958 10.1964C8.64573 10.4326 8.966 10.5653 9.29996 10.5653C9.63392 10.5653 9.9542 10.4326 10.1903 10.1964L10.9823 9.40445C11.6105 8.7771 12.4622 8.42445 13.35 8.42445C14.2377 8.42445 15.0892 8.77682 15.7173 9.40416L19.2096 12.8964C19.6895 13.3764 19.9592 14.0273 19.9592 14.7061C19.9592 15.3848 19.6895 16.0357 19.2096 16.5157C18.7296 16.9956 18.0787 17.2653 17.4 17.2653C16.7212 17.2653 16.0703 16.9956 15.5903 16.5157L13.3403 14.2657C13.0865 14.0118 13.0865 13.6003 13.3403 13.3464C13.5942 13.0926 14.0057 13.0926 14.2596 13.3464L16.5096 15.5964C16.7457 15.8326 17.066 15.9653 17.4 15.9653C17.7339 15.9653 18.0542 15.8326 18.2903 15.5964C18.5265 15.3603 18.6592 15.04 18.6592 14.7061C18.6592 14.3721 18.5265 14.0518 18.2903 13.8157L14.7986 10.324C14.4143 9.94008 13.8932 9.72444 13.35 9.72444C12.8067 9.72444 12.2857 9.94008 11.9013 10.324L11.1096 11.1157C10.6296 11.5956 9.9787 11.8653 9.29996 11.8653C8.62122 11.8653 7.97028 11.5956 7.49034 11.1157C7.0104 10.6357 6.74077 9.98481 6.74077 9.30607C6.74077 8.62733 7.0104 7.97639 7.49034 7.49645L10.0193 4.96745C10.9428 4.04644 12.1476 3.45914 13.442 3.29962C14.7363 3.14014 16.0467 3.41681 17.166 4.08585V4.08585L17.5918 4.33957C17.8363 4.48713 18.127 4.53845 18.4072 4.48355L18.4083 4.48332L19.9718 4.16883C20.3237 4.09804 20.6664 4.32595 20.7372 4.67789C20.808 5.02983 20.5801 5.37251 20.2281 5.44331L18.6621 5.75831L18.6596 5.75881C18.0625 5.87642 17.4431 5.76762 16.9219 5.45364L16.9201 5.45256L16.4994 5.20196Z"/>
		<path fillRule="evenodd" clipRule="evenodd" d="M20.0411 3.25873C20.3986 3.22622 20.7148 3.4897 20.7473 3.84721L21.6473 13.7472C21.6638 13.9291 21.6031 14.1095 21.48 14.2444C21.3568 14.3792 21.1826 14.4561 21 14.4561H19.2C18.841 14.4561 18.55 14.165 18.55 13.8061C18.55 13.4471 18.841 13.1561 19.2 13.1561H20.2882L19.4526 3.9649C19.4201 3.60739 19.6836 3.29123 20.0411 3.25873Z" />
		<path fillRule="evenodd" clipRule="evenodd" d="M3.95883 3.25873C4.31634 3.29123 4.57981 3.60739 4.54731 3.9649L3.67487 13.5617L9.3096 19.1964C9.54574 19.4326 9.86602 19.5652 10.2 19.5652C10.5339 19.5652 10.8542 19.4326 11.0904 19.1964C11.3265 18.9603 11.4592 18.64 11.4592 18.3061C11.4592 17.9721 11.3265 17.6518 11.0904 17.4157C10.8365 17.1618 10.8365 16.7503 11.0904 16.4964C11.3442 16.2426 11.7558 16.2426 12.0096 16.4964C12.4895 16.9764 12.7592 17.6273 12.7592 18.3061C12.7592 18.9848 12.4895 19.6357 12.0096 20.1157C11.5297 20.5956 10.8787 20.8652 10.2 20.8652C9.52124 20.8652 8.8703 20.5956 8.39036 20.1157L2.54036 14.2657C2.40395 14.1293 2.33518 13.9393 2.35265 13.7472L3.25265 3.84721C3.28515 3.4897 3.60132 3.22622 3.95883 3.25873Z"/>
		<path fillRule="evenodd" clipRule="evenodd" d="M3.24998 4.80606C3.24998 4.44707 3.54099 4.15606 3.89998 4.15606H11.1C11.459 4.15606 11.75 4.44707 11.75 4.80606C11.75 5.16504 11.459 5.45606 11.1 5.45606H3.89998C3.54099 5.45606 3.24998 5.16504 3.24998 4.80606Z" fill="#475BB2"/>
	</chakra.svg>
);
export const MembershipListing = (props) => (
	<chakra.svg
		xmlns="http://www.w3.org/2000/svg"
		viewBox="0 0 24 24"
		fill="#475BB2"
		h="6"
		w="6"
		{...props}
	>
		<path d="M4.468 22.393h15.064c.815 0 1.468-.653 1.468-1.469V3.468C21 2.653 20.347 2 19.532 2H4.468C3.653 2 3 2.653 3 3.468v17.484c.027.788.68 1.44 1.468 1.44Zm-.49-18.925c0-.272.218-.49.49-.49h15.064c.272 0 .49.218.49.49v17.484c0 .272-.218.49-.49.49H4.468a.487.487 0 0 1-.49-.49V3.468Z"/>
		<path d="M18.499 6.106h-6.445v.979H18.5v-.98Zm0 5.601h-6.445v.979H18.5v-.979Zm0 5.628h-6.445v.98H18.5v-.98ZM8.846 6.46a1.36 1.36 0 0 0 .38-.952c0-.762-.625-1.36-1.359-1.36-.761 0-1.36.625-1.36 1.36 0 .353.136.706.381.951a1.357 1.357 0 0 0-1.196 1.36v.788c0 .245.19.435.435.435h3.507a.43.43 0 0 0 .435-.435V7.82c-.027-.707-.543-1.305-1.223-1.36Zm-.979-1.442c.272 0 .49.218.49.49a.488.488 0 0 1-.49.489.487.487 0 0 1-.49-.49c0-.271.218-.489.49-.489Zm1.305 3.127H6.535V7.79c0-.271.217-.462.462-.462h1.686c.272 0 .462.218.462.462l.027.354Zm-.326 3.915c.245-.244.38-.598.38-.951 0-.762-.625-1.36-1.359-1.36a1.365 1.365 0 0 0-.979 2.311 1.357 1.357 0 0 0-1.196 1.36v.788c0 .245.19.435.435.435h3.507a.43.43 0 0 0 .435-.435v-.788c-.027-.707-.543-1.278-1.223-1.36Zm-.979-1.414c.272 0 .49.218.49.49s-.218.49-.49.49a.505.505 0 0 1-.49-.49c0-.245.218-.49.49-.49Zm1.305 3.1H6.535v-.353c0-.272.217-.463.462-.463h1.686c.272 0 .462.218.462.463l.027.353Zm-.326 3.943c.245-.245.38-.598.38-.952 0-.761-.625-1.36-1.359-1.36-.761 0-1.36.626-1.36 1.36 0 .354.136.707.381.952a1.357 1.357 0 0 0-1.196 1.36v.76c0 .245.19.436.435.436h3.507a.43.43 0 0 0 .435-.435v-.789a1.398 1.398 0 0 0-1.223-1.332Zm-.979-1.441c.272 0 .49.217.49.49a.488.488 0 0 1-.49.489.487.487 0 0 1-.49-.49c0-.272.218-.49.49-.49Zm1.305 3.127H6.535v-.354c0-.272.217-.462.462-.462h1.686c.272 0 .462.217.462.462l.027.354Z"/>
	</chakra.svg>
);
