<?php

/**
 * The admin-specific functionality of the plugin.
 *
 * @since      0.10
 *
 * @package    User_Dashboard_For_Easy_Digital_Downloads
 * @subpackage User_Dashboard_For_Easy_Digital_Downloads/admin
 */

/**
 * The admin-specific functionality of the plugin.
 *
 * Defines the plugin name, version, and two examples hooks for how to
 * enqueue the admin-specific stylesheet and JavaScript.
 *
 * @package    User_Dashboard_For_Easy_Digital_Downloads
 * @subpackage User_Dashboard_For_Easy_Digital_Downloads/admin
 * @author     WebsiteGuider <support@websiteguider.com>
 */
class User_Dashboard_For_EDD_Admin {

	/**
	 * The ID of this plugin.
	 *
	 * @since    1.0.0
	 * @access   private
	 * @var      string    $plugin_name    The ID of this plugin.
	 */
	private $plugin_name;

	/**
	 * The version of this plugin.
	 *
	 * @since    1.0.0
	 * @access   private
	 * @var      string    $version    The current version of this plugin.
	 */
	private $version;

	/**
	 * Initialize the class and set its properties.
	 *
	 * @since    1.0.0
	 * @param      string    $plugin_name       The name of this plugin.
	 * @param      string    $version    The version of this plugin.
	 */
	public function __construct( $plugin_name, $version ) {

		$this->plugin_name = $plugin_name;
		$this->version = $version;

	}

	/**
	 * Register the stylesheets for the admin area.
	 *
	 * @since    1.0.0
	 */
	public function enqueue_styles() {

		/**
		 * This function is provided for demonstration purposes only.
		 *
		 * An instance of this class should be passed to the run() function
		 * defined in Plugin_Name_Loader as all of the hooks are defined
		 * in that particular class.
		 *
		 * The Plugin_Name_Loader will then create the relationship
		 * between the defined hooks and the functions defined in this
		 * class.
		 */

		wp_enqueue_style( $this->plugin_name, USER_DASHBOARD_FOR_EDD_PLUGIN_DIR_URI . 'admin/css/user-dashboard-for-edd-admin.css', array(), $this->version, 'all' );

	}

	/**
	 * Register the JavaScript for the admin area.
	 *
	 * @since    1.0.0
	 */
	public function enqueue_scripts() {

		/**
		 * This function is provided for demonstration purposes only.
		 *
		 * An instance of this class should be passed to the run() function
		 * defined in Plugin_Name_Loader as all of the hooks are defined
		 * in that particular class.
		 *
		 * The Plugin_Name_Loader will then create the relationship
		 * between the defined hooks and the functions defined in this
		 * class.
		 */
		wp_enqueue_media();

		wp_enqueue_script( $this->plugin_name, USER_DASHBOARD_FOR_EDD_PLUGIN_DIR_URI . 'admin/js/user-dashboard-for-edd-admin.js', array( 'jquery' ), $this->version, false );

		wp_localize_script( $this->plugin_name, 'udAjax', array(
			'url' => admin_url('admin-ajax.php'),
		) );

	}

}
