<?php
/**
 * Plugin Name: UrlifyWriter
 * Plugin URI: https://urlifywriter.com/
 * Description: AI Content Generator & Auto Blog Writer for WordPress. Generate articles automatically from any URL with a simple workflow.
 * Version: 1.02
 * Author: AutoPress AI
 * License: GPLv2 or later
 * License URI: https://www.gnu.org/licenses/gpl-2.0.html
 */

if ( ! defined('ABSPATH') ) { exit; }

/**
 * Constantes básicas
 */
define('URLIFYWRITER_VERSION',        '1.0.0');
define('URLIFYWRITER_SLUG',           'urlifywriter');
define('URLIFYWRITER_PREFIX',         'urlifywriter');
define('URLIFYWRITER_PLUGIN_FILE',    __FILE__);
define('URLIFYWRITER_PLUGIN_DIR',     plugin_dir_path(__FILE__));
define('URLIFYWRITER_PLUGIN_URL',     plugin_dir_url(__FILE__));
define('URLIFYWRITER_DEBUG', false);

define('URLIFYWRITER_API_BASE', 'https://autopress-api.ilzo014.workers.dev');
define('URLIFYWRITER_ART_API',  URLIFYWRITER_API_BASE . '/article/create');
define('URLIFYWRITER_LIC_HMAC', 'e83d9f4a6c12b7f0d58a1c3e7b9054fa2d16c8b9f41e7a2035c9d6b0a8f2e1c7'); // la que te pasé
define('URLIFYWRITER_IMG_API',  'https://autopress-api-images.ilzo014.workers.dev/images/create');
define('URLIFYWRITER_LIC_API',  'https://license-worker.ilzo014.workers.dev/license/validate');


if ( ! defined('URLIFYWRITER_PRICING_URL') ) define('URLIFYWRITER_PRICING_URL', 'https://urlifywriter.com/pricing/');
if ( ! defined('URLIFYWRITER_TERMS_URL') )   define('URLIFYWRITER_TERMS_URL',   'https://urlifywriter.com/terms/');


if ( ! defined('URLIFYWRITER_LIC_API') ) {
	define('URLIFYWRITER_LIC_API', URLIFYWRITER_ART_API);
}

if ( ! defined('URLIFYWRITER_REMOTE_TIMEOUT') ) {
	define('URLIFYWRITER_REMOTE_TIMEOUT', 120); // seconds (use 30–60)
}


/**
 * Menú de administración
 */
add_action('admin_menu', function () {
	// Main menu
	add_menu_page(
		__('UrlifyWriter', 'urlifywriter'),
		__('UrlifyWriter', 'urlifywriter'),
		'manage_options',
		'urlifywriter',
		'urlifywriterrender_admin_page',
		plugin_dir_url(__FILE__) . 'assets/icon.png',
		58
	);

	// Submenu: Create from URL
	add_submenu_page(
		'urlifywriter',
		__('Create Draft from URL', 'urlifywriter'),
		__('Create Article', 'urlifywriter'),
		'edit_posts',
		'urlifywriter-url',
		'urlifywriterrender_create_from_url_page'
	);

	// Submenu: Auto Scan
	add_submenu_page(
		'urlifywriter',
		__('Auto Scan', 'urlifywriter'),
		__('Auto Scan', 'urlifywriter'),
		'manage_options',
		'urlifywriter-autoscan',
		'urlifywriterrender_autoscan_page'
	);

	// Submenu: Settings
	add_submenu_page(
		'urlifywriter',
		__('Settings', 'urlifywriter'),
		__('Settings', 'urlifywriter'),
		'manage_options',
		'urlifywriter-settings',
		'urlifywriterrender_settings_page'
	);

	// Submenu: License
	add_submenu_page(
		'urlifywriter',
		__('License', 'urlifywriter'),
		__('License', 'urlifywriter'),
		'manage_options',
		'urlifywriter-license',
		'urlifywriterrender_license_page'
	);

	// Submenu: Connections
	add_submenu_page(
		'urlifywriter',
		__('Connections (APIs)', 'urlifywriter'),
		__('Connections (APIs)', 'urlifywriter'),
		'manage_options',
		'urlifywriter-connections',
		'urlifywriterrender_connections_page'
	);
	add_submenu_page(
		'urlifywriter',
		__('How to Use', 'urlifywriter'),
		__('How to Use', 'urlifywriter'),
		'manage_options',
		'urlifywriter-how-to-use',
		'urlifywriter_render_how_to_use_page'
	);

	// Submenu: Support
	add_submenu_page(
		'urlifywriter',
		__('Support', 'urlifywriter'),
		__('Support', 'urlifywriter'),
		'manage_options',
		'urlifywriter-support',
		'urlifywriter_render_support_page'
	);
});

/**
 * Render del dashboard simple (página principal)
 */
function urlifywriterrender_admin_page() {
	if ( ! current_user_can('manage_options') ) {
		wp_die( esc_html__('You do not have sufficient permissions to access this page.', 'urlifywriter') );
	}

	echo '<div class="wrap">';
	echo '<h1>' . esc_html__('UrlifyWriter', 'urlifywriter') . '</h1>';
	echo '<p>' . esc_html__('MVP ready. Use the submenu "Create from URL" to start the URL → Draft flow.', 'urlifywriter') . '</p>';
	echo '</div>';
}

/**
 * Carga de archivos
 */
require_once URLIFYWRITER_PLUGIN_DIR . 'admin/page-create-from-url.php';
require_once URLIFYWRITER_PLUGIN_DIR . 'admin/page-settings.php';
require_once URLIFYWRITER_PLUGIN_DIR . 'includes/extractor.php';
require_once URLIFYWRITER_PLUGIN_DIR . 'includes/generator.php';
require_once URLIFYWRITER_PLUGIN_DIR . 'includes/post-writer.php';
require_once URLIFYWRITER_PLUGIN_DIR . 'admin/page-license.php';
require_once URLIFYWRITER_PLUGIN_DIR . 'includes/ajax.php';
require_once URLIFYWRITER_PLUGIN_DIR . 'admin/page-connections.php';
require_once URLIFYWRITER_PLUGIN_DIR . 'admin/page-autoscan.php';
require_once URLIFYWRITER_PLUGIN_DIR . 'includes/autoscan-manager.php';
require_once URLIFYWRITER_PLUGIN_DIR . 'includes/autoscan-crawler.php';
require_once URLIFYWRITER_PLUGIN_DIR . 'includes/autoscan-cron.php';
require_once URLIFYWRITER_PLUGIN_DIR . 'includes/autoscan-ajax.php';
require_once URLIFYWRITER_PLUGIN_DIR . 'admin/page-support.php';
require_once URLIFYWRITER_PLUGIN_DIR . 'admin/page-how-to-use.php';

if ( is_admin() ) {
	require_once plugin_dir_path( __FILE__ ) . 'includes/admin-enqueue.php';
}

/**
 * Activación / desactivación
 * - Arranca AutoScan solo en activación (si está habilitado)
 * - Mantiene tu AutoGen tal cual
 */
register_activation_hook( URLIFYWRITER_PLUGIN_FILE, function () {

	// 1) Tablas AutoScan
	if ( function_exists('urlifywriterautoscan_install_sources_items') ) {
		urlifywriterautoscan_install_sources_items();
	}
	// Legacy opcional
	if ( function_exists('urlifywriterautoscan_install_tables') ) {
		urlifywriterautoscan_install_tables();
	}

	// 2) Defaults sensatos
	if ( get_option('urlifywriterautoscan_interval') === false ) {
		update_option('urlifywriterautoscan_interval', 'urlifywriterevery_5_minutes'); // o 'hourly' si prefieres
	}
	if ( get_option('urlifywriterautoscan_enabled') === false ) {
		update_option('urlifywriterautoscan_enabled', '1'); // habilitado por defecto
	}

	// 3) Programar AutoScan solo si está habilitado
	$enabled  = get_option('urlifywriterautoscan_enabled', '1');
	$interval = get_option('urlifywriterautoscan_interval', 'urlifywriterevery_5_minutes');

	// asegura que el intervalo custom existe (lo registra autoscan-cron.php con cron_schedules)
	if ( $enabled === '1' && ! wp_next_scheduled('urlifywriterautoscan_cron') ) {
		wp_schedule_event( time() + 60, $interval, 'urlifywriterautoscan_cron' );
	}

	// 4) AutoGen (como lo tenías)
	if ( function_exists('urlifywriterautogen_schedule_event') ) {
		if ( ! get_option('urlifywriterautogen_interval') ) update_option('urlifywriterautogen_interval', 'urlifywriterevery_5_minutes');
		if ( ! get_option('urlifywriterautogen_batch') )    update_option('urlifywriterautogen_batch', 1);
		urlifywriterautogen_schedule_event( get_option('urlifywriterautogen_interval', 'urlifywriterevery_5_minutes') );
	}
});

register_deactivation_hook( URLIFYWRITER_PLUGIN_FILE, function () {
	// Limpia AutoScan al desactivar
	if ( $ts = wp_next_scheduled('urlifywriterautoscan_cron') ) {
		wp_unschedule_event($ts, 'urlifywriterautoscan_cron');
	}
	// Limpia AutoGen si quieres (opcional)
	if ( function_exists('wp_next_scheduled') && function_exists('wp_unschedule_event') ) {
		if ( $ts = wp_next_scheduled('urlifywriterautogen_cron') ) {
			wp_unschedule_event($ts, 'urlifywriterautogen_cron');
		}
	}
});

/**
 * Estilos admin (solo en nuestras páginas)
 */
add_action('admin_enqueue_scripts', function ($hook) {
	// Evita usar $_GET: usa $hook o get_current_screen().
	$is_urlifywriter = false;

	if ( function_exists('get_current_screen') ) {
		$screen = get_current_screen();
		if ( $screen && isset($screen->id) ) {
			$is_urlifywriter = ( false !== strpos($screen->id, URLIFYWRITER_SLUG) ); // p.ej. 'toplevel_page_urlifywriter'
		}
	}

	// Fallback por si $screen no está disponible aún
	if ( ! $is_urlifywriter && is_string($hook) ) {
		$is_urlifywriter = ( false !== strpos($hook, URLIFYWRITER_SLUG) ); // p.ej. 'toplevel_page_urlifywriter'
	}

	if ( ! $is_urlifywriter ) {
		return;
	}

	wp_enqueue_style(
		'urlifywriter-admin',
		URLIFYWRITER_PLUGIN_URL . 'css/admin.css',
		[],
		URLIFYWRITER_VERSION
	);

	// CSS extra SOLO para Help / Support
	$is_help_page =
		( strpos($hook, 'urlifywriter-support') !== false ) ||
		( strpos($hook, 'urlifywriter-how-to-use') !== false );

	if ( $is_help_page ) {
		wp_enqueue_style(
			'urlifywriter-admin-help',
			URLIFYWRITER_PLUGIN_URL . 'css/admin-help.css',
			['urlifywriter-admin'], // depende del base
			URLIFYWRITER_VERSION
		);
	}
});

add_action('admin_menu', function () {
	remove_submenu_page('urlifywriter', 'urlifywriter');
}, 999);

/**
 * ⚠️ Eliminado el “asegurador” en admin_init que reprogramaba AutoScan.
 *    Con esto el botón Stop deja de reencenderse solo.
 *    Si en el futuro cambias el intervalo desde Ajustes, reprograma en ese momento
 *    (hazlo en el handler que guarda la opción, no en admin_init).
 */
