jQuery(function($){
  const $btn   = $('#urlifywriter-validate-btn');
  const $badge = $('#urlifywriter-license-state');

  if (!$btn.length) return;

  $btn.on('click', function(){
    $btn.prop('disabled', true).text(URLIFYWRITER_LICENSE.i18n.validating);
    $.post(URLIFYWRITER_LICENSE.ajax_url, {
      action: 'urlifywritervalidate_license',
      nonce: URLIFYWRITER_LICENSE.nonce
    }).done(function(res){
      if (res && res.success && res.data) {
        $badge.removeClass('valid invalid unknown')
              .addClass(res.data.state)
              .text(res.data.label);
      } else {
        alert(URLIFYWRITER_LICENSE.i18n.ko);
      }
    }).fail(function(){
      alert(URLIFYWRITER_LICENSE.i18n.ko);
    }).always(function(){
      $btn.prop('disabled', false).text('Validate Now (Simulated)');
    });
  });
});
