(function () {
  function $(id){ return document.getElementById(id); }

  const ex   = $('urlifywritermax_words');
  const exV  = $('urlifywritermax_words_val');

  const min  = $('urlifywritertarget_min_words');
  const minV = $('urlifywritertarget_min_words_val');

  const max  = $('urlifywritertarget_max_words');
  const maxV = $('urlifywritertarget_max_words_val');

  function syncVal(inp, out){ if(inp && out){ out.textContent = inp.value; } }

  function enforceBounds(){
    if (min && max) {
      const minVal = parseInt(min.value || 0, 10);
      const maxVal = parseInt(max.value || 0, 10);
      if (minVal > maxVal) {
        max.value = String(minVal);
        syncVal(max, maxV);
      }
    }
  }

  // Images: enable/disable fieldset + subrows toggle
  const imagesEnabled = $('urlifywriterimages_enabled');
  const sourceRadios  = document.querySelectorAll('input[name="urlifywriterimage_source"]');
  const subrows       = document.querySelectorAll('.urlifywriter-subrow');

  function toggleImagesEnabled(){
    const on = imagesEnabled && imagesEnabled.checked;
    const fieldset = $('urlifywriterimage_source_group');
    if (!fieldset) return;

    fieldset.querySelectorAll('input,select,button').forEach(el=>{
      if (el.id === 'urlifywriterimages_enabled') return;
      el.disabled = !on;
    });
  }

  function updateSubrows(){
    const checked = document.querySelector('input[name="urlifywriterimage_source"]:checked');
    const val = checked ? checked.value : 'pixabay';
    subrows.forEach(sr=>{
      sr.style.display = (sr.getAttribute('data-for') === val) ? '' : 'none';
    });
  }

  if (imagesEnabled){
    imagesEnabled.addEventListener('change', toggleImagesEnabled);
    toggleImagesEnabled();
  }

  sourceRadios.forEach(r => r.addEventListener('change', updateSubrows));
  updateSubrows();

  // Sliders listeners
  if (ex)  ex.addEventListener('input',  function(){ syncVal(ex, exV); });
  if (min) min.addEventListener('input', function(){ syncVal(min, minV); enforceBounds(); });
  if (max) max.addEventListener('input', function(){ syncVal(max, maxV); enforceBounds(); });

  // Init
  syncVal(ex, exV); syncVal(min, minV); syncVal(max, maxV);
  enforceBounds();
})();
