(function () {
  const cfg = window.urlifywriterLicense || {};
  const ajaxurl = window.ajaxurl || cfg.ajaxUrl;

  const $btn   = document.getElementById('urlifywriter-validate-btn');
  const $badge = document.getElementById('urlifywriter-license-state');
  const $input = document.getElementById('urlifywriterlicense_key');
  const $tbody = document.getElementById('urlifywriter-license-details');

  if (!$btn || !$badge || !$input || !$tbody || !ajaxurl) return;

  let busy = false;

  function setBusy(on){
    busy = !!on;
    $btn.disabled = busy || !$input.value.trim();
    $btn.textContent = busy ? (cfg.validatingLabel || 'Validating…')
                            : (cfg.validateLabel || 'Validate');
  }

  function labelForState(state, details){
    if (state === 'invalid' && details && typeof details.notes === 'string' && details.notes.indexOf('expired') !== -1) {
      return 'Invalid (expired)';
    }
    return state.charAt(0).toUpperCase() + state.slice(1);
  }

  function setState(state, details){
    $badge.classList.remove('valid','invalid','unknown');
    $badge.classList.add(state);
    $badge.textContent = labelForState(state, details);
  }

  function esc(s){
    return String(s == null ? '' : s)
      .replace(/&/g,'&amp;').replace(/</g,'&lt;').replace(/>/g,'&gt;')
      .replace(/"/g,'&quot;').replace(/'/g,'&#039;');
  }

  function fmtDT(iso){
    try { return new Date(iso).toLocaleString(); } catch(e){ return iso || ''; }
  }

  function buildDetailsHTML(details){
    if (!details || typeof details !== 'object') {
      return '<tr><td colspan="2"><p class="description">' + esc(cfg.iNoDetailsYet || '') + '</p></td></tr>';
    }

    const rows = [];

    if (details.issued_at) {
      rows.push('<tr><td style="width:220px;"><strong>'+esc(cfg.iIssuedAt||'')+'</strong></td><td>'+esc(fmtDT(details.issued_at))+'</td></tr>');
    }
    if (details.expires_at) {
      rows.push('<tr><td><strong>'+esc(cfg.iValidUntil||'')+'</strong></td><td>'+esc(fmtDT(details.expires_at))+'</td></tr>');
    }

    let perMonth = null, usedMonth = null;
    if (details.caps && Number.isFinite(details.caps.articles_per_month)) perMonth = details.caps.articles_per_month;
    if (details.usage && Number.isFinite(details.usage.articles_used_month)) usedMonth = details.usage.articles_used_month;

    if ((perMonth == null || usedMonth == null) && typeof details.notes === 'string') {
      const m = details.notes.match(/month_used=(\d+)\/(\d+)/);
      if (m) { usedMonth = parseInt(m[1],10); perMonth = parseInt(m[2],10); }
    }

    if (perMonth != null || usedMonth != null) {
      const tot = perMonth != null ? perMonth : '–';
      const usd = usedMonth != null ? usedMonth : '–';
      rows.push('<tr><td><strong>'+esc(cfg.iArticlesMonth||'')+'</strong></td><td>'+esc(tot)+' — '+esc(cfg.iUsed||'used')+': '+esc(usd)+'</td></tr>');
    }

    let aiPerArt = null;
    if (details.caps && Number.isFinite(details.caps.ai_images_per_article)) aiPerArt = details.caps.ai_images_per_article;
    if (aiPerArt != null) {
      rows.push('<tr><td><strong>'+esc(cfg.iAiImages||'')+'</strong></td><td>'+esc(aiPerArt)+'</td></tr>');
    }

    if (!rows.length) {
      return cfg.noLicenseHTML || '';
    }

    return rows.join('');
  }

  async function doValidate(){
    if (busy) return;
    setBusy(true);

    const data = new URLSearchParams();
    data.append('action', 'urlifywritervalidate_license');
    data.append('nonce', cfg.nonce || '');
    data.append('key', $input.value.trim());

    try {
      const r = await fetch(ajaxurl, {
        method: 'POST',
        headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'},
        body: data.toString()
      });
      const res = await r.json();

      if (res && res.success && res.data) {
        const state = res.data.state || 'unknown';
        const details = res.data.details || null;

        setState(state, details);

        if (state === 'valid' && details) {
          $tbody.innerHTML = buildDetailsHTML(details);
        } else {
          $tbody.innerHTML = cfg.noLicenseHTML || '';
        }
      } else {
        setState('unknown');
        $tbody.innerHTML = cfg.noLicenseHTML || '';
      }
    } catch (e) {
      setState('unknown');
      $tbody.innerHTML = cfg.noLicenseHTML || '';
    } finally {
      setBusy(false);
    }
  }

  const toggle = () => { if (!busy) { $btn.disabled = !$input.value.trim(); } };
  $input.addEventListener('input', toggle);
  toggle();

  $btn.addEventListener('click', doValidate);

  // Autovalidar al entrar si hay clave
  if ($input.value.trim()) {
    doValidate();
  }
})();
