<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

add_action( 'admin_enqueue_scripts', 'urlifywriter_enqueue_connections_assets' );

function urlifywriter_enqueue_connections_assets( $hook_suffix ) {

	// Ajusta si es submenu
	if (
		$hook_suffix !== 'toplevel_page_urlifywriter-connections' &&
		$hook_suffix !== 'urlifywriter_page_urlifywriter-connections'
	) {
		return;
	}

	$ver = defined( 'URLIFYWRITER_VERSION' ) ? URLIFYWRITER_VERSION : '1.0.0';
	$base = plugin_dir_url( dirname( __FILE__ ) );

	wp_enqueue_style(
		'urlifywriter-admin-connections',
		$base . 'css/admin-connections.css',
		array(),
		$ver
	);

	wp_enqueue_script(
		'urlifywriter-admin-connections',
		$base . 'js/admin-connections.js',
		array(),
		$ver,
		true
	);

	wp_localize_script(
		'urlifywriter-admin-connections',
		'urlifywriterConnectionsL10n',
		array(
			'show'    => __( 'Show', 'urlifywriter' ),
			'hide'    => __( 'Hide', 'urlifywriter' ),
			'testing' => __( 'Testing…', 'urlifywriter' ),
			'ok'      => __( 'OK', 'urlifywriter' ),
		)
	);
}

add_action( 'admin_enqueue_scripts', 'urlifywriter_admin_enqueue_license_assets' );

function urlifywriter_admin_enqueue_license_assets( $hook_suffix ) {

	// ✅ Forma robusta: filtrar por screen id
	$screen = function_exists( 'get_current_screen' ) ? get_current_screen() : null;
	$screen_id = $screen ? (string) $screen->id : '';

	// Ajusta este filtro a tu caso real (cuando veas el screen id en debug.log)
	// Consejo: temporalmente puedes hacer: error_log('URLIFYWRITER screen id: '.$screen_id);
	if ( strpos( $screen_id, 'urlifywriter' ) === false || strpos( $screen_id, 'license' ) === false ) {
		return;
	}

	$ver = defined( 'URLIFYWRITER_VERSION' ) ? URLIFYWRITER_VERSION : '1.0.0';

	wp_register_style(
		'urlifywriter-admin-license',
		plugin_dir_url( dirname( __FILE__ ) ) . 'css/admin-license.css',
		array(),
		$ver
	);
	wp_enqueue_style( 'urlifywriter-admin-license' );

	wp_register_script(
		'urlifywriter-admin-license',
		plugin_dir_url( dirname( __FILE__ ) ) . 'js/admin-license.js',
		array(),
		$ver,
		true
	);
	wp_enqueue_script( 'urlifywriter-admin-license' );

	$pricing_url = defined( 'URLIFYWRITER_PRICING_URL' ) ? URLIFYWRITER_PRICING_URL : 'https://autopressai.com/pricing/';
	$terms_url   = defined( 'URLIFYWRITER_TERMS_URL' )   ? URLIFYWRITER_TERMS_URL   : 'https://autopressai.com/terms/';

    $no_license_html =
    	'<tr><td colspan="2">' .
    		'<p class="description" style="margin:8px 0;">' .
    			esc_html__(
    				'A valid UrlifyWriter license key is required to connect to the external service.',
    				'urlifywriter'
    			) .
    		'</p>' .
    		'<p style="margin:8px 0;">' .
    			'<a href="' . esc_url( $terms_url ) . '" target="_blank" rel="noopener noreferrer" class="button">' .
    				esc_html__( 'Terms & Conditions', 'urlifywriter' ) .
    			'</a>' .
    		'</p>' .
    	'</td></tr>';

	wp_localize_script(
		'urlifywriter-admin-license',
		'urlifywriterLicense',
		array(
			'ajaxUrl'         => admin_url( 'admin-ajax.php' ),
			'nonce'           => wp_create_nonce( 'urlifywritervalidate_license' ),
			'validateLabel'   => __( 'Validate', 'urlifywriter' ),
			'validatingLabel' => __( 'Validating…', 'urlifywriter' ),
			'noLicenseHTML'   => $no_license_html,

			'iIssuedAt'       => __( 'Issued At', 'urlifywriter' ),
			'iValidUntil'     => __( 'Valid Until', 'urlifywriter' ),
			'iArticlesMonth'  => __( 'Articles per month — used', 'urlifywriter' ),
			'iUsed'           => __( 'used', 'urlifywriter' ),
			'iAiImages'       => __( 'AI images per article', 'urlifywriter' ),
			'iNoDetailsYet'   => __( 'No license details yet. Click “Validate”.', 'urlifywriter' ),
		)
	);
}

add_action( 'admin_enqueue_scripts', 'urlifywriter_admin_enqueue_settings_assets' );

function urlifywriter_admin_enqueue_settings_assets( $hook_suffix ) {

	$screen = function_exists( 'get_current_screen' ) ? get_current_screen() : null;
	$screen_id = $screen ? (string) $screen->id : '';

	// Ajusta al screen real si hace falta (pero normalmente incluye "urlifywriter" y "settings")
	if ( strpos( $screen_id, 'urlifywriter' ) === false || strpos( $screen_id, 'settings' ) === false ) {
		return;
	}

	$ver = defined( 'URLIFYWRITER_VERSION' ) ? URLIFYWRITER_VERSION : '1.0.0';

	wp_enqueue_style(
		'urlifywriter-admin-settings',
		plugin_dir_url( dirname( __FILE__ ) ) . 'css/admin-settings.css',
		array(),
		$ver
	);

	wp_enqueue_script(
		'urlifywriter-admin-settings',
		plugin_dir_url( dirname( __FILE__ ) ) . 'js/admin-settings.js',
		array(),
		$ver,
		true
	);
}

add_action( 'admin_enqueue_scripts', 'urlifywriter_admin_enqueue_autoscan_assets' );

function urlifywriter_admin_enqueue_autoscan_assets() {

	$screen = function_exists( 'get_current_screen' ) ? get_current_screen() : null;
	$screen_id = $screen ? (string) $screen->id : '';

	// Ajusta este check a tu screen id real.
	if ( strpos( $screen_id, 'urlifywriter' ) === false || strpos( $screen_id, 'autoscan' ) === false ) {
		return;
	}

	$ver = defined( 'URLIFYWRITER_VERSION' ) ? URLIFYWRITER_VERSION : '1.0.0';

	wp_enqueue_style(
		'urlifywriter-admin-autoscan',
		plugin_dir_url( dirname( __FILE__ ) ) . 'css/admin-autoscan.css',
		array(),
		$ver
	);

	wp_enqueue_script(
		'urlifywriter-admin-autoscan',
		plugin_dir_url( dirname( __FILE__ ) ) . 'js/admin-autoscan.js',
		array(),
		$ver,
		true
	);

	wp_localize_script(
		'urlifywriter-admin-autoscan',
		'URLIFYWRITER_AUTOSCAN',
		array(
			'ajaxUrl' => admin_url( 'admin-ajax.php' ),
			'nonce'   => wp_create_nonce( 'urlifywriterautoscan' ),

			'i18n' => array(
				'loading'        => __( 'Loading…', 'urlifywriter' ),
				'starting'       => __( 'Starting…', 'urlifywriter' ),
				'stopping'       => __( 'Stopping…', 'urlifywriter' ),
				'running'        => __( 'Running…', 'urlifywriter' ),
				'scanning'       => __( 'Scanning…', 'urlifywriter' ),
				'cronScheduled'  => __( 'Cron scheduled.', 'urlifywriter' ),
				'cronStopped'    => __( 'Cron stopped.', 'urlifywriter' ),
				'sourceSaved'    => __( 'Source saved.', 'urlifywriter' ),

				'confirmStopScan' => __( 'Stop the AutoScan cron?', 'urlifywriter' ),
				'confirmStopGen'  => __( 'Stop the AutoGen cron?', 'urlifywriter' ),
				'confirmDelete'   => __( 'Delete this source?', 'urlifywriter' ),
				'confirmRetryAll' => __( 'Retry all failed items?', 'urlifywriter' ),

				'yes' => __( 'Yes', 'urlifywriter' ),
				'no'  => __( 'No', 'urlifywriter' ),

				'edit'    => __( 'Edit', 'urlifywriter' ),
				'enable'  => __( 'Enable', 'urlifywriter' ),
				'disable' => __( 'Disable', 'urlifywriter' ),
				'scanNow' => __( 'Scan now', 'urlifywriter' ),
				'delete'  => __( 'Delete', 'urlifywriter' ),
			),
		)
	);
}

add_action( 'admin_enqueue_scripts', 'urlifywriter_admin_enqueue_create_from_url_assets' );

function urlifywriter_admin_enqueue_create_from_url_assets( $hook_suffix ) {

	// ✅ Ajusta estos dos valores al hook real de tu página.
	// Normalmente será algo como:
	// "urlifywriter_page_urlifywriter-create-from-url"
	// Si fuese top-level, podría ser:
	// "toplevel_page_urlifywriter-create-from-url"
	if (
		$hook_suffix !== 'urlifywriter_page_urlifywriter-url' &&
		$hook_suffix !== 'toplevel_page_urlifywriter-create-from-url'
	) {
		return;
	}

	$ver  = defined( 'URLIFYWRITER_VERSION' ) ? URLIFYWRITER_VERSION : '1.0.0';
	$base = plugin_dir_url( dirname( __FILE__ ) ); // ✅ raíz del plugin (igual que Connections)

	// CSS
	wp_enqueue_style(
		'urlifywriter-admin-create-from-url',
		$base . 'css/admin-create-from-url.css',
		array(),
		$ver
	);

	// JS
	wp_enqueue_script(
		'urlifywriter-admin-create-from-url',
		$base . 'js/admin-create-from-url.js',
		array( 'jquery' ),
		$ver,
		true
	);

	// Recalcula defaults (igual que ya hacías)
	$target_min_default = (int) get_option( 'urlifywritertarget_min_words', 800 );
	$target_max_default = (int) get_option( 'urlifywritertarget_max_words', 1200 );

	$def_images_enabled     = (int) get_option( 'urlifywriterimages_enabled', 0 );
	$def_image_source       = (string) get_option( 'urlifywriterimage_source', 'pixabay' );
	$def_image_original_ack = (int) get_option( 'urlifywriterimage_original_ack', 0 );
	$def_pixabay_n          = (int) get_option( 'urlifywriterpixabay_images_per_article', 1 );
	$def_ai_n               = (int) get_option( 'urlifywriterai_images_per_article', 0 );
	$def_image_insert       = (string) get_option( 'urlifywriterimage_insert', 'both' );
	$def_ai_style_hint      = (string) get_option( 'urlifywriterai_style_hint', '' );

	$pixabay_has_key = function_exists( 'urlifywriterhas_pixabay_user_key' )
		? (bool) urlifywriterhas_pixabay_user_key()
		: (bool) get_option( 'urlifywriterapi_pixabay_key' );

	$ai_has_key = function_exists( 'urlifywriterhas_ai_user_key' )
		? (bool) urlifywriterhas_ai_user_key()
		: (bool) ( get_option( 'urlifywriterapi_openai_key' ) || get_option( 'urlifywriterapi_gemini_key' ) );

	$lic = function_exists( 'urlifywriterlicense_ai_limits' )
		? (array) urlifywriterlicense_ai_limits()
		: array(
			'included'        => false,
			'max_per_article' => 0,
			'monthly_cap'     => 0,
		);

	$pixabay_max = $pixabay_has_key ? 5 : 1;
	$ai_max      = ! empty( $lic['included'] ) ? max( 1, (int) $lic['max_per_article'] ) : ( $ai_has_key ? 4 : 0 );

	$prefer_user_api = ( $pixabay_has_key || $ai_has_key ) ? 1 : 0;

	$can_edit_posts = current_user_can( 'edit_posts' );
	$can_edit_pages = current_user_can( 'edit_pages' );
	$def_post_type  = 'post';

	$remote_timeout = (int) ( defined( 'URLIFYWRITER_REMOTE_TIMEOUT' ) ? URLIFYWRITER_REMOTE_TIMEOUT : 45 );

	// Localize (IMPORTANTE: usar el MISMO handle que en wp_enqueue_script)
	wp_localize_script(
		'urlifywriter-admin-create-from-url',
		'urlifywriterCreateFromUrl',
		array(
			'ajaxurl'        => admin_url( 'admin-ajax.php' ),
			'ajax_nonce'     => wp_create_nonce( 'urlifywriterurl_flow' ),
			'preferUserApi'  => (int) $prefer_user_api,
			'licensePageUrl' => admin_url( 'admin.php?page=urlifywriter-license' ),
			'remoteTimeout'  => $remote_timeout,

			'defaults' => array(
				'target_min'          => $target_min_default,
				'target_max'          => $target_max_default,

				'images_enabled'      => (int) $def_images_enabled,
				'image_source'        => (string) $def_image_source,
				'image_original_ack'  => (int) $def_image_original_ack,
				'pixabay_n'           => (int) $def_pixabay_n,
				'ai_n'                => (int) $def_ai_n,
				'image_insert'        => (string) $def_image_insert,
				'ai_style_hint'       => (string) $def_ai_style_hint,

				'pixabay_max'         => (int) $pixabay_max,
				'ai_max'              => (int) $ai_max,
				'license_includes_ai' => (bool) ( $lic['included'] ?? false ),
				'license_ai_per_art'  => (int) ( $lic['max_per_article'] ?? 0 ),

				'post_type_default'   => $def_post_type,
				'can_edit_pages'      => (bool) $can_edit_pages,
				'can_edit_posts'      => (bool) $can_edit_posts,
			),

			'i18n' => array(
				'urls_single'        => __( 'URL', 'urlifywriter' ),
				'urls_batch'         => __( 'URLs (1 per line)', 'urlifywriter' ),
				'kw_single'          => __( 'Keyword / Topic', 'urlifywriter' ),
				'kw_batch'           => __( 'Keywords / Topics (1 per line)', 'urlifywriter' ),

				'instr_opt_single'   => __( 'Instructions (optional)', 'urlifywriter' ),
				'instr_opt_1perline' => __( 'Instructions (optional, 1 per line)', 'urlifywriter' ),
				'instr_req_single'   => __( 'Instructions', 'urlifywriter' ),
				'instr_req_1perline' => __( 'Instructions (1 per line)', 'urlifywriter' ),

				'help_url_single'    => __( 'URL (single): instructions are optional for extra guidance.', 'urlifywriter' ),
				'help_url_batch'     => __( 'Batch (URL): instructions are optional. If you write them and “Apply to all” is off, provide the same number as URLs (1:1).', 'urlifywriter' ),
				'help_kw_single'     => __( 'Keyword (single): instructions are required (1 per line).', 'urlifywriter' ),
				'help_kw_batch'      => __( 'Batch (Keyword): instructions are required. If “Apply to all” is off, provide one per item (1:1).', 'urlifywriter' ),

				'provide_url'        => __( 'Please provide at least one URL.', 'urlifywriter' ),
				'provide_kw'         => __( 'Please provide at least one keyword/topic.', 'urlifywriter' ),
				'invalid_url'        => __( 'Invalid URL format:', 'urlifywriter' ),
				'instr_required_kw'  => __( 'Instructions are required in keyword mode (1 per line).', 'urlifywriter' ),
				'instr_1to1'         => __( 'In Batch with 1:1 mapping, the number of instruction lines must match the number of items.', 'urlifywriter' ),
				'multi_detected'     => __( 'Multiple items detected. Switched to Batch automatically.', 'urlifywriter' ),

				'processing'         => __( 'Processing…', 'urlifywriter' ),
				'done'               => __( 'Done', 'urlifywriter' ),
				'completed'          => __( 'Completed', 'urlifywriter' ),
				'error'              => __( 'Error', 'urlifywriter' ),

				'work'               => __( 'Working…', 'urlifywriter' ),
				'create'             => __( 'Create', 'urlifywriter' ),
				'edit_draft'         => __( 'Edit', 'urlifywriter' ),
				'view_draft'         => __( 'View', 'urlifywriter' ),

				'origin_ack_needed'  => __( '⚠️ You must acknowledge the copyright disclaimer before using the original image.', 'urlifywriter' ),

				'license_invalid'    => __( 'License is not valid. Go to', 'urlifywriter' ),
				'license_menu'       => __( 'UrlifyWriter → License', 'urlifywriter' ),
				'license_check'      => __( 'and check your key.', 'urlifywriter' ),

                'remote_timeout_msg' => sprintf(
                	/* translators: %1$d is the timeout in seconds. */
                	__( 'The remote generation exceeded the timeout (%1$d seconds). Try again or increase the timeout.', 'urlifywriter' ),
                	$remote_timeout
                ),
			),
		)
	);
}
