<?php
if ( ! defined('ABSPATH') ) exit;

/**
 * Support page
 */
function urlifywriter_render_support_page() {
	if ( ! current_user_can('manage_options') ) {
		wp_die( esc_html__('You do not have sufficient permissions to access this page.', 'urlifywriter') );
	}
	?>
	<div class="wrap uw-page">

		<div class="uw-hero">
			<h1><?php echo esc_html__('Support', 'urlifywriter'); ?></h1>
			<p><?php echo esc_html__('Need help with UrlifyWriter? Send us a message and we’ll get back to you.', 'urlifywriter'); ?></p>
		</div>

		<?php
		if ( isset($_GET['sent']) ) {
			$status = sanitize_text_field( wp_unslash($_GET['sent']) );
			if ( $status === 'success' ) {
				echo '<div class="notice notice-success is-dismissible"><p>' .
					esc_html__('Your message has been sent successfully.', 'urlifywriter') .
				'</p></div>';
			} elseif ( $status === 'error' ) {
				echo '<div class="notice notice-error is-dismissible"><p>' .
					esc_html__('There was a problem sending your message. Please try again.', 'urlifywriter') .
				'</p></div>';
			}
		}
		?>

		<div class="uw-content">

			<h2 style="margin-top:0;"><?php echo esc_html__('Contact Form', 'urlifywriter'); ?></h2>

			<form class="uw-form" method="post" action="<?php echo esc_url( admin_url('admin-post.php') ); ?>">
				<input type="hidden" name="action" value="urlifywriter_submit_support_form">
				<?php wp_nonce_field('urlifywriter_submit_support_form', 'urlifywriter_support_nonce'); ?>

				<div class="uw-row">
					<p>
						<label for="urlifywriter_name"><?php echo esc_html__('Name', 'urlifywriter'); ?></label>
						<input type="text" id="urlifywriter_name" name="name" required>
					</p>

					<p>
						<label for="urlifywriter_email"><?php echo esc_html__('Email', 'urlifywriter'); ?></label>
						<input type="email" id="urlifywriter_email" name="email" required>
					</p>
				</div>

				<p>
					<label for="urlifywriter_message"><?php echo esc_html__('Message', 'urlifywriter'); ?></label>
					<textarea id="urlifywriter_message" name="message" rows="6" required></textarea>
				</p>

				<div class="uw-actions">
					<button type="submit" class="button button-primary">
						<?php echo esc_html__('Send Message', 'urlifywriter'); ?>
					</button>
					<span class="uw-badge">
						<?php echo esc_html__('Emails go to', 'urlifywriter'); ?> contact@urlifywriter.com
					</span>
				</div>
			</form>

			<div class="uw-block" style="margin-top:16px;">
				<p class="uw-muted" style="margin:0;">
					<?php echo esc_html__('You can also contact us directly at', 'urlifywriter'); ?>
					<a href="mailto:contact@urlifywriter.com">contact@urlifywriter.com</a>.
				</p>
			</div>

		</div>
	</div>
	<?php
}

/**
 * Handle support form submission
 */
function urlifywriter_handle_submit_support_form() {
	if (
		! isset($_POST['urlifywriter_support_nonce']) ||
		! wp_verify_nonce(
			sanitize_text_field( wp_unslash($_POST['urlifywriter_support_nonce']) ),
			'urlifywriter_submit_support_form'
		)
	) {
		wp_die( esc_html__('Security check failed.', 'urlifywriter') );
	}

	$name    = sanitize_text_field( wp_unslash($_POST['name'] ?? '') );
	$email   = sanitize_email( wp_unslash($_POST['email'] ?? '') );
	$message = sanitize_textarea_field( wp_unslash($_POST['message'] ?? '') );

	if ( empty($name) || empty($email) || empty($message) ) {
		wp_safe_redirect( add_query_arg('sent', 'error', admin_url('admin.php?page=urlifywriter-support')) );
		exit;
	}

	$to      = 'contact@urlifywriter.com';
	$subject = '[UrlifyWriter] New Support Request';

	$headers = [
		'Content-Type: text/html; charset=UTF-8',
		'Reply-To: ' . $email,
	];

	$body  = '<h2>New Support Request</h2>';
	$body .= '<p><strong>Name:</strong> ' . esc_html($name) . '</p>';
	$body .= '<p><strong>Email:</strong> ' . esc_html($email) . '</p>';
	$body .= '<p><strong>Message:</strong><br>' . nl2br( esc_html($message) ) . '</p>';

	$sent = wp_mail($to, $subject, $body, $headers);

	wp_safe_redirect(
		add_query_arg('sent', $sent ? 'success' : 'error', admin_url('admin.php?page=urlifywriter-support'))
	);
	exit;
}
add_action('admin_post_urlifywriter_submit_support_form', 'urlifywriter_handle_submit_support_form');

