<?php
if ( ! defined('ABSPATH') ) exit;

function urlifywriter_render_how_to_use_page() {
	if ( ! current_user_can('manage_options') ) {
		wp_die( esc_html__('You do not have sufficient permissions to access this page.', 'urlifywriter') );
	}
	?>
	<div class="wrap uw-page">

		<div class="uw-hero">
			<h1><?php echo esc_html__('How to Use UrlifyWriter', 'urlifywriter'); ?></h1>
			<p><?php echo esc_html__('Learn how to activate, configure, create articles, and use Auto Scan.', 'urlifywriter'); ?></p>
		</div>

		<div class="uw-grid">

			<nav class="uw-nav">
				<a href="#uw-tab-activation" class="active">Activation</a>
				<a href="#uw-tab-configuration">Configuration</a>
				<a href="#uw-tab-create">Create an Article</a>
				<a href="#uw-tab-autoscan">Auto Scan</a>
			</nav>

			<div class="uw-content">

				<div id="uw-tab-activation" class="uw-tab active">
					<h2>Activation</h2>
					<div class="uw-block">
						<ol>
							<li><?php echo esc_html__('Install and activate the plugin.', 'urlifywriter'); ?></li>
							<li>
								<?php echo esc_html__('Go to', 'urlifywriter'); ?>
								<span class="uw-kbd">UrlifyWriter → License</span>
								<?php echo esc_html__('and validate your license key.', 'urlifywriter'); ?>
							</li>
							<li>
								<?php echo esc_html__('Want more images?', 'urlifywriter'); ?>
								<?php echo esc_html__('Connect your own APIs in', 'urlifywriter'); ?>
								<span class="uw-kbd">Connections (APIs)</span>
								<?php echo esc_html__('to increase limits or generate AI images regardless of your plan.', 'urlifywriter'); ?>
							</li>

						</ol>
					</div>
				</div>

				<div id="uw-tab-configuration" class="uw-tab" style="display:none;">
					<h2><?php echo esc_html__('Configuration', 'urlifywriter'); ?></h2>

					<div class="uw-block">
						<ol>
							<li>
								<?php echo esc_html__('Set extraction limits and target article length (min / max).', 'urlifywriter'); ?>
							</li>

							<li>
								<?php echo esc_html__('Choose the default article language and (optionally) the default author.', 'urlifywriter'); ?>
							</li>

							<li>
								<?php echo esc_html__('Enable or disable automatic image insertion for generated articles.', 'urlifywriter'); ?>
							</li>

							<li>
								<?php echo esc_html__('Select the image source, images per article, and default image placement (featured / inline).', 'urlifywriter'); ?>
							</li>
						</ol>

						<p class="uw-muted" style="margin-bottom:0;">
							<?php echo esc_html__('These defaults are applied automatically unless you override them when generating an article.', 'urlifywriter'); ?>
						</p>
					</div>
				</div>



				<div id="uw-tab-create" class="uw-tab" style="display:none;">
					<h2><?php echo esc_html__('Create an Article', 'urlifywriter'); ?></h2>

					<div class="uw-block">
						<ol>
							<li>
								<?php echo esc_html__('Choose the mode: generate content from a URL or from keywords.', 'urlifywriter'); ?>
							</li>

							<li>
								<?php echo esc_html__('Select the type: create a single article or generate articles in batch.', 'urlifywriter'); ?>
							</li>

							<li>
								<?php echo esc_html__('Choose the post type: Post or Page.', 'urlifywriter'); ?>
							</li>

							<li>
								<?php echo esc_html__('Depending on the selected mode: paste a source URL (From URL) or enter keywords (From Keyword).', 'urlifywriter'); ?>
							</li>
							
							<li>
								<?php echo esc_html__('Optionally add extra instructions to guide the AI output.', 'urlifywriter'); ?>
							</li>
							
							<li>
								<?php echo esc_html__('Set the target minimum and maximum word count.', 'urlifywriter'); ?>
							</li>
							
							<li>
								<?php echo esc_html__('Decide whether to include images using the current Settings configuration.', 'urlifywriter'); ?>
							</li>

							<li>
								<?php echo esc_html__('Choose the publication status (Draft, Scheduled, or Publish).', 'urlifywriter'); ?>
							</li>
						</ol>

						<p class="uw-muted" style="margin-bottom:0;">
							<span class="uw-badge">Tip</span>
							<?php echo esc_html__('When testing the plugin, start with Draft mode to review the output before publishing.', 'urlifywriter'); ?>
						</p>
					</div>
				</div>

				<div id="uw-tab-autoscan" class="uw-tab" style="display:none;">
					<h2><?php echo esc_html__('Auto Scan', 'urlifywriter'); ?></h2>

					<div class="uw-block">
						<ol>
							<li>
								<?php echo esc_html__(
									'Go to UrlifyWriter → Auto Scan to manage automatic content discovery.',
									'urlifywriter'
								); ?>
							</li>

							<li>
								<?php echo esc_html__(
									'Add a new source by providing a domain and a start URL. The start URL is the page that will be periodically scanned for new links.',
									'urlifywriter'
								); ?>
							</li>

							<li>
								<?php echo esc_html__(
									'The plugin does not crawl the entire domain. It only checks the start URL, which is typically a homepage, category page, or article listing that updates over time.',
									'urlifywriter'
								); ?>
							</li>

							<li>
								<?php echo esc_html__(
									'Configure how often the start URL should be scanned (interval) and set a maximum number of articles per day for that source.',
									'urlifywriter'
								); ?>
							</li>

							<li>
								<?php echo esc_html__(
									'Optionally add generation instructions to define editorial style, voice, or SEO preferences for articles created from this source.',
									'urlifywriter'
								); ?>
							</li>

							<li>
								<?php echo esc_html__(
									'Save the source to activate it. UrlifyWriter will start tracking new URLs on the start page when the next cron job runs.',
									'urlifywriter'
								); ?>
							</li>

							<li>
								<?php echo esc_html__(
									'This may take a few minutes depending on the cron schedule, but you can use “Scan now” to trigger an immediate check.',
									'urlifywriter'
								); ?>
							</li>

							<li>
								<?php echo esc_html__(
									'You can enable, disable, or edit sources at any time, and manually scan individual sources if needed.',
									'urlifywriter'
								); ?>
							</li>

							<li>
								<?php echo esc_html__(
									'Global controls allow you to start, stop, or run Auto Scan and AutoGen immediately, as well as adjust the global scan interval.',
									'urlifywriter'
								); ?>
							</li>

							<li>
								<?php echo esc_html__(
									'Auto Scan discovers new URLs (subject to the per-source daily limit). AutoGen then converts detected items into posts based on your batch settings.',
									'urlifywriter'
								); ?>
							</li>
						</ol>

						<p class="uw-muted" style="margin-bottom:0;">
							<span class="uw-badge">Tip</span>
							<?php echo esc_html__(
								'Use a frequently updated start URL (such as a news homepage) and begin with conservative daily limits while testing.',
								'urlifywriter'
							); ?>
						</p>
						<p class="uw-muted" style="margin-top:10px;">
							<span class="uw-badge">Important</span>
							<?php echo esc_html__(
								'Avoid very short scan intervals or high daily limits on third-party websites. Excessive requests may trigger rate limits or temporary blocks by the source site.',
								'urlifywriter'
							); ?>
						</p>
					</div>
				</div>

			</div>
		</div>
	</div>
	<?php
}

/**
 * Tabs JS (solo en esta página)
 */
add_action('admin_enqueue_scripts', function ($hook) {
	if ( ! is_string($hook) || strpos($hook, 'urlifywriter-how-to-use') === false ) {
		return;
	}

	wp_add_inline_script('jquery-core', "
		jQuery(function($){
			$('.uw-nav a').on('click', function(e){
				e.preventDefault();
				var target = $(this).attr('href');

				$('.uw-nav a').removeClass('active');
				$(this).addClass('active');

				$('.uw-tab').hide().removeClass('active');
				$(target).show().addClass('active');
			});
		});
	");
});