<?php
// admin/page-create-from-url.php
if ( ! defined( 'ABSPATH' ) ) { exit; }

function urlifywriterrender_create_from_url_page() {
	if ( ! current_user_can( 'edit_posts' ) ) {
		wp_die( esc_html__( 'You do not have sufficient permissions to access this page.', 'urlifywriter' ) );
	}

	// ==== Defaults from Settings ====
	$target_min_default = (int) get_option( 'urlifywritertarget_min_words', 800 );
	$target_max_default = (int) get_option( 'urlifywritertarget_max_words', 1200 );
	$target_min         = $target_min_default;
	$target_max         = $target_max_default;

	// Images defaults
	$def_images_enabled     = (int) get_option( 'urlifywriterimages_enabled', 0 );
	$def_image_source       = (string) get_option( 'urlifywriterimage_source', 'pixabay' ); // original|pixabay|ai
	$def_image_original_ack = (int) get_option( 'urlifywriterimage_original_ack', 0 );
	$def_pixabay_n          = (int) get_option( 'urlifywriterpixabay_images_per_article', 1 );
	$def_ai_n               = (int) get_option( 'urlifywriterai_images_per_article', 0 );
	$def_image_insert       = (string) get_option( 'urlifywriterimage_insert', 'both' ); // featured|inline|both
	$def_ai_style_hint      = (string) get_option( 'urlifywriterai_style_hint', '' );

	// Capabilities/helpers (estas deberían existir fuera, no aquí)
	$pixabay_has_key = function_exists( 'urlifywriterhas_pixabay_user_key' ) ? (bool) urlifywriterhas_pixabay_user_key() : (bool) get_option( 'urlifywriterapi_pixabay_key' );
	$ai_has_key      = function_exists( 'urlifywriterhas_ai_user_key' ) ? (bool) urlifywriterhas_ai_user_key() : (bool) ( get_option( 'urlifywriterapi_openai_key' )  );
	$lic             = function_exists( 'urlifywriterlicense_ai_limits' ) ? (array) urlifywriterlicense_ai_limits() : array(
		'included'        => false,
		'max_per_article' => 0,
		'monthly_cap'     => 0,
	);

	$pixabay_max = $pixabay_has_key ? 5 : 1;
	$ai_max      = ! empty( $lic['included'] ) ? max( 1, (int) $lic['max_per_article'] ) : ( $ai_has_key ? 4 : 0 );

	// Prefer user API?
	$prefer_user_api = ( $pixabay_has_key || $ai_has_key ) ? 1 : 0;

	// ==== Post type & capabilities ====
	$can_edit_posts = current_user_can( 'edit_posts' );
	$can_edit_pages = current_user_can( 'edit_pages' );
	$def_post_type  = 'post';

	$remote_timeout = (int) ( defined( 'URLIFYWRITER_REMOTE_TIMEOUT' ) ? URLIFYWRITER_REMOTE_TIMEOUT : 45 );

	// Steps
	$steps = array(
		array( 'key' => 'validate', 'label' => __( 'Validating input…', 'urlifywriter' ), 'status' => 'pend', 'note' => '' ),
		array( 'key' => 'extract',  'label' => __( 'Extracting article…', 'urlifywriter' ), 'status' => 'pend', 'note' => __( 'Downloading HTML and parsing main content…', 'urlifywriter' ) ),
		array( 'key' => 'create',   'label' => __( 'Creating AI article…', 'urlifywriter' ), 'status' => 'pend', 'note' => '' ),
		array( 'key' => 'images',   'label' => __( 'Generating images…', 'urlifywriter' ), 'status' => 'pend', 'note' => '' ),
		array( 'key' => 'draft',    'label' => __( 'Saving…', 'urlifywriter' ), 'status' => 'pend', 'note' => '' ),
	);
	?>
	<div class="wrap urlifywriter-wrap">
		<div class="urlifywriter-hero">
			<div>
				<h1 class="urlifywriter-title"><?php echo esc_html__( 'Create Posts / Pages (URL or Keyword)', 'urlifywriter' ); ?></h1>
			</div>
			<span class="urlifywriter-badge">UrlifyWriter</span>
		</div>

		<div id="urlifywriter-notices-by-step"></div>

		<div class="urlifywriter-card">
			<h2><?php echo esc_html__( 'Mode & Type', 'urlifywriter' ); ?></h2>

			<div class="urlifywriter-form-grid urlifywriter-three-cols">
				<fieldset class="urlifywriter-form-row">
					<label class="urlifywriter-label"><?php echo esc_html__( 'Mode', 'urlifywriter' ); ?></label>
					<label><input type="radio" name="urlifywritersource_mode" value="url" checked> <?php echo esc_html__( 'From URL', 'urlifywriter' ); ?></label>
					<label class="urlifywriter-ml-16"><input type="radio" name="urlifywritersource_mode" value="keyword"> <?php echo esc_html__( 'From Keyword', 'urlifywriter' ); ?></label>
				</fieldset>

				<fieldset class="urlifywriter-form-row">
					<label class="urlifywriter-label"><?php echo esc_html__( 'Type', 'urlifywriter' ); ?></label>
					<label><input type="radio" name="urlifywriterbatch_type" value="single" checked> <?php echo esc_html__( 'Single', 'urlifywriter' ); ?></label>
					<label class="urlifywriter-ml-16"><input type="radio" name="urlifywriterbatch_type" value="batch"> <?php echo esc_html__( 'Batch', 'urlifywriter' ); ?></label>
				</fieldset>

				<fieldset class="urlifywriter-form-row">
					<label class="urlifywriter-label"><?php echo esc_html__( 'Post type', 'urlifywriter' ); ?></label>

					<label>
						<input type="radio" name="urlifywriterpost_type" value="post"
							<?php checked( $def_post_type, 'post' ); ?>
							<?php disabled( ! $can_edit_posts ); ?>>
						<?php echo esc_html__( 'Post', 'urlifywriter' ); ?>
					</label>

					<label class="urlifywriter-ml-16">
						<input type="radio" name="urlifywriterpost_type" value="page"
							<?php checked( $def_post_type, 'page' ); ?>
							<?php disabled( ! $can_edit_pages ); ?>>
						<?php echo esc_html__( 'Page', 'urlifywriter' ); ?>
					</label>

					<?php if ( ! $can_edit_pages ) : ?>
						<p class="description urlifywriter-mt-6">
							<?php echo esc_html__( 'You don’t have permission to create pages.', 'urlifywriter' ); ?>
						</p>
					<?php endif; ?>
				</fieldset>
			</div>
		</div>

		<div class="urlifywriter-card">
			<h2><?php echo esc_html__( 'Input', 'urlifywriter' ); ?></h2>

			<form method="post" class="urlifywriter-form" id="urlifywriter-form-url" autocomplete="off">
				<?php wp_nonce_field( 'urlifywriterurl_analyze', 'urlifywriternonce_render' ); ?>

				<div class="urlifywriter-form-row">
					<label for="urlifywriteritems" class="urlifywriter-label" id="urlifywriteritems_label"><?php echo esc_html__( 'URLs (1 per line)', 'urlifywriter' ); ?></label>
					<textarea id="urlifywriteritems" rows="5" class="urlifywriter-input" placeholder="<?php echo esc_attr__( 'e.g., https://example.com/article', 'urlifywriter' ); ?>"></textarea>
				</div>

				<div class="urlifywriter-form-row urlifywriter-mt-12">
					<div class="urlifywriter-row urlifywriter-between">
						<label for="urlifywriterinstructions_list" class="urlifywriter-label" id="urlifywriterinstr_label">
							<?php echo esc_html__( 'Instructions (optional, 1 per line)', 'urlifywriter' ); ?>
						</label>

						<span id="urlifywriterinstr_apply_all_wrap" style="display:none;">
							<label class="urlifywriter-normal">
								<input type="checkbox" id="urlifywriterinstr_apply_all">
								<?php echo esc_html__( 'Apply to all articles', 'urlifywriter' ); ?>
							</label>
						</span>
					</div>

					<textarea id="urlifywriterinstructions_list" rows="4" class="urlifywriter-input"
						placeholder="<?php echo esc_attr__( 'e.g., Write an article about polar bears, explaining their characteristics, habitat, and diet. The text should be informative and aimed at an adult audience', 'urlifywriter' ); ?>"></textarea>
				</div>

				<div class="urlifywriter-form-grid urlifywriter-two-cols urlifywriter-mt-14">
					<div>
						<label for="urlifywritertarget_min" class="urlifywriter-label"><?php echo esc_html__( 'Target min words', 'urlifywriter' ); ?></label>
						<input type="range" class="urlifywriter-input" id="urlifywritertarget_min" min="100" max="3000" step="50" value="<?php echo esc_attr( $target_min ); ?>">
						<div class="urlifywriter-range-meta">
							<span>100</span>
							<strong><span id="urlifywritertarget_min_val"><?php echo esc_html( $target_min ); ?></span></strong>
							<span>3000</span>
						</div>
						<p class="urlifywriter-help"><?php echo esc_html__( 'Target minimum words (max 3000).', 'urlifywriter' ); ?></p>
					</div>

					<div>
						<label for="urlifywritertarget_max" class="urlifywriter-label"><?php echo esc_html__( 'Target max words', 'urlifywriter' ); ?></label>
						<input type="range" class="urlifywriter-input" id="urlifywritertarget_max" min="200" max="3000" step="50" value="<?php echo esc_attr( $target_max ); ?>">
						<div class="urlifywriter-range-meta">
							<span>200</span>
							<strong><span id="urlifywritertarget_max_val"><?php echo esc_html( $target_max ); ?></span></strong>
							<span>3000</span>
						</div>
						<p class="urlifywriter-help"><?php echo esc_html__( 'Target maximum words (hard limit 3000).', 'urlifywriter' ); ?></p>
					</div>
				</div>

				<div class="urlifywriter-form-row urlifywriter-mt-18">
					<h3 class="urlifywriter-h3"><?php echo esc_html__( 'Images', 'urlifywriter' ); ?></h3>

					<label class="urlifywriter-block">
						<input type="checkbox" id="urlifywriterimages_enabled_run" value="1" <?php checked( $def_images_enabled, 1 ); ?>>
						<?php echo esc_html__( 'Include images (use current Settings by default)', 'urlifywriter' ); ?>
					</label>

					<button type="button" class="button" id="urlifywriter-images-advanced-toggle" aria-expanded="false" aria-controls="urlifywriter-images-advanced">
						<?php echo esc_html__( 'More image options', 'urlifywriter' ); ?>
					</button>

					<div id="urlifywriter-images-advanced" class="urlifywriter-card urlifywriter-images-advanced" style="display:none;">
						<p class="description urlifywriter-mt-0">
							<?php echo esc_html__( 'Override image source and per-article count just for this run.', 'urlifywriter' ); ?>
						</p>

						<fieldset id="urlifywriterimage_source_group_run">
							<label class="urlifywriter-radio">
								<input type="radio" name="urlifywriterimage_source_run" value="original" <?php checked( $def_image_source, 'original' ); ?>>
								<strong><?php echo esc_html__( 'From post URL (original image)', 'urlifywriter' ); ?></strong>
								<em class="urlifywriter-warn"><?php echo esc_html__( 'Use at your own risk (copyright).', 'urlifywriter' ); ?></em>
							</label>

							<div class="urlifywriter-subrow" data-for="original" style="<?php echo ( $def_image_source === 'original' ) ? '' : 'display:none;'; ?>">
								<label>
									<input type="checkbox" id="urlifywriterimage_original_ack_run" value="1" <?php checked( $def_image_original_ack, 1 ); ?>>
									<?php echo esc_html__( 'I understand this may infringe copyrights and accept responsibility.', 'urlifywriter' ); ?>
								</label>
							</div>

							<label class="urlifywriter-radio">
								<input type="radio" name="urlifywriterimage_source_run" value="pixabay" <?php checked( $def_image_source, 'pixabay' ); ?>>
								<strong><?php echo esc_html__( 'Pixabay', 'urlifywriter' ); ?></strong>
								<span class="urlifywriter-hint">
									<?php echo $pixabay_has_key ? esc_html__( 'Your API key is set: up to 5 images/article', 'urlifywriter' ) : esc_html__( 'No user API: limited to 1 image/article', 'urlifywriter' ); ?>
								</span>
							</label>

							<div class="urlifywriter-subrow" data-for="pixabay" style="<?php echo ( $def_image_source === 'pixabay' ) ? '' : 'display:none;'; ?>">
								<label>
									<?php echo esc_html__( 'Images per article:', 'urlifywriter' ); ?>
									<input type="number" min="1" max="<?php echo esc_attr( $pixabay_max ); ?>" step="1"
										id="urlifywriterpixabay_images_per_article_run"
										value="<?php echo esc_attr( max( 1, min( $pixabay_max, $def_pixabay_n ) ) ); ?>">
									<span class="description urlifywriter-ml-8">
										<?php echo $pixabay_has_key ? esc_html__( 'Up to 5 with your Pixabay API key.', 'urlifywriter' ) : esc_html__( 'Limited to 1 without your own Pixabay API key.', 'urlifywriter' ); ?>
									</span>
								</label>
							</div>

							<label class="urlifywriter-radio">
								<input type="radio" name="urlifywriterimage_source_run" value="ai" <?php checked( $def_image_source, 'ai' ); ?>>
								<strong><?php echo esc_html__( 'AI', 'urlifywriter' ); ?></strong>
								<span class="urlifywriter-hint">
									<?php
									if ( ! empty( $lic['included'] ) ) {
										printf(
											/* translators: %d is the maximum number of AI images included per article by the license. */
											esc_html__( 'License includes AI images: up to %d per article', 'urlifywriter' ),
											(int) $lic['max_per_article']
										);
									} elseif ( $ai_has_key ) {
										echo esc_html__( 'User API present. You can generate AI images (1–4 per article).', 'urlifywriter' );
									} else {
										echo esc_html__( 'Not available: add your API in Connections or upgrade your plan.', 'urlifywriter' );
									}
									?>
								</span>
							</label>

							<?php
							$ai_min = ( $ai_max === 0 ) ? 0 : 1;
							$ai_val = ( $ai_max === 0 ) ? 0 : max( 1, min( $ai_max, ( $def_ai_n ?: 1 ) ) );
							?>
							<div class="urlifywriter-subrow" data-for="ai" style="<?php echo ( $def_image_source === 'ai' ) ? '' : 'display:none;'; ?>">
								<label>
									<?php echo esc_html__( 'Images per article:', 'urlifywriter' ); ?>
									<input type="number" min="<?php echo esc_attr( $ai_min ); ?>" max="<?php echo esc_attr( $ai_max ); ?>" step="1"
										id="urlifywriterai_images_per_article_run"
										value="<?php echo esc_attr( $ai_val ); ?>"
										<?php disabled( $ai_max === 0 ); ?>>
								</label>

								<?php if ( $ai_max === 0 ) : ?>
									<p class="description urlifywriter-danger-text urlifywriter-mt-6">
										<?php echo esc_html__( 'Not available: add your OpenAI API in Connections or upgrade your license.', 'urlifywriter' ); ?>
									</p>
								<?php endif; ?>

								<div class="urlifywriter-mt-10">
									<label for="urlifywriterai_style_hint_run" class="urlifywriter-label">
										<?php echo esc_html__( 'AI Style hint (optional, this run only)', 'urlifywriter' ); ?>
									</label>
									<input type="text" id="urlifywriterai_style_hint_run" class="urlifywriter-input"
										value="<?php echo esc_attr( $def_ai_style_hint ); ?>"
										placeholder="<?php echo esc_attr__( 'e.g. cinematic, moody, 50mm, shallow depth of field', 'urlifywriter' ); ?>"
										<?php disabled( $ai_max === 0 ); ?>>
									<p class="description urlifywriter-mt-6">
										<?php echo esc_html__( 'Short style guidance appended to the AI prompt for this single creation. Leaves global setting unchanged.', 'urlifywriter' ); ?>
									</p>
								</div>
							</div>

							<hr class="urlifywriter-hr">

							<strong><?php echo esc_html__( 'Placement', 'urlifywriter' ); ?></strong>
							<div class="urlifywriter-subrow">
								<select id="urlifywriterimage_insert_run" class="urlifywriter-input urlifywriter-max-220">
									<option value="featured" <?php selected( $def_image_insert, 'featured' ); ?>><?php echo esc_html__( 'Featured only', 'urlifywriter' ); ?></option>
									<option value="inline"   <?php selected( $def_image_insert, 'inline' ); ?>><?php echo esc_html__( 'Inline only', 'urlifywriter' ); ?></option>
									<option value="both"     <?php selected( $def_image_insert, 'both' ); ?>><?php echo esc_html__( 'Featured + Inline', 'urlifywriter' ); ?></option>
								</select>
							</div>
						</fieldset>
					</div>
				</div>

				<div class="urlifywriter-form-row urlifywriter-mt-20">
					<h3 class="urlifywriter-h3"><?php echo esc_html__( 'Publication', 'urlifywriter' ); ?></h3>

					<label for="urlifywriterpublish_mode" class="urlifywriter-label"><?php echo esc_html__( 'Status', 'urlifywriter' ); ?></label>
					<select id="urlifywriterpublish_mode" class="urlifywriter-input urlifywriter-max-240">
						<option value="draft"><?php echo esc_html__( 'Draft', 'urlifywriter' ); ?></option>
						<option value="publish"><?php echo esc_html__( 'Publish immediately', 'urlifywriter' ); ?></option>
						<option value="schedule"><?php echo esc_html__( 'Schedule', 'urlifywriter' ); ?></option>
					</select>

					<div id="urlifywriter-schedule-options" class="urlifywriter-schedule" style="display:none;">
						<p>
							<strong><?php echo esc_html__( 'Frequency of publication:', 'urlifywriter' ); ?></strong><br>
							<label><input type="radio" name="urlifywriterschedule_freq" value="daily" checked> <?php echo esc_html__( 'Daily', 'urlifywriter' ); ?></label>
							<label class="urlifywriter-ml-12"><input type="radio" name="urlifywriterschedule_freq" value="weekly"> <?php echo esc_html__( 'Weekly', 'urlifywriter' ); ?></label>
							<label class="urlifywriter-ml-12"><input type="radio" name="urlifywriterschedule_freq" value="monthly"> <?php echo esc_html__( 'Monthly', 'urlifywriter' ); ?></label>
						</p>

						<p><label><?php echo esc_html__( 'Start date:', 'urlifywriter' ); ?> <input type="date" id="urlifywriterschedule_start_date" class="urlifywriter-input"></label></p>
						<p><label><?php echo esc_html__( 'Start time:', 'urlifywriter' ); ?> <input type="time" id="urlifywriterschedule_start_time" class="urlifywriter-input"></label></p>
						<p><label><?php echo esc_html__( 'Number of articles per interval:', 'urlifywriter' ); ?> <input type="number" id="urlifywriterschedule_count" value="1" min="1" class="urlifywriter-input urlifywriter-w-70"></label></p>

						<p id="urlifywriter-hours-between-wrap" style="display:none;">
							<label><?php echo esc_html__( 'Hours between articles:', 'urlifywriter' ); ?> <input type="number" id="urlifywriterschedule_hours_between" value="1" min="1" class="urlifywriter-input urlifywriter-w-70"></label>
						</p>
					</div>
				</div>

				<div class="urlifywriter-form-row urlifywriter-mt-10">
					<button type="submit" class="urlifywriter-btn" id="urlifywriter-submit">
						<span class="urlifywriter-btn-label"><?php echo esc_html__( 'Create', 'urlifywriter' ); ?></span>
					</button>
				</div>
			</form>
		</div>

		<div class="urlifywriter-card" id="urlifywriter-progress-card" style="display:none;">
			<h2><?php echo esc_html__( 'Progress', 'urlifywriter' ); ?></h2>

			<div class="urlifywriter-progress-wrap">
				<div class="urlifywriter-progress" id="urlifywriter-progress">
					<div class="urlifywriter-progress-fill" id="urlifywriter-progress-fill" style="width:0%;"></div>
				</div>
				<div class="urlifywriter-progress-label" id="urlifywriter-progress-label">0%</div>
			</div>

			<ul class="urlifywriter-steps-lite" id="urlifywriter-steps">
				<?php foreach ( $steps as $s ) : ?>
					<li class="pend"
						data-status="<?php echo esc_attr( $s['status'] ); ?>"
						data-note="<?php echo esc_attr( $s['note'] ); ?>"
						data-key="<?php echo esc_attr( $s['key'] ); ?>"
						style="display:none;">
						<?php echo esc_html( $s['label'] ); ?>
						<span class="urlifywriter-meta-mini" style="display:none;"><?php echo ! empty( $s['note'] ) ? ' — ' . esc_html( $s['note'] ) : ''; ?></span>

						<?php if ( $s['key'] === 'extract' ) : ?>
							<div class="urlifywriter-inline-snippet" style="display:none;" data-inline-for="extract">
								<strong><?php echo esc_html__( 'Article detected:', 'urlifywriter' ); ?></strong>
								<dl class="urlifywriter-kv urlifywriter-mt-8">
									<dt><?php echo esc_html__( 'Source URL', 'urlifywriter' ); ?></dt>
									<dd><a href="#" id="urlifywriter-src-link" target="_blank" rel="noopener">—</a></dd>

									<dt><?php echo esc_html__( 'Detected title', 'urlifywriter' ); ?></dt>
									<dd id="urlifywriter-detected-title">—</dd>

									<dt><?php echo esc_html__( 'Mini preview', 'urlifywriter' ); ?></dt>
									<dd id="urlifywriter-mini-preview">—</dd>
								</dl>
							</div>
						<?php endif; ?>
					</li>
				<?php endforeach; ?>
			</ul>

			<hr class="urlifywriter-divider">

			<div id="urlifywriter-result" style="display:none;">
				<h2><?php echo esc_html__( 'Result', 'urlifywriter' ); ?></h2>

				<dl class="urlifywriter-kv">
					<dt><?php echo esc_html__( 'Title', 'urlifywriter' ); ?></dt>
					<dd id="urlifywriter-result-title">—</dd>

					<dt><?php echo esc_html__( 'Mini preview', 'urlifywriter' ); ?></dt>
					<dd id="urlifywriter-result-excerpt">—</dd>
				</dl>

				<p class="urlifywriter-meta-mini urlifywriter-mt-10" id="urlifywriter-result-links" hidden>
					<strong><?php echo esc_html__( 'Article:', 'urlifywriter' ); ?></strong>
					<a href="#" id="urlifywriter-result-edit"><?php echo esc_html__( 'Edit', 'urlifywriter' ); ?></a>
					·
					<a href="#" id="urlifywriter-result-view" target="_blank" rel="noopener"><?php echo esc_html__( 'View', 'urlifywriter' ); ?></a>
				</p>
			</div>
		</div>

		<div class="urlifywriter-card" id="urlifywriter-batch-card" style="display:none;">
			<h2><?php echo esc_html__( 'Batch queue', 'urlifywriter' ); ?></h2>
			<div id="urlifywriter-batch-summary" class="urlifywriter-meta-mini urlifywriter-mb-8"></div>
			<ol id="urlifywriter-batch-list" class="urlifywriter-batch-list"></ol>
		</div>

		<!-- nonce for JS -->
		<input type="hidden" id="urlifywriterajax_nonce" value="<?php echo esc_attr( wp_create_nonce( 'urlifywriterurl_flow' ) ); ?>">
	</div>
	<?php
}
