<?php
// admin/page-connections.php
if ( ! defined('ABSPATH') ) { exit; }

/**
 * Opciones / nombres
 * Guardamos 4 claves: Pixabay, OpenAI
 * Nota: register_setting no controla autoload. Al crear por 1ª vez, podemos usar add_option con autoload=no (en activation hook),
 * o aceptar autoload por ahora. Si quieres autoload=no, dime y te paso el activation hook.
 */
const URLIFYWRITER_OPT_PIXABAY = 'urlifywriterapi_pixabay_key';
const URLIFYWRITER_OPT_OPENAI  = 'urlifywriterapi_openai_key';


//error_log( 'URLIFYWRITER hook_suffix: ' . $hook_suffix );

add_action('admin_init', function () {

	// Grupo de ajustes
	add_settings_section(
		'urlifywriterconnections_section',
		__('API Connections', 'urlifywriter'),
		function () {
			echo '<p class="description">' .
					esc_html__('Add your API keys to unlock advanced features: multiple Pixabay images, AI image generation (OpenAI)', 'urlifywriter') .
				'</p>';
		},
		'urlifywriter-connections'
	);

	// Sanitizers
	$sanitize_key = function( $val ) {
		$val = is_string($val) ? trim(wp_strip_all_tags($val)) : '';
		// Evitar espacios invisibles o saltos de línea
		$val = preg_replace('/\s+/', '', $val);
		return $val;
	};

	// Registrar opciones
	register_setting('urlifywriter-connections', URLIFYWRITER_OPT_PIXABAY, ['type'=>'string','sanitize_callback'=>$sanitize_key,'default'=>'']);
	register_setting('urlifywriter-connections', URLIFYWRITER_OPT_OPENAI,  ['type'=>'string','sanitize_callback'=>$sanitize_key,'default'=>'']);


	// Campos
	add_settings_field(URLIFYWRITER_OPT_PIXABAY, __('Pixabay API key', 'urlifywriter'), 'urlifywriterrender_field_pixabay', 'urlifywriter-connections', 'urlifywriterconnections_section');
	add_settings_field(URLIFYWRITER_OPT_OPENAI,  __('OpenAI API key',  'urlifywriter'), 'urlifywriterrender_field_openai',  'urlifywriter-connections', 'urlifywriterconnections_section');

});

/** Helpers UI */
function urlifywritermask_key($val){
	if ( ! is_string($val) || $val === '' ) return '';
	$len = strlen($val);
	if ($len <= 8) return str_repeat('•', $len);
	// muestra 4 al inicio y 4 al final
	return substr($val,0,4) . str_repeat('•', max(0,$len-8)) . substr($val,-4);
}

function urlifywriterrender_field_key_row( $option_name, $placeholder, $doc_url = '', $cap = 'manage_options' ) {
	if ( ! current_user_can($cap) ) return;

	$val = get_option($option_name, '');
	$masked = urlifywritermask_key($val);
	$nonce = wp_create_nonce('urlifywritertest_api_nonce');

	?>
	<div class="urlifywriter-key-row" data-opt="<?php echo esc_attr($option_name); ?>">
		<input type="password" class="regular-text urlifywriter-api-input" id="<?php echo esc_attr($option_name); ?>" name="<?php echo esc_attr($option_name); ?>"
			placeholder="<?php echo esc_attr($placeholder); ?>"
			value="<?php echo esc_attr($val); ?>" autocomplete="off" />
		<button type="button" class="button urlifywriter-toggle-visibility" aria-label="<?php esc_attr_e('Show/Hide', 'urlifywriter'); ?>">
			<?php esc_html_e('Show', 'urlifywriter'); ?>
		</button>
        <button type="button" class="button button-secondary urlifywriter-test-api" data-opt="<?php echo esc_attr($option_name); ?>" data-nonce="<?php echo esc_attr($nonce); ?>">
          <?php esc_html_e('Test', 'urlifywriter'); ?>
        </button>
        <span class="spinner" aria-hidden="true"></span>
        <span class="urlifywriter-api-status" aria-live="polite"><span class="dot"></span></span>

		<?php if ( $doc_url ) : ?>
			<p class="description">
				<a href="<?php echo esc_url($doc_url); ?>" target="_blank" rel="noopener noreferrer"><?php esc_html_e('How to get an API key', 'urlifywriter'); ?></a>
			</p>
		<?php endif; ?>
	</div>
	<?php
}

function urlifywriterrender_field_pixabay(){
	urlifywriterrender_field_key_row(URLIFYWRITER_OPT_PIXABAY, 'pixabay-xxxxxxxxxxxxxxxxxxxxxxxxx', 'https://pixabay.com/api/docs/');
}
function urlifywriterrender_field_openai(){
	urlifywriterrender_field_key_row(URLIFYWRITER_OPT_OPENAI, 'sk-xxxxxxxxxxxxxxxxxxxxxxxxx', 'https://platform.openai.com/api-keys');
}


/** Render de la página */
function urlifywriterrender_connections_page() {
	if ( ! current_user_can('manage_options') ) {
		wp_die( esc_html__('You do not have sufficient permissions to access this page.', 'urlifywriter') );
	}
	?>
	<div class="wrap urlifywriter-wrap">
		<div class="urlifywriter-hero">
			<div>
				<h1 class="urlifywriter-title"><?php echo esc_html__('UrlifyWriter — Connections (APIs)', 'urlifywriter'); ?></h1>
				<p class="urlifywriter-subtitle">
					<?php echo esc_html__('Paste your API keys to unlock multi-image Pixabay and AI image generation.', 'urlifywriter'); ?>
				</p>
			</div>
			<span class="urlifywriter-badge">APIs</span>
		</div>

		<div class="urlifywriter-card" style="max-width:760px;">
			<form method="post" action="options.php" class="urlifywriter-form">
				<?php
				settings_fields('urlifywriter-connections');
				do_settings_sections('urlifywriter-connections');
				submit_button( __('Save Changes', 'urlifywriter') );
				?>
			</form>
		</div>
	</div>

	<?php
}
