<?php
/**
 * Admin Page — AutoScan (Domains → Detect → Ignore/Retry)
 */
if ( ! defined( 'ABSPATH' ) ) { exit; }

function urlifywriterrender_autoscan_page() {
	if ( ! current_user_can( 'edit_posts' ) ) {
		wp_die( esc_html__( 'You do not have sufficient permissions to access this page.', 'urlifywriter' ) );
	}

	$nonce = wp_create_nonce( 'urlifywriterautoscan' );

	// Intervals for sources (per-domain)
	$intervals = array(
		'urlifywriterevery_30_minutes' => __( 'Every 30 minutes', 'urlifywriter' ),
		'hourly'                      => __( 'Hourly', 'urlifywriter' ),
		'urlifywriterevery_3_hours'   => __( 'Every 3 hours', 'urlifywriter' ),
		'urlifywriterevery_6_hours'   => __( 'Every 6 hours', 'urlifywriter' ),
		'urlifywriterevery_12_hours'  => __( 'Every 12 hours', 'urlifywriter' ),
		'daily'                       => __( 'Daily', 'urlifywriter' ),
	);

	// Global cron intervals (both crons use this set)
	$cron_intervals = array(
		'urlifywriterevery_5_minutes'  => __( 'Every 5 minutes', 'urlifywriter' ),
		'urlifywriterevery_15_minutes' => __( 'Every 15 minutes', 'urlifywriter' ),
		'urlifywriterevery_30_minutes' => __( 'Every 30 minutes', 'urlifywriter' ),
		'hourly'                       => __( 'Hourly', 'urlifywriter' ),
		'urlifywriterevery_3_hours'    => __( 'Every 3 hours', 'urlifywriter' ),
		'urlifywriterevery_6_hours'    => __( 'Every 6 hours', 'urlifywriter' ),
		'urlifywriterevery_12_hours'   => __( 'Every 12 hours', 'urlifywriter' ),
		'daily'                        => __( 'Daily', 'urlifywriter' ),
	);

	$cron_current_scan = get_option( 'urlifywriterautoscan_interval', 'hourly' );
	$cron_current_gen  = get_option( 'urlifywriterautogen_interval', 'urlifywriterevery_15_minutes' );

	// Advisory config (fallbacks)
	$jitter_pct   = defined( 'URLIFYWRITER_AUTOSCAN_JITTER_PCT' ) ? (int) round( URLIFYWRITER_AUTOSCAN_JITTER_PCT * 100 ) : 25;
	$stagger_min  = defined( 'URLIFYWRITER_AUTOSCAN_STAGGER_MIN_MIN' ) ? (int) URLIFYWRITER_AUTOSCAN_STAGGER_MIN_MIN : 2;
	$stagger_max  = defined( 'URLIFYWRITER_AUTOSCAN_STAGGER_MAX_MIN' ) ? (int) URLIFYWRITER_AUTOSCAN_STAGGER_MAX_MIN : 7;
	$min_interval = defined( 'URLIFYWRITER_AUTOSCAN_MIN_INTERVAL_MIN' ) ? (int) URLIFYWRITER_AUTOSCAN_MIN_INTERVAL_MIN : 30;
	?>
	<div class="wrap urlifywriter-wrap">
		<div class="urlifywriter-hero">
			<div>
				<h1 class="urlifywriter-title"><?php echo esc_html__( 'AutoScan — Domains & Queue', 'urlifywriter' ); ?></h1>
				<p class="description urlifywriter-hero-desc">
					<?php echo esc_html__( 'Add news/blog domains to watch. The scanner will detect new articles and add them to a queue. Pending items are processed by AutoGen automatically.', 'urlifywriter' ); ?>
				</p>
			</div>
			<span class="urlifywriter-badge">UrlifyWriter</span>
		</div>

		<div class="notice notice-info urlifywriter-advisory">
			<p>
				<strong><?php echo esc_html__( 'Heads up:', 'urlifywriter' ); ?></strong>
				<?php
				printf(
					/* translators: 1: minimum minutes between scans, 2: jitter percentage, 3: minimum staggering minutes, 4: maximum staggering minutes. */
					esc_html__(
						'to reduce the risk of being rate-limited or blocked, AutoScan adds randomness to each run. We apply ±%2$d%% jitter to the base interval, plus a per-domain staggering of %3$d–%4$d minutes. There is also a safety minimum of %1$d minutes between scans.',
						'urlifywriter'
					),
					absint( $min_interval ),
					absint( $jitter_pct ),
					absint( $stagger_min ),
					absint( $stagger_max )
				);
				?>
			</p>
			<p><?php echo esc_html__( 'Recommendation: avoid very short intervals.', 'urlifywriter' ); ?></p>
		</div>

		<div id="urlifywriter-autoscan-notices"></div>

		<div class="urlifywriter-grid-2">
			<div class="urlifywriter-card">
				<h2><?php echo esc_html__( 'Sources', 'urlifywriter' ); ?></h2>

				<form id="urlifywriter-src-form" class="urlifywriter-form">
					<input type="hidden" name="nonce" value="<?php echo esc_attr( $nonce ); ?>">
					<input type="hidden" name="id" id="urlifywriter-src-id" value="0">

					<div class="urlifywriter-form-grid urlifywriter-src-grid">
						<div>
							<label class="urlifywriter-label" for="urlifywriter-src-domain"><?php echo esc_html__( 'Domain', 'urlifywriter' ); ?></label>
							<input type="text" id="urlifywriter-src-domain" class="urlifywriter-input" placeholder="example.com">
						</div>
						<div>
							<label class="urlifywriter-label" for="urlifywriter-src-start"><?php echo esc_html__( 'Start URL', 'urlifywriter' ); ?></label>
							<input type="url" id="urlifywriter-src-start" class="urlifywriter-input" placeholder="https://example.com/">
						</div>
						<div>
							<label class="urlifywriter-label" for="urlifywriter-src-interval"><?php echo esc_html__( 'Interval', 'urlifywriter' ); ?></label>
							<select id="urlifywriter-src-interval" class="urlifywriter-input">
								<?php foreach ( $intervals as $k => $label ) : ?>
									<option value="<?php echo esc_attr( $k ); ?>"><?php echo esc_html( $label ); ?></option>
								<?php endforeach; ?>
							</select>
						</div>
						<div>
							<label class="urlifywriter-label" for="urlifywriter-src-maxday"><?php echo esc_html__( 'Max/day', 'urlifywriter' ); ?></label>
							<input type="number" id="urlifywriter-src-maxday" class="urlifywriter-input" value="5" min="0" step="1">
						</div>
					</div>

					<div class="urlifywriter-mt-8">
						<label class="urlifywriter-label" for="urlifywriter-src-instructions"><?php echo esc_html__( 'Generation instructions (optional)', 'urlifywriter' ); ?></label>
						<textarea id="urlifywriter-src-instructions" class="urlifywriter-input" rows="3" placeholder="<?php echo esc_attr__( 'Editorial style, voice, SEO notes…', 'urlifywriter' ); ?>"></textarea>
					</div>

					<div class="urlifywriter-row">
						<label><input type="checkbox" id="urlifywriter-src-enabled" checked> <?php echo esc_html__( 'Enabled', 'urlifywriter' ); ?></label>
						<button type="submit" class="button button-primary" id="urlifywriter-src-save"><?php echo esc_html__( 'Save source', 'urlifywriter' ); ?></button>
						<button type="button" class="button" id="urlifywriter-src-reset"><?php echo esc_html__( 'Reset form', 'urlifywriter' ); ?></button>
					</div>

					<p class="description urlifywriter-mt-6">
						<?php echo esc_html__( 'Tip: leave “Start URL” empty to default to https://{domain}/', 'urlifywriter' ); ?>
					</p>
				</form>

				<div class="urlifywriter-table-wrap">
					<table class="widefat striped">
						<thead>
							<tr>
								<th><?php echo esc_html__( 'ID', 'urlifywriter' ); ?></th>
								<th><?php echo esc_html__( 'Domain', 'urlifywriter' ); ?></th>
								<th><?php echo esc_html__( 'Start URL', 'urlifywriter' ); ?></th>
								<th><?php echo esc_html__( 'Interval', 'urlifywriter' ); ?></th>
								<th><?php echo esc_html__( 'Max/day', 'urlifywriter' ); ?></th>
								<th><?php echo esc_html__( 'Enabled', 'urlifywriter' ); ?></th>
								<th><?php echo esc_html__( 'Last scan', 'urlifywriter' ); ?></th>
								<th><?php echo esc_html__( 'Next scan', 'urlifywriter' ); ?></th>
								<th><?php echo esc_html__( 'Actions', 'urlifywriter' ); ?></th>
							</tr>
						</thead>
						<tbody id="urlifywriter-src-tbody">
							<tr><td colspan="9"><?php echo esc_html__( 'Loading…', 'urlifywriter' ); ?></td></tr>
						</tbody>
					</table>
				</div>
			</div>

			<div>
				<div class="urlifywriter-card">
					<h2><?php echo esc_html__( 'Cron status', 'urlifywriter' ); ?></h2>

					<div class="urlifywriter-cron-grid">
						<div class="urlifywriter-subcard">
							<h3><?php echo esc_html__( 'AutoScan', 'urlifywriter' ); ?></h3>
							<div class="urlifywriter-form-grid urlifywriter-cron-meta">
								<div>
									<div class="urlifywriter-label"><?php echo esc_html__( 'Scheduled', 'urlifywriter' ); ?></div>
									<div id="urlifywriter-cron-scheduled">—</div>
								</div>
								<div>
									<div class="urlifywriter-label"><?php echo esc_html__( 'Next run', 'urlifywriter' ); ?></div>
									<div id="urlifywriter-cron-next">—</div>
								</div>
								<div>
									<div class="urlifywriter-label"><?php echo esc_html__( 'Last run', 'urlifywriter' ); ?></div>
									<div id="urlifywriter-cron-last">—</div>
								</div>
								<div class="urlifywriter-cron-span">
									<label class="urlifywriter-label" for="urlifywriter-cron-interval"><?php echo esc_html__( 'Global interval', 'urlifywriter' ); ?></label>
									<select id="urlifywriter-cron-interval" class="urlifywriter-input urlifywriter-max-280">
										<?php foreach ( $cron_intervals as $k => $label ) : ?>
											<option value="<?php echo esc_attr( $k ); ?>" <?php selected( $cron_current_scan, $k ); ?>><?php echo esc_html( $label ); ?></option>
										<?php endforeach; ?>
									</select>
								</div>
							</div>

							<div class="urlifywriter-row urlifywriter-wrap-buttons">
								<button type="button" class="button" id="urlifywriter-cron-refresh"><?php echo esc_html__( 'Refresh', 'urlifywriter' ); ?></button>
								<button type="button" class="button button-primary" id="urlifywriter-cron-start"><?php echo esc_html__( 'Start / Apply interval', 'urlifywriter' ); ?></button>
								<button type="button" class="button" id="urlifywriter-cron-stop"><?php echo esc_html__( 'Stop', 'urlifywriter' ); ?></button>
								<button type="button" class="button" id="urlifywriter-cron-run"><?php echo esc_html__( 'Run now', 'urlifywriter' ); ?></button>
							</div>

							<p class="description" id="urlifywriter-cron-msg"></p>
						</div>

						<div class="urlifywriter-subcard">
							<h3><?php echo esc_html__( 'AutoGen', 'urlifywriter' ); ?></h3>
							<div class="urlifywriter-form-grid urlifywriter-cron-meta">
								<div>
									<div class="urlifywriter-label"><?php echo esc_html__( 'Scheduled', 'urlifywriter' ); ?></div>
									<div id="urlifywriter-gen-scheduled">—</div>
								</div>
								<div>
									<div class="urlifywriter-label"><?php echo esc_html__( 'Next run', 'urlifywriter' ); ?></div>
									<div id="urlifywriter-gen-next">—</div>
								</div>
								<div>
									<div class="urlifywriter-label"><?php echo esc_html__( 'Last run', 'urlifywriter' ); ?></div>
									<div id="urlifywriter-gen-last">—</div>
								</div>
								<div class="urlifywriter-cron-span">
									<label class="urlifywriter-label" for="urlifywriter-gen-interval"><?php echo esc_html__( 'Global interval', 'urlifywriter' ); ?></label>
									<select id="urlifywriter-gen-interval" class="urlifywriter-input urlifywriter-max-280">
										<?php foreach ( $cron_intervals as $k => $label ) : ?>
											<option value="<?php echo esc_attr( $k ); ?>" <?php selected( $cron_current_gen, $k ); ?>><?php echo esc_html( $label ); ?></option>
										<?php endforeach; ?>
									</select>
								</div>
							</div>

							<div class="urlifywriter-row urlifywriter-wrap-buttons">
								<button type="button" class="button" id="urlifywriter-gen-refresh"><?php echo esc_html__( 'Refresh', 'urlifywriter' ); ?></button>
								<button type="button" class="button button-primary" id="urlifywriter-gen-start"><?php echo esc_html__( 'Start / Apply interval', 'urlifywriter' ); ?></button>
								<button type="button" class="button" id="urlifywriter-gen-stop"><?php echo esc_html__( 'Stop', 'urlifywriter' ); ?></button>
								<button type="button" class="button" id="urlifywriter-gen-run"><?php echo esc_html__( 'Run now', 'urlifywriter' ); ?></button>
							</div>

							<p class="description" id="urlifywriter-gen-msg"></p>
						</div>
					</div>

					<p class="description urlifywriter-mt-6">
						<?php echo esc_html__( 'AutoScan discovers URLs (subject to per-source Max/day). AutoGen converts pending items into posts (batch size in Settings).', 'urlifywriter' ); ?>
					</p>
				</div>
			</div>
		</div>

		<div class="urlifywriter-card urlifywriter-mt-16">
			<h2><?php echo esc_html__( 'Detected items', 'urlifywriter' ); ?></h2>

			<div class="urlifywriter-items-toolbar">
				<label>
					<span class="urlifywriter-label"><?php echo esc_html__( 'Source', 'urlifywriter' ); ?></span>
					<select id="urlifywriter-items-source" class="urlifywriter-input urlifywriter-min-220"></select>
				</label>

				<label>
					<span class="urlifywriter-label"><?php echo esc_html__( 'Status', 'urlifywriter' ); ?></span>
					<select id="urlifywriter-items-status" class="urlifywriter-input">
						<option value=""><?php echo esc_html__( 'All', 'urlifywriter' ); ?></option>
						<option value="pending">pending</option>
						<option value="processing">processing</option>
						<option value="done">done</option>
						<option value="failed">failed</option>
						<option value="ignored">ignored</option>
					</select>
				</label>

				<label>
					<span class="urlifywriter-label"><?php echo esc_html__( 'Per page', 'urlifywriter' ); ?></span>
					<input type="number" id="urlifywriter-items-perpage" class="urlifywriter-input urlifywriter-w-100" value="20" min="5" max="100">
				</label>

				<div class="urlifywriter-items-refresh">
					<button type="button" class="button" id="urlifywriter-items-refresh"><?php echo esc_html__( 'Refresh', 'urlifywriter' ); ?></button>
				</div>
			</div>

			<div class="urlifywriter-table-wrap urlifywriter-mt-10">
				<table class="widefat striped">
					<thead>
						<tr>
							<th><input type="checkbox" id="urlifywriter-items-checkall"></th>
							<th><?php echo esc_html__( 'ID', 'urlifywriter' ); ?></th>
							<th><?php echo esc_html__( 'Priority', 'urlifywriter' ); ?></th>
							<th><?php echo esc_html__( 'Title', 'urlifywriter' ); ?></th>
							<th><?php echo esc_html__( 'URL', 'urlifywriter' ); ?></th>
							<th><?php echo esc_html__( 'Status', 'urlifywriter' ); ?></th>
							<th><?php echo esc_html__( 'Detected at', 'urlifywriter' ); ?></th>
							<th><?php echo esc_html__( 'Actions', 'urlifywriter' ); ?></th>
						</tr>
					</thead>
					<tbody id="urlifywriter-items-tbody">
						<tr><td colspan="8"><?php echo esc_html__( 'Select a source to load items…', 'urlifywriter' ); ?></td></tr>
					</tbody>
				</table>
			</div>

			<div class="urlifywriter-items-footer">
				<div>
					<button type="button" class="button" id="urlifywriter-items-retry-failed"><?php echo esc_html__( 'Retry all failed', 'urlifywriter' ); ?></button>
				</div>
				<div id="urlifywriter-items-pager" class="urlifywriter-meta-mini"></div>
			</div>
		</div>

		<!-- data for JS -->
		<input type="hidden" id="urlifywriter-autoscan-nonce" value="<?php echo esc_attr( $nonce ); ?>">
	</div>
	<?php
}
