jQuery(document).ready(function ($) {
    $("#start_prod_translate").on("click", function (e) {
        e.preventDefault();
        var selected_lang = $("#selected_country_lang").val();
        var update_option = $("input[name='update_prod_url']:checked").val();
        var total_page = $(".total_page").val();
        var user_id = custom_admin_data.user_id;

        if (selected_lang) {
            let counter = 1;
            $("div.basic_form_translate").hide();
            $("<div class='loader'></div>").insertAfter("div.form_translation_data");
            $("<div class='progress'></div>").insertAfter("div.loader");
            $("<p class='progress_text'>0%</p>").insertAfter("div.progress");

            const intervalId = setInterval(function () {
                if (counter <= total_page) {
                    $.ajax({
                        type: "POST",
                        dataType: "json",
                        url: custom_admin_data.ajax_url,
                        data: {
                            action: "start_translating_products",
                            selected_language: selected_lang,
                            updated_option: update_option,
                            current_page: counter,
                            total_page: total_page,
                            user_id: user_id
                        },
                        success: function (response) {},
                        error: function () {
                            alert("Error occurred.");
                        }
                    });

                    let percentage = Math.round((counter / total_page) * 100);
                    $("p.progress_text").text(percentage + "%");
                    $(".progress").css("width", percentage + "%");
                    counter++;
                } else {
                    $("div.loader, div.progress, p.progress_text").remove();
                    $("div.basic_form_translate").show();
                    $("<p class='success_message'>URL is updated successfully.</p>").insertAfter("#start_prod_translate");
                    clearInterval(intervalId);
                }
            }, 3000);
        } else {
            alert("Please select any language.");
        }
    });

    $("#export_products_csv").on("click", function (e) {
        e.preventDefault();
        var file_name = $("#export_file_name").val();
        var total_page = $("#total_pages").val();
        var post_status = $("#select_post_type").val();
        let counter = 1;

        $("<div class='loader'></div>").insertBefore("#export_products_csv");
        $("<div class='progress'></div>").insertAfter("div.loader");
        $("<p class='progress_text'>0%</p>").insertAfter("div.progress");

        const intervalId = setInterval(function () {
            if (counter <= total_page) {
                $.ajax({
                    type: "GET",
                    dataType: "json",
                    url: custom_admin_data.ajax_url,
                    data: {
                        action: "generate_csv_file",
                        file_name: file_name,
                        page_number: counter,
                        post_status: post_status
                    },
                    success: function (data) {
                        if (counter === total_page) {
                            var fileurl = data.data.file_url;
                            $("a#view_file_csv").attr("href", fileurl).show();
                        }
                    },
                    error: function () {
                        alert("Error occurred.");
                    }
                });

                let percentage = Math.round((counter / total_page) * 100);
                $("p.progress_text").text(percentage + "%");
                $(".progress").css("width", percentage + "%");
                counter++;
            } else {
                clearInterval(intervalId);
                $("div.loader").remove();
            }
        }, 3000);
    });
});