import { defineConfig } from 'vite';
import tailwindcss from 'tailwindcss';


export default defineConfig({
    minify: false,

    css: {
        postcss: {
          plugins: [tailwindcss],
        },
      },
    build: {
        outDir: 'assets',
        rollupOptions: {
            input: 
                [
                    'resources/js/admin.js',
                    'resources/js/upsellar.js',
                    'resources/js/gutenberg-block.js',
                    'resources/css/admin.css',
                    'resources/css/app.css',
                ],
            output: {
                // Entry file names for JS and chunk files
                entryFileNames: 'js/[name].js',
                chunkFileNames: 'js/[name].js',
                // Asset file name pattern for CSS
                assetFileNames: ({name}) => {
                if (name.endsWith('.css')) {
                    return 'css/[name][extname]'; // CSS files go to /assets/css
                } else {
                    return '[extname]/[name][extname]'; // Other assets like images/fonts
                }
                }
            }
        }
    },

});
