<?php
/**
 * Plugin Name: Upsellar
 * Plugin URI: https://upsellar.com/
 * Description: AI-Powered Product Recommendations.
 * Version: 1.0.2
 * Author: Upsellar
 * Author URI: https://upsellar.com
 * Text Domain: upsellar
 * Domain Path: /languages
 * Requires at least: 6.3
 * Requires PHP: 7.4
 * License: GPLv3
 * License URI: https://www.gnu.org/licenses/gpl-3.0.html
 */

defined( 'ABSPATH' ) || exit;

define('UPSELLAR_ENVIRONMENT', 'dev'); 

require_once __DIR__ . '/vendor/autoload.php';

register_activation_hook(__FILE__, 'upsellar_activation_hook');

/**
 * Upsellar activation hook.
 * 
 * @return void
 * @since 1.0.0
 */
function upsellar_activation_hook() {
    // Set a transient to show the admin notice
    set_transient('upsellar_show_getting_started_notice', true, 5 * MINUTE_IN_SECONDS);
}

add_action('admin_notices', 'upsellar_show_getting_started_notice');

/**
 * Show getting started notice.
 * 
 * @return void
 * @since 1.0.0
 */
function upsellar_show_getting_started_notice() {
    // Check if our transient is set, and display the notice if it is
    if(get_transient('upsellar_show_getting_started_notice')) {
        echo '<div class="notice notice-success is-dismissible">
            <p><strong>Upsellar activated!</strong> Check out the <a href="https://upsellar.com/getting-started">Getting Started guide</a> to get up and running.</p>
        </div>';
        // Delete the transient so the message is shown only once
        delete_transient('upsellar_show_getting_started_notice');
    }
}

// Initialize the plugin
add_action('plugins_loaded', function() {
    new \Upsellar\Admin\UpsellarPluginInitializer(__FILE__);
});

add_action('updated_option', function($option, $old_value, $value) {
    $settingsManager = new \Upsellar\Admin\UpsellarSettingsManager();
    $settingsManager->upsellar_test_api_key_on_update($option, $old_value, $value);
}, 10, 3);


add_action('init', function() {
    $cookieUtilities = new \Upsellar\Utilities\UpsellarCookieUtilities();
    $cookieUtilities->upsellar_generate_guest_token();
});

add_action('woocommerce_loaded', function() {
    // Remove the original WooCommerce actions
    remove_action('woocommerce_cart_collaterals', 'woocommerce_cross_sell_display');
    remove_action('woocommerce_after_single_product_summary', 'woocommerce_output_related_products', 20);

    // Add your custom functions to the WooCommerce hooks
    add_action('woocommerce_cart_collaterals', 'upsellar_cross_sell_display');
    add_action('woocommerce_after_single_product_summary', 'upsellar_related_products', 20);
});

/**
 * Custom cross sell display function.
 * 
 * This function will display cross sells based on the products in the cart.
 * 
 * @return void
 * @since 1.0.0
 */
function upsellar_cross_sell_display() {

    if( get_option(\Upsellar\Admin\UpsellarSettingsManager::CROSS_SELLS_DISPLAY, true) == true){
        $CartBlockRenderer = new \Upsellar\Engine\Traditional\UpsellarTraditionalCartBlockRenderer();
        $output = $CartBlockRenderer->upsellar_initialize_block(null);
        echo wp_kses_post($output); 
    }

}

/**
 * Custom related products function.
 * 
 * This function will display related products based on the current product.
 * 
 * @return void
 * @since 1.0.0
 */
function upsellar_related_products(){
    if( get_option(\Upsellar\Admin\UpsellarSettingsManager::PRODUCT_PAGE_DISPLAY, true) == true){
        $RelatedProductsBlockRenderer = new \Upsellar\Engine\Traditional\UpsellarTraditionalRelatedProductsBlockRenderer();
        $output = $RelatedProductsBlockRenderer->upsellar_initialize_block(null);
        echo wp_kses_post($output);     
    }
}
