<?php

namespace Upsellar\Utilities;

// Check if WordPress environment is loaded
if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly
}

class UpsellarCookieUtilities {

    /**
     * Generate a unique token for guests.
     * 
     * @return void
     * @since 1.0.0
     */
    public function upsellar_generate_guest_token() {
        if (!isset($_COOKIE['upsellar_guest_token'])) {
            $guest_token = uniqid('guest_', true);
            setcookie('upsellar_guest_token', $guest_token, time() + (86400 * 30), "/");
        }
    }
    
    /**
     * Retrieve the guest token.
     * 
     * @return string|null The guest token if it exists, null otherwise.
     * @since 1.0.0
     */
    public function upsellar_get_guest_token() {
        if (isset($_COOKIE['upsellar_guest_token'])) {
            return sanitize_text_field(wp_unslash($_COOKIE['upsellar_guest_token']));
        }
        return null;
    }
    
    /**
     * Get the user identifier. This will be either a logged in user ID or a guest token.
     * 
     * @return int|string The user identifier.
     * @since 1.0.0
     */
    public function upsellar_get_user_identifier(){
        $user_identifier = is_user_logged_in() ? get_current_user_id() : $this->upsellar_get_guest_token();

        return $user_identifier;
    }

    /**
     * Get the user type. This will be either 'user' or 'guest'.
     * 
     * @return string The user type.
     * @since 1.0.0
     */
    public function upsellar_get_user_type(){

        $user_type = is_user_logged_in() ? 'user' : 'guest';

        return $user_type;
    }

}
