<?php

namespace Upsellar\Interaction;


defined('ABSPATH') || exit;


class UpsellarWoocommerceInteractionController {

    protected $interactionController;
    protected $user_identifier;
    protected $user_type;

    public function __construct() {
        $this->interactionController = new UpsellarInteractionTrackingController();

        // Track when a product page is viewed
        add_action('woocommerce_after_single_product', array($this, 'upsellar_track_product_view'));

        // Track when a product is added to the cart
        add_action('woocommerce_add_to_cart', array($this, 'upsellar_track_add_to_cart'), 10, 6);

        // Track when a purchase is made
        add_action('woocommerce_thankyou', array($this, 'upsellar_track_purchase'), 10, 1);

    }

    public function upsellar_track_product_view() {
        global $product;
        if ($product) {
            $interactionData = array(
                'actionType' => 'view',
                'productId' => $product->get_id(),
                'timestamp' => current_time('mysql')                 
            );
            $this->interactionController->upsellar_handle_php_interaction($interactionData);
        }
    }

    public function upsellar_track_add_to_cart($cart_item_key, $product_id, $quantity, $variation_id, $variation, $cart_item_data) {
        $interactionData = array(
            'actionType' => 'add_to_cart',
            'productId' => $product_id,
            'timestamp' => current_time('mysql') 
        );

        $this->interactionController->upsellar_handle_php_interaction($interactionData);
    }

    public function upsellar_track_purchase($order_id) {
        $order = wc_get_order($order_id);
        if ($order) {
            foreach ($order->get_items() as $item_id => $item) {
                $interactionData = array(
                    'actionType' => 'purchase',
                    'productId' => $item->get_product_id(),
                    'orderId' => $order_id,
                    'timestamp' => $order->get_date_created()->date('Y-m-d H:i:s') // Order creation time
                );
                $this->interactionController->upsellar_handle_php_interaction($interactionData);
            }
        }
    }

    public function upsellar_import_existing_sales() {
    
        $dataImportURL = 'https://upsellar.com/api/v1/import-data';
        $batch_size = 100; // Number of orders to process at a time
    
        $current_page = 1;
        $finished = false;
    
        while (!$finished) {
            $args = array(
                'status' => 'completed', // Get only completed orders
                'limit' => $batch_size,  // Process in batches
                'paged' => $current_page, // Current page number
            );
    
            $orders = wc_get_orders($args);
    
            if (empty($orders)) {
                $finished = true;
                continue;
            }
    
            foreach ($orders as $order) {
                $user_id = $order->get_user_id();
                $userType = $user_id ? 'user' : 'guest';
                $user_identifier = $user_id ? $user_id : $order->get_billing_email();
    
                foreach ($order->get_items() as $item_id => $item) {
                    $interactionData = array(
                        'actionType' => 'purchase',
                        'productId' => $item->get_product_id(),
                        'orderId' => $order->get_id(),
                        'userIdentifier' => $user_identifier,
                        'userType' => $userType,
                        'timestamp' => $order->get_date_created()->date('Y-m-d H:i:s'),
                        'imported' => true
                    );
                    $this->interactionController->upsellar_handle_data_import($interactionData, $dataImportURL);
                }
            }
    
            $current_page++;
        }
    
        return true;
    }
    

}
