<?php

namespace Upsellar\Engine;

use Upsellar\Engine\Blocks\UpsellarBlockRegistrar;
use Upsellar\Engine\Blocks\UpsellarBlockBuilder;

defined('ABSPATH') || exit;

class UpsellarEngineController {

    /**
     * Constructor for the UpsellarEngineController class.
     * 
     * @since 1.0.0
     */
    public function __construct() {
        // Initialize the UpsellarBlockRegistrar controller
        $blockRegistrar = new UpsellarBlockRegistrar();
        $blockRegistrar->upsellar_register_blocks();

        $this->upsellar_initialize_block_builder();

    }

    //TODO: WE'RE NOT USING THIS ANYMORE
    /** 
     * Initialize the RenderBlocks class.
     * 
     * @return void
     * @since 1.0.0
     */
    private function upsellar_initialize_render_blocks() {
        // Ensure WooCommerce is active before initializing
        include_once( ABSPATH . 'wp-admin/includes/plugin.php' );

        if (is_plugin_active( 'woocommerce/woocommerce.php') ) {
            new RenderBlocks();
        } else {
            add_action('admin_notices', array($this, 'upsellar_woocommerce_missing_notice'));
        }
    }

    /**
     * Display a notice that WooCommerce is required.
     * 
     * @return void
     * @since 1.0.0
     */
    public function upsellar_woocommerce_missing_notice() {
        ?>
        <div class="notice notice-error">
            <p><?php echo esc_html__('WooCommerce is required for Upsellar in to work.', 'upsellar'); ?></p>
        </div>
        <?php
    }

    /**
     * Initialize the UpsellarBlockBuilder class.
     * 
     * @return void
     * @since 1.0.0
     */
    private function upsellar_initialize_block_builder() {
        new UpsellarBlockBuilder();
    }
}
