<?php 

namespace Upsellar\Engine\Traditional;

use Upsellar\Engine\Connection\UpsellarProductFetcher;
use Upsellar\Engine\Blocks\UpsellarHtmlBuilder;
use Upsellar\Admin\UpsellarSettingsManager;

defined('ABSPATH') || exit;

// Responsible for rendering the upsellar cart block
class UpsellarTraditionalCartBlockRenderer {

    /**
     * Create the temporary placeholder for the block.
     * 
     * @param array $attributes The attributes for this block.
     * @return string The HTML for this block.
     * @since 1.0.0
     */
    public function upsellar_initialize_block($attributes) {
        $productFetcher = new UpsellarProductFetcher();
        $currentProductId= $productFetcher->upsellar_get_cart_product_ids();

        $columns = get_option(UpsellarSettingsManager::CROSS_SELLS_COLUMNS, 3);
        $rows = get_option(UpsellarSettingsManager::CROSS_SELLS_ROWS, 1);
        $limit = $columns * $rows; // Calculate the total number of products to fetch
        $type = "traditional-cart-cross-sells";

        $htmlBuilder = new UpsellarHtmlBuilder();
        return $htmlBuilder->upsellar_build_temporary_block($currentProductId, $limit, $type);
    }

    /**
     * Render the recommmended products block.
     * 
     * @param int|array $currentProductId The current product id.
     * @param int $limit The maximum number of products to fetch.
     * @return string The HTML for this block.
     * @since 1.0.0
     */
    public function upsellar_render_block($currentProductId, $limit) {
        $productFetcher = new UpsellarProductFetcher();

        $columns = get_option(UpsellarSettingsManager::CROSS_SELLS_COLUMNS, 3);

        $product_ids = $productFetcher->upsellar_get_product_ids($currentProductId, $limit);

        $htmlBuilder = new UpsellarHtmlBuilder();
        return $htmlBuilder->upsellar_build_traditional_cart_block_html($product_ids, $columns);
    }
}