<?php 

namespace Upsellar\Engine\Blocks;

defined('ABSPATH') || exit;

// Responsible for building HTML for different parts of product display
class UpsellarHtmlBuilder {

    /**
     * Builds the temproary block for the product display.
     * 
     * @param int|array $currentProductId The id of the current product.
     * @param int $limit The number of products to display.
     * @param string $type The type of the block.
     * @return string The HTML for the block.
     * @since 1.0.0
     */
    public function upsellar_build_temporary_block($currentProductId, $limit, $type) {
        $productIdsJson = wp_json_encode($currentProductId);
        return "<!-- -->
        <div data-block-name='woocommerce/cart-products' class='upsellar-block unrendered wp-block-woocommerce-related-products alignwide' data-product-ids='" . esc_attr($productIdsJson) . "'  data-limit='".$limit."' data-type='".$type."'></div>
        ";
    }

    /**
     * Adds the upsellar-card class to products.
     * 
     * @param array $classes The classes for the post.
     * @param string $class The class for the post.
     * @param int $post_id The id of the post.
     * @return array The classes for the post.
     * @since 1.0.0
     */
    function upsellar_add_upsellar_class_to_products($classes, $class = '', $post_id = null) {
        if ('product' === get_post_type($post_id)) {
            $classes[] = 'upsellar-card'; // Add your custom class
        }
    
        return $classes;
    } 
    
    /**
     * Builds the cart block HTML.
     * 
     * @param array $product_ids The product ids.
     * @param int $columns The number of columns.
     * @return string The HTML for the block.
     * @since 1.0.0
     */
    public function upsellar_build_cart_block_html($product_ids, $columns) {
        // Convert product IDs into product objects
        $related_products = $this->upsellar_convert_ids_to_products($product_ids);

        // Ensure WooCommerce global $product is available
        global $product;

        // If there's no global product or it's not a product object, try setting it from related products
        if (!is_a($product, 'WC_Product') && !empty($related_products)) {
            $product = $related_products[0];
        }

        // Start output buffering
        ob_start();

        add_filter('post_class', [$this, 'upsellar_add_upsellar_class_to_products']);

        $args['cross_sells'] = $related_products;
        wc_set_loop_prop( 'columns', apply_filters( 'woocommerce_related_products_columns', $columns ) );

        // Include the WooCommerce related products template
        wc_get_template('cart/cross-sells.php', $args);

        // Get the contents of the buffer and end buffering
        $output = ob_get_clean();

        return $output;
    }

    /**
     * Builds the related products block HTML.
     * 
     * @param array $product_ids The product ids.
     * @param int $columns The number of columns.
     * @return string The HTML for the block.
     * @since 1.0.0
     */
    public function upsellar_build_related_products_block_html($product_ids, $columns) {
        // Convert product IDs into product objects
        $related_products = $this->upsellar_convert_ids_to_products($product_ids);
    
        // Ensure WooCommerce global $product is available
        global $product;
    
        // If there's no global product or it's not a product object, try setting it from related products
        if (!is_a($product, 'WC_Product') && !empty($related_products)) {
            $product = $related_products[0];
        }

        // Start output buffering
        ob_start();

        add_filter('post_class', [$this, 'upsellar_add_upsellar_class_to_products']);
    
        $args['related_products'] = $related_products;
		wc_set_loop_prop( 'columns', apply_filters( 'woocommerce_related_products_columns', $columns ) );
    
        // Include the WooCommerce related products template
        wc_get_template('single-product/related.php', $args);
    
        // Get the contents of the buffer and end buffering
        $output = ob_get_clean();
    
        return $output;
    }

    /**
     * Builds the traditional cart block HTML.
     * 
     * @param array $product_ids The product ids.
     * @param int $columns The number of columns.
     * @return string The HTML for the block.
     * @since 1.0.0
     */
    public function upsellar_build_traditional_cart_block_html($product_ids, $columns) {
        // Convert product IDs into product objects
        $related_products = $this->upsellar_convert_ids_to_products($product_ids);

        // Ensure WooCommerce global $product is available
        global $product;

        // If there's no global product or it's not a product object, try setting it from related products
        if (!is_a($product, 'WC_Product') && !empty($related_products)) {
            $product = $related_products[0];
        }

        // Start output buffering
        ob_start();

        add_filter('post_class', [$this, 'upsellar_add_upsellar_class_to_products']);

        $args['cross_sells'] = $related_products;
        wc_set_loop_prop( 'columns', apply_filters( 'woocommerce_related_products_columns', $columns ) );

        // Include the WooCommerce related products template
        wc_get_template('cart/cross-sells.php', $args);

        // Get the contents of the buffer and end buffering
        $output = ob_get_clean();

        return $output;
    }

    /**
     * Builds the traditional related products block HTML.
     * 
     * @param array $product_ids The product ids.
     * @param int $columns The number of columns.
     * @return string The HTML for the block.
     * @since 1.0.0
     */
    public function upsellar_build_traditional_related_products_block_html($product_ids, $columns) {
        // Convert product IDs into product objects
        $related_products = $this->upsellar_convert_ids_to_products($product_ids);

        // Ensure WooCommerce global $product is available
        global $product;

        // If there's no global product or it's not a product object, try setting it from related products
        if (!is_a($product, 'WC_Product') && !empty($related_products)) {
            $product = $related_products[0];
        }

        // Start output buffering
        ob_start();

        add_filter('post_class', [$this, 'upsellar_add_upsellar_class_to_products']);

        $args['related_products'] = $related_products;
        wc_set_loop_prop( 'columns', apply_filters( 'woocommerce_related_products_columns', $columns ) );

        // Include the WooCommerce related products template
        wc_get_template('single-product/related.php', $args);

        // Get the contents of the buffer and end buffering
        $output = ob_get_clean();

        return $output;
    }

    private function upsellar_convert_ids_to_products($product_ids){
        return wc_get_products( 
            [ 
            'include' => $product_ids 
            ] 
        );
    }

    
}
