<?php 

namespace Upsellar\Engine\Blocks;

use Upsellar\Engine\Blocks\UpsellarCartBlockRenderer;
use Upsellar\Engine\Blocks\UpsellarRelatedProductsBlockRenderer;
use Upsellar\Admin\UpsellarSettingsManager;

defined('ABSPATH') || exit;

// Responsible for registering WooCommerce blocks
class UpsellarBlockRegistrar {

    /**
     * Initialize the block registration process.
     * 
     * @return void
     * @since 1.0.0
     */
    public function upsellar_register_blocks() {
        if (!is_admin()) {
            
            add_action('woocommerce_loaded', array($this, 'upsellar_initialize_block_registration'));

            add_action('wp', array($this, 'upsellar_initialize_post_wp_block_registration'));

        }  
    }

    /**
     * Register the Upsellar Cart block.
     * 
     * @return void
     * @since 1.0.0
     */
    public function upsellar_initialize_post_wp_block_registration() {
        if (function_exists('is_cart') && is_cart()) {
            if( get_option(UpsellarSettingsManager::CROSS_SELLS_DISPLAY, true) == true){
                $this->upsellar_register_cart_upsellar_block();
            }
        }
    }
    
    /**
     * Register the Upsellar Related Products block.
     * 
     * @return void
     * @since 1.0.0
     */
    public function upsellar_initialize_block_registration() {
        if( get_option(UpsellarSettingsManager::PRODUCT_PAGE_DISPLAY, true) == true){
            $this->upsellar_register_upsellar_related_products_block();
        }
    }
    
    /**
     * Register the Upsellar Cart block.
     * 
     * @return void
     * @since 1.0.0
     */
    public function upsellar_register_cart_upsellar_block() {
        if ( \WP_Block_Type_Registry::get_instance()->is_registered('woocommerce/cart-cross-sells-block') ) {
            
            unregister_block_type('woocommerce/cart-cross-sells-block');
        }
        register_block_type('woocommerce/cart-cross-sells-block', array(
            'render_callback' => array(new UpsellarCartBlockRenderer(), 'initial'),
        ));
    }
        
    /**
     * Register the Upsellar Related Products block.
     * 
     * @return void
     * @since 1.0.0
     */
    public function upsellar_register_upsellar_related_products_block() {
        if ( \WP_Block_Type_Registry::get_instance()->is_registered('woocommerce/related-products') ) {
            unregister_block_type('woocommerce/related-products');
        }

        register_block_type('woocommerce/related-products', array(
            'render_callback' => array(new UpsellarRelatedProductsBlockRenderer(), 'initial'),
        ));
    }

}