<!-- src/Admin/views/admin-settings.php -->

<?php 
if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly
}
?>

<div class="wrap">
    <h1>Upsellar Settings</h1>
    <!-- Check if the transient is set and display a success message -->
    <?php if (get_transient('upsellar_import_success')) : ?>
        <div class="notice notice-success is-dismissible">
            <p>Existing sales data imported successfully.</p>
        </div>
        <?php delete_transient('upsellar_import_success'); ?>
    <?php endif; ?>
    
    <!-- Check if the transient is set and display a success message -->
    <?php if (get_transient('upsellar_sync_products_success')) : ?>
        <div class="notice notice-success is-dismissible">
            <p>Products synced successfully.</p>
        </div>
        <?php delete_transient('upsellar_sync_products_success'); ?>
    <?php endif; ?>

    <div id="poststuff">
        <div id="post-body" >
            <!-- Settings Card -->
            <div id="post-body-content">
                <div class="postbox">
                   
                    <h2 class="hndle " ><span>API Settings</span>
                
                        <?php
                        // Inside your admin form view
                        $testResult = get_transient('upsellar_api_key_test_result');
                        if ($testResult !== false) {
                            $style = 'margin-left:10px;padding: 2px;padding-left: 8px;padding-right: 8px; border-radius: 2px; ';

                            if ($testResult === 'success') {
                                $style .= 'background-color: #dcfce7; color: #22c55e;';
                            } else {
                                $style .= 'background-color: #fee2e2; color: #ef4444;';
                            }

                            echo '<span style="' . esc_attr($style) . '">Connection: <span class="upsellar_connection_status">' . esc_html($testResult) . '</span></span>';
                        }
                        ?>
                    </h2>
                    <div class="inside">
                        <p>You CANNOT use keys for multiple sites. If you do, the wrong product ID's will be recorded and retrieved, which will invalidate all of the results. Please make sure you are using the key from the correct site if you have multiple on your account on <a href="https://upsellar.com">upsellar.com</a>.</p>
                    
                        <form method="post" action="options.php">
                            <?php settings_fields('upsellar_settings'); ?>
                            <?php do_settings_sections('upsellar_settings'); ?>
                            <table class="form-table">
                                <tr valign="top">
                                    <th scope="row">API Key</th>
                                    <td><input type="password" name="upsellar_api_key" value="*****" /></td>
                                </tr>
                            </table>
                            <input type="submit" class="button button-primary" value="Save API Key" />
                        </form>
                    </div>
                </div>
            </div>
            <!-- / Settings card -->

            <!-- Upload Existing Data Card -->
            <div id="postbox-container-1" class="postbox-container">
                <div class="postbox">
                    <h2 class="hndle"><span>Upload Existing Sales Data</span></h2>
                    <div class="inside">
                        <form method="post"  action="<?php echo esc_url(admin_url('admin.php?page=upsellar-settings')); ?>">
                            <?php wp_nonce_field('upsellar_import_nonce', 'upsellar_import_nonce_field'); ?>
                            <p>This function only needs to be run the first time you load the plugin, but isn't required. This will help us start training the model and creating recommendations based on past sales. Data that is collected moving forward will refine the model.</p>
                            <input type="hidden" name="upsellar_import_sales_data" value="1" />
                            <input type="submit" class="button button-primary" value="Upload Sales Data" />
                        </form>

                    </div>
                </div>
            </div>
            <!-- / Upload Existing Data Card -->

            <!-- Sync Products Card -->
            <div id="postbox-container-1" class="postbox-container">
                <div class="postbox">
                    <h2 class="hndle"><span>Sync Products with Upsellar</span></h2>
                    <div class="inside">
                        <form method="post" action="<?php echo esc_url(admin_url('admin.php?page=upsellar-settings')); ?>">
                            <?php wp_nonce_field('upsellar_sync_products_nonce', 'upsellar_sync_products_nonce_field'); ?>
                            <input type="hidden" name="upsellar_sync_products" value="1" />
                            <p>This function will sync all your products with Upsellar. If you're experiencing issues with products not showing up, try running this function again.</p>
                            <input type="submit" class="button button-primary" value="Sync Products Now"  />
                        </form>
                    </div>
                </div>
            </div>
            <!-- / Sync Products Card -->

        </div>
    </div>
</div>
