<!-- src/Admin/views/admin-dashboard.php -->

<?php 
if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly
}
?>

<div class="wrap">
    <h1>Upsellar Dashboard</h1>
    <?php 
    // Check for and display any error messages
    if ($errorMessage = get_transient('upsellar_dashboard_error')): ?>
        <div class="notice notice-error">
            <p><?php echo esc_html($errorMessage); ?></p>
        </div>
        <?php delete_transient('upsellar_dashboard_error'); ?>
    <?php else: 
        // Display charts only if there is no error
    ?>
    
        <!-- CTR Chart Card -->
        <div class="postbox">
            <div class="inside">
                <h2 class="hndle">Click Through Rate</h2>
                <canvas id="ctrChart"></canvas>
            </div>
        </div>

        <!-- Recommendation Logs Chart Card -->
        <div class="postbox">
            <div class="inside">
                <h2 class="hndle">Recommendation Logs</h2>
                <canvas id="recommendationLogsChart"></canvas>
            </div>
        </div>

    <?php endif; ?>
</div>
