<!-- src/Admin/views/admin-appearance.php -->

<?php 
if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly
}
?>

<div class="wrap">
    <h1>Upsellar Appearance Settings</h1>
    <form method="post" action="options.php">
        <?php settings_fields('upsellar_appearance_options'); ?>
        <?php do_settings_sections('upsellar_appearance_options'); ?>

        <div id="poststuff">
            <div id="post-body" >
                <!-- Settings Card -->
                <div id="post-body-content">
                    <div class="postbox">
                        <h2>Product Page Settings</h2>
                        <div class="inside">

                            <table class="form-table">
                                <tr valign="top">
                                    <th scope="row">Display product page recommendations:</th>
                                    <td>
                                        <input type="checkbox" name="upsellar_product_page_display" value="1" <?php echo (get_option(\Upsellar\Admin\UpsellarSettingsManager::PRODUCT_PAGE_DISPLAY, true) == true) ? 'checked' : ''; ?> />
                                    </td>
                                </tr>
                                <tr valign="top">
                                    <th scope="row">Number of Columns:</th>
                                    <td>
                                        <input type="number" name="upsellar_product_page_columns" value="<?php echo esc_attr(get_option('upsellar_product_page_columns')); ?>"  min="1" max="5" />
                                    </td>
                                </tr>
                                <tr valign="top">
                                    <th scope="row">Number of Rows:</th>
                                    <td>
                                        <input type="number" name="upsellar_product_page_rows" value="<?php echo esc_attr(get_option('upsellar_product_page_rows')); ?>" min="1" max="3" />
                                    </td>
                                </tr>
                            </table>
                        </div>
                    </div>
                    <div class="postbox">

                        <h2>Cart Cross-Sells Settings</h2>
                        <div class="inside">

                            <table class="form-table">
                                <tr valign="top">
                                    <th scope="row">Display cart page recommendations:</th>
                                    <td>
                                        <input type="checkbox" name="upsellar_cart_cross_sells_display" value="1" <?php echo (esc_attr(get_option('upsellar_cart_cross_sells_display')) == true) ? 'checked' : ''; ?>  />
                                    </td>
                                </tr>
                                <tr valign="top">
                                    <th scope="row">Number of Columns:</th>
                                    <td>
                                        <input type="number" name="upsellar_cart_cross_sells_columns" value="<?php echo esc_attr(get_option('upsellar_cart_cross_sells_columns')); ?>" min="1" max="5" />
                                    </td>
                                </tr>
                                <tr valign="top">
                                    <th scope="row">Number of Rows:</th>
                                    <td>
                                        <input type="number" name="upsellar_cart_cross_sells_rows" value="<?php echo esc_attr(get_option('upsellar_cart_cross_sells_rows')); ?>" min="1" max="3" />
                                    </td>
                                </tr>
                            </table>
                        </div>

                    </div>
                    <?php submit_button(); ?>

                </div>
            </div>
        </div>
    </form>
</div>
