<?php 

namespace Upsellar\Admin;

if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly
}

class UpsellarHttpsEnforcer {
    private $main_plugin_file;

    /**
     * HTTPS Enforcer constructor.
     * @param $main_plugin_file string Main plugin file path.
     * @return void
     * @since  1.0.0
     */
    public function __construct($main_plugin_file) {
        $this->main_plugin_file = $main_plugin_file;
    }

    /**
     * Displays a warning message on the admin dashboard if the site is not using HTTPS.
     * @return void
     * @since  1.0.0
     */
    public function upsellar_enforce_https() {
        if (!is_ssl()) {
            add_action('admin_notices', [$this, 'sslWarning']);
            deactivate_plugins(plugin_basename($this->main_plugin_file));
        }
    }

    /**
     * Checks if the site is using SSL when activating the plugin and deactivates it if not.
     * 
     * @return void
     * @since  1.0.0
     */
    public function upsellar_check_on_activation() {
        if (!is_ssl()) {
            deactivate_plugins(plugin_basename($this->main_plugin_file));
            wp_die('This plugin requires HTTPS to be enabled on your site.');
        }
    }

    /**
     * Displays a warning message in the admin dashboard if the site is not using HTTPS.
     * @return void
     * @since  1.0.0
     */
    public function sslWarning() {
        echo '<div class="notice notice-warning"><p><strong>Warning:</strong> This plugin requires HTTPS to be enabled on your site.</p></div>';
    }
}
