<?php 

namespace Upsellar\Admin;

if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly
}

class UpsellarConfigLoader {
    private $config;

    /**
     * UpsellarConfigLoader constructor.
     * 
     * @param string $environment Environment to load config for. Defaults to 'prod'.
     * 
     * @return void
     * @since 1.0.0
     */
    public function __construct($environment = 'prod') {
        $pluginBaseDir = plugin_dir_path(__DIR__ . '/../../../');
        $configFile = $pluginBaseDir . 'config/' . $environment . '.json';

        if (file_exists($configFile)) {
            $this->config = json_decode(file_get_contents($configFile), true); // Note: Using file_get_contents() since we're retrieving a local file. wp_remote_get() wouldn't make sense here.

        } else {
            $this->config = [];
            // Handle the error or set default configuration
        }
    }

    /**
     * Get a config value by key.
     * 
     * @param string $key Key to get value for.
     * @param mixed $default Default value to use if key does not exist.
     * @return mixed Value for key or default if not found.
     * @since 1.0.0
     */
    public function upsellar_get_config_value($key, $default = null) {
        return isset($this->config[$key]) ? $this->config[$key] : $default;
    }
}
