<?php 

namespace Upsellar\Admin;

if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly
}

class UpsellarAssetManager {

    /**
     * Enqueues the scripts for public facing pages only.
     * 
     * @return void
     * @since 1.0.0
     */
    public function upsellar_enqueue_scripts() {
        if (!is_admin()) {

            $plugin_url = plugin_dir_url(dirname(dirname(__FILE__)));
            $js_url = $plugin_url . 'assets/js/upsellar.js';
        
            wp_enqueue_script(
                'upsellar-script',
                $js_url,
                array(),
                '1.0.0',
                true
            );
        
            $nonce = wp_create_nonce('upsellar_track_product_interaction_nonce');

            $script_data = array(
                'nonceToken' => $nonce,
            );

            if (is_product()) {
                // Get the current product ID
                $product_id = get_the_ID();
                // Add the product ID to the script data
                $script_data['productId'] = $product_id;

            }
        
            wp_localize_script('upsellar-script', 'upsellarData', $script_data);
        }
    }
    
    /**
     * Enqueues the styles for public facing pages only.
     * 
     * @return void
     * @since 1.0.0
     */
    public function upsellar_enqueue_styles() {
        if (!is_admin()) {

            // Enqueue a CSS file
            $plugin_url = plugin_dir_url(dirname(dirname(__FILE__)));
            $css_url = $plugin_url . 'assets/css/app.css';

            wp_enqueue_style(
                'upsellar-style', // Handle for the stylesheet
                $css_url, // Corrected path to the stylesheet
                array(), // Dependencies
                '1.0.0' // Version number
            );
        }
    }

    /**
     * Enqueues the scripts for admin pages only.
     * 
     * @return void
     * @since 1.0.0
     */
    public function upsellar_admin_enqueue_scripts($hook) {

        // // Only load scripts on the Upsellar Dashboard page
        // if ($hook !== 'toplevel_page_upsellar-dashboard') {
        //     return;
        // }

        // Enqueue Chart.js library
        // wp_enqueue_script('chart-js', 'https://cdn.jsdelivr.net/npm/chart.js', array(), '4.0.1', true);

        // Enqueue your admin.js file
        $plugin_url = plugin_dir_url(dirname(dirname(__FILE__)));
        $js_url = $plugin_url . 'assets/js/admin.js';

        wp_enqueue_script(
            'upsellar-scripts-admin', // Handle for the admin scripts
            $js_url, // Corrected path to the admin scripts
            array(), // Dependencies
            '1.0.0', // Version number
            true
        );

        // // Prepare data for localization
        // $dashboardData = get_transient('upsellar_dashboard_data');

        // print_r($dashboardData);

        // // Ensure $dashboardData is available and has the expected structure
        // if ($dashboardData && is_array($dashboardData)) {
        //     // Initialize variables
        //     $ctrData = array();
        //     $ctrLabels = array();
        //     $recommendationLogsData = array();
        //     $recommendationLogsLabels = array();

        //     // Process ctrData
        //     foreach($dashboardData['ctrData'] as $key => $value){
        //         $ctrLabels[] = $key;
        //         $ctrData['data'][] = $value;
        //     }
        //     $ctrData['tension'] = 0.4;

        //     // Process recommendationLogsData
        //     foreach($dashboardData['recommendationLogsData'] as $key => $value){
        //         $recommendationLogsLabels[] = $key;
        //         $recommendationLogsData['data'][] = intval($value);
        //     }
        //     $recommendationLogsData['tension'] = 0.4;

        //     // Prepare chart data for localization
        //     $chartData = array(
        //         'ctrLabels' => $ctrLabels,
        //         'ctrData' => $ctrData,
        //         'recommendationLogsLabels' => $recommendationLogsLabels,
        //         'recommendationLogsData' => $recommendationLogsData,
        //     );
        // } else {
        //     // Fallback to empty data if the transient is not set
        //     $chartData = array(
        //         'ctrLabels' => [],
        //         'ctrData' => [],
        //         'recommendationLogsLabels' => [],
        //         'recommendationLogsData' => [],
        //     );
        // }

        // echo "Chart Data: ";
        // print_r($chartData);

        // Localize script with chart data
        // wp_localize_script('upsellar-scripts-admin', 'upsellarChartData', $chartData);
    }

    /**
     * Enqueues the styles for admin pages only.
     * 
     * @return void
     * @since 1.0.0
     */
    public function upsellar_admin_enqueue_styles() {
        // Enqueue a CSS file
        $plugin_url = plugin_dir_url(dirname(dirname(__FILE__)));
        $css_url = $plugin_url . 'assets/css/admin.css';

        wp_enqueue_style(
            'upsellar-style', // Handle for the stylesheet
            $css_url, // Corrected path to the stylesheet
            array(), // Dependencies
            '1.0.0' // Version number
        );
    }

    /**
     * Enqueues the scripts for Gutenberg editor only.
     * 
     * @return void
     * @since 1.0.0
     */
    // function blockEditorEnqueueScripts() {
        
    //     $plugin_url = plugin_dir_url(dirname(dirname(__FILE__)));
    //     $js_url = $plugin_url . 'assets/js/gutenberg-block.js';

    //     wp_enqueue_script(
    //         'upsellar-block',
    //         $js_url,
    //         array( 'wp-blocks', 'wp-element', 'wp-components' )
    //     );


    // }
    
}
