<?php
/**
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

if ( $product_ids ) : ?>

<!--  -->
<div data-block-name="woocommerce/cart-cross-sells-block" class="cross-sells">
	<div class="wp-block-query is-layout-flow wp-block-query-is-layout-flow">
		<h2 class="wp-block-heading has-large-font-size"><?php echo esc_html__('You may be interested in...', 'upsellar'); ?></h2>
		<div class="w-full grid grid-cols-1 md:grid-cols-<?php echo esc_attr( $columns ) ?> gap-4">
    
		<?php 
		foreach ($product_ids as $product_id) {
			$product = wc_get_product($product_id);
			if ($product) {
        
				$post_object = get_post($product_id);
            
				setup_postdata($GLOBALS['post'] =& $post_object); // phpcs:ignore WordPress.WP.GlobalVariablesOverride.Prohibited, Squiz.PHP.DisallowMultipleAssignments.Found
            
        
				// Start output buffering
				//wc_get_template_part('content', 'product');
				$productIdClass = "post-" . $product->get_id();

				?>

				<div class='product upsellar-card <?php echo esc_attr($productIdClass); ?> relative flex flex-wrap justify-center text-center'>

				<?php 
				ob_start();
				echo wp_kses_post(woocommerce_template_loop_product_link_open());
				echo wp_kses_post(ob_get_clean());

				if($product->is_on_sale()){
				?>
					<div class='absolute top-1 right-1 capitalized py-1 px-2 font-semibold text-gray-500 border border-gray-500 gray-500 bg-white rounded ' style=''>
						<span aria-hidden='true'><?php echo esc_html__('Sale', 'upsellar'); ?></span>
						<span class='screen-reader-text'><?php echo esc_html__('Product on sale', 'upsellar'); ?></span>
					</div>
				<?php
				}
				?>
        
				<div class='mb-4 w-full'>
				<?php 
				echo wp_kses_post(woocommerce_get_product_thumbnail('woocommerce_single'));
				?>

				</div>


				<div class='mb-4'>
				<div class='mb-4'>
					<?php
				ob_start();
				echo wp_kses_post(woocommerce_template_loop_product_title());
				echo wp_kses_post(woocommerce_template_loop_price());
				echo wp_kses_post(ob_get_clean());

				?>

				</div>

				<?php

				ob_start();
				echo wp_kses_post(woocommerce_template_loop_product_link_close());
				echo wp_kses_post(woocommerce_template_loop_add_to_cart());
				echo wp_kses_post(ob_get_clean());

				?>

					</div>

				</div>
				
			<?php

			}
		}
    
		?>
    
       </div>
	</div>
</div>

	<?php
endif;

wp_reset_postdata();
