
(function() {

    var nonceToken = upsellarData.nonceToken; // Nonce token from upsellarData
    var currentProductId = upsellarData.productId; // Nonce token from upsellarData
    var startTime = {}; // Store start time for each product
    var shownProducts = {}; // Store shown products for the current page view

    function sendDataToWordPress(data) {
        return new Promise((resolve, reject) => {
            var xhr = new XMLHttpRequest();
            xhr.open("POST", "/WoocommerceRecommendationPlugin/wp-admin/admin-ajax.php", true); // WordPress AJAX handler
            xhr.setRequestHeader("Content-Type", "application/x-www-form-urlencoded");
            xhr.setRequestHeader("X-Requested-With", "XMLHttpRequest");
    
            // Extend data with action and nonce for WordPress
            data.nonce = nonceToken;
            
            var formData = new URLSearchParams();
            for (var key in data) {
                formData.append(key, data[key]);
            }
    
            xhr.onreadystatechange = function() {
                if (xhr.readyState === 4) {
                    if (xhr.status >= 200 && xhr.status < 300) {
                        resolve(xhr.responseText);
                    } else {
                        reject(new Error('Status Code: ' + xhr.status + ' ' + xhr.statusText));
                    }
                }
            };
    
            xhr.onerror = function() {
                reject(new Error('Network Error'));
            };
    
            xhr.send(formData);
        });
    }

    //
    function trackInteraction(data) {


        // Extend data with action and nonce for WordPress
        data.action = 'upsellar_track_product_interaction_js';
        
        sendDataToWordPress(data);
    }

    function processUpsellarBlocks(block) {
    
        var productIds = JSON.parse(block.getAttribute('data-product-ids'));
        var limit = block.getAttribute('data-limit');
        var type = block.getAttribute('data-type');
    
        var data = {
            action: 'fetch_upsellar_blocks',
            product_ids: productIds,
            limit: limit,
            type: type,
        };

        block.classList.remove('unrendered'); // Remove the 'unrendered' class
    
        sendDataToWordPress(data)
            .then(html => {
                block.innerHTML = html;
                initializeTracking();

            })
            .catch(error => {
                //console.error('Fetch Error:', error.message);
                //block.innerHTML = '<p>Error loading products.</p>';
            });
    }
    
    function processAllUpsellarBlocks() {
        var blocks = document.querySelectorAll('.upsellar-block.unrendered');
        if (blocks.length > 0) {
            blocks.forEach(processUpsellarBlocks);
        }
    }
    
    // Check for the existence of .upsellar-block elements every 100ms
    var checkExist = setInterval(function() {
        processAllUpsellarBlocks();
    }, 100);
    
    // Optional: Clear the interval after a certain condition is met (e.g., after a certain time)
    setTimeout(function() { clearInterval(checkExist); }, 10000); // Stop checking after 10 seconds

    // Initialize tracking when the page loads
    window.onload = function() {
        initializeTracking();
    };

    function initializeTracking() {
        // Start observing each product card
        var products = document.querySelectorAll('.product');
        products.forEach(product => {
            observer.observe(product);
        });

        // Attach upsellar observer to upsellar cards
        var upsellarCards = document.querySelectorAll('.upsellar-card');
        upsellarCards.forEach(card => {
            upsellarObserver.observe(card);
            attachClickEventListener(card);
        });
    }

    // Function to track product view
    function trackProductShow(productId) {
        trackInteraction({
            productId: productId,
            actionType: 'show',
            timestamp: new Date().toISOString()
        });
    }

    // Function to track product view
    function trackProductImpression(productId) {

        if (!shownProducts[productId]) {

            shownProducts[productId] = true; // Mark the product as shown
            trackInteraction({
                productId: productId,
                actionType: 'impression',
                timestamp: new Date().toISOString()
            });
        }
    }

    // Function to track time spent viewing a product
    function trackTimeShown(productId, duration) {
        trackInteraction({
            productId: productId,
            actionType: 'time_shown',
            parameter: duration,
            timestamp: new Date().toISOString()
        });
    }

    // Function to check if the current page is a product page
    function isProductPage() {
        // Return true if currentProductId is set, else false
        return currentProductId != null;
    }

    // Function to track the duration of product page view
    function trackProductPageView(productId) {
        var currentTime = new Date();
        var duration = Math.round((currentTime - pageStartTime) / 1000); // Duration in seconds
        trackInteraction({
            productId: productId,
            actionType: 'time_viewed',
            parameter: duration,
            timestamp: new Date().toISOString()
        });
    }

    // Page view tracking logic only for product pages
    if (isProductPage()) {
        var pageStartTime = new Date(); // Start time for the product page view

        window.addEventListener('beforeunload', function() {
            trackProductPageView(currentProductId); // Track the product page view duration
        });
    }

    // Function to handle unloading of the page
    function handlePageUnload() {
        var currentTime = new Date();
        for (var productId in startTime) {
            if (startTime.hasOwnProperty(productId)) {
                var duration = Math.round((currentTime - startTime[productId]) / 1000);
                trackTimeShown(productId, duration);
            }
        }
    }

    // Register the beforeunload event listener
    window.addEventListener('beforeunload', handlePageUnload);

    // Observer for detecting product card visibility
    var observer = new IntersectionObserver(function(entries, observer) {
        entries.forEach(entry => {
            var productClassMatch = entry.target.className.match(/post-(\d+)/);
            var productId = entry.target.classList.contains('product') && productClassMatch ? productClassMatch[1] : null;
    
            if (!productId) return;

            if (entry.isIntersecting) {
                startTime[productId] = new Date();
                trackProductShow(productId);
            } else if (startTime[productId]) {
                var endTime = new Date();
                var duration = Math.round((endTime - startTime[productId]) / 1000); // Time in seconds
                trackTimeShown(productId, duration);
                delete startTime[productId];
            }
        });
    }, { threshold: [0.5] });

    // Observer for upsellar card visibility (impression tracking)
    var upsellarObserver = new IntersectionObserver(function(entries) {
        entries.forEach(entry => {

            var productClassMatch = entry.target.className.match(/post-(\d+)/);
            var productId = entry.target.classList.contains('product') && productClassMatch ? productClassMatch[1] : null;
    
            if (!productId) return;

            if (entry.isIntersecting && !shownProducts[productId]) {
                trackProductImpression(productId);
            }
        });
    }, { threshold: [0.5] });


    function attachClickEventListener(card) {
        // This ensures the event listener is associated with the specific card
        card.addEventListener('click', function(event) {
            // Stop the event from bubbling up to avoid triggering other handlers
            event.stopPropagation();

            // Extract product ID from the card's class or data attribute
            var productClassMatch = this.className.match(/post-(\d+)/);
            var productId = productClassMatch ? productClassMatch[1] : null;
            if (!productId) return;

            // Track the click for the specific product
            trackProductClick(productId);
        });
    }


    // Function to track product card click
    function trackProductClick(productId) {
        trackInteraction({
            productId: productId,
            actionType: 'click',
            timestamp: new Date().toISOString()
        });
    }


})();
