( function( wp ) {
    var registerBlockType = wp.blocks.registerBlockType;
    var el = wp.element.createElement;
    var SelectControl = wp.components.SelectControl;

    registerBlockType( 'upsellar/upsellar-block', {
        title: 'Upsellar Block',
        icon: 'cart',
        category: 'widgets',

        attributes: {
            recommendationType: {
                type: 'string',
                default: 'view'
            },
        },

        edit: function( props ) {
            function onChangeRecommendationType(newValue) {
                props.setAttributes({ recommendationType: newValue });
            }

            return el( 'div', {},
                el( SelectControl, {
                    label: 'Recommendation Type',
                    value: props.attributes.recommendationType,
                    options: [
                        { label: 'Related Products', value: 'related_products' },
                        { label: 'Popular Products', value: 'popular_products' },
                        { label: 'Related Products (Same Category)', value: 'related_products_same_category' },
                        { label: 'Cart Cross-Sell', value: 'cart_cross_sell' }
                    ],
                    onChange: onChangeRecommendationType
                } )
            );
        },

        save: function() {
            return null; // Dynamic block, rendered with PHP.
        },
    } );
} )( window.wp );
