// admin.js

import Chart from 'chart.js/auto'; 

window.Chart = Chart; 

document.addEventListener('DOMContentLoaded', function () {
    
    // Ensure upsellarChartData is available
    if (typeof upsellarChartData !== 'undefined') {
        
        // CTR Chart
        var ctx = document.getElementById('ctrChart').getContext('2d');
        var ctrChart = new Chart(ctx, {
            type: 'line',
            data: {
                labels: upsellarChartData.ctrLabels,
                datasets: upsellarChartData.ctrData
            },
            options: {
                plugins: {
                    legend: {
                        display: false
                    }
                },
                scales: {
                    x: {
                        border: {
                            display: false
                        },
                        ticks: {
                            color: "#6b7280"
                        },
                        grid: {
                            display: false
                        }
                    },
                    y: {
                        title: {
                            display: true,
                            text: "Percentage"
                        },
                        border: {
                            display: true,
                            dash: [2, 4]
                        },
                        ticks: {
                            color: "#6b7280"
                        },
                        beginAtZero: true,
                        grid: {
                            display: true,
                            color: "#6b7280",
                            dash: [2, 4]
                        }
                    }
                }
            }
        });

        // Recommendation Logs Chart
        var ctx2 = document.getElementById('recommendationLogsChart').getContext('2d');
        var recommendationLogsChart = new Chart(ctx2, {
            type: 'line',
            data: {
                labels: upsellarChartData.recommendationLogsLabels,
                datasets: upsellarChartData.recommendationLogsData
            },
            options: {
                plugins: {
                    legend: {
                        display: false
                    }
                },
                scales: {
                    x: {
                        border: {
                            display: false
                        },
                        ticks: {
                            color: "#6b7280"
                        },
                        grid: {
                            display: false
                        }
                    },
                    y: {
                        title: {
                            display: true,
                            text: "Requests"
                        },
                        border: {
                            display: true,
                            dash: [2, 4]
                        },
                        ticks: {
                            color: "#6b7280"
                        },
                        beginAtZero: true,
                        grid: {
                            display: true,
                            color: "#6b7280",
                            dash: [2, 4]
                        }
                    }
                }
            }
        });
    } else {
        console.error('upsellarChartData is not defined.');
    }
});
