<?php
/**
 * Single Product Rating
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/single-product/rating.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see     https://docs.woocommerce.com/document/template-structure/
 * @package WooCommerce\Templates
 * @version 3.6.0
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

global $product;

if ( ! wc_review_ratings_enabled() ) {
	return;
}

/**
 * WooCommerce Global Product Variable.
 *
 * @var WC_Product $product
 */
$rating_count = (int) $product->get_rating_count();
$review_count = (int) $product->get_review_count();
$average      = (float) $product->get_average_rating();

/*
	Use untappd ratings instead WooCommerce one's.
*/

$urwc_ratings_enabled = urwc_ratings_enabled();

if ( $urwc_ratings_enabled ) {
	$urwc_beer_link         = '#reviews';
	$urwc_ratings_show_text = '';

	$urwc_beer_id = absint( filter_var( $product->get_meta( '_urwc_beer_id', true ), FILTER_VALIDATE_INT ) );

	if ( $urwc_beer_id > 0 ) {
		$product_id = $product->get_id();

		$urwc_product_meta = URWC_Product::get_product_meta( $urwc_beer_id, $product_id );

		if ( ! $urwc_product_meta instanceof URWC_Error ) {
			if ( isset( $urwc_product_meta['_urwc_rating_count'] ) && isset( $urwc_product_meta['_urwc_average_rating'] ) ) {
				$rating_count           = absint( filter_var( $urwc_product_meta['_urwc_rating_count'], FILTER_VALIDATE_INT ) );
				$average                = filter_var( $urwc_product_meta['_urwc_average_rating'], FILTER_VALIDATE_FLOAT );
				$urwc_ratings_show_text = ( urwc_show_text() && $average ) ? number_format_i18n( $average, 2 ) . '/' . number_format_i18n( 5 ) : '';
			}

			if ( isset( $urwc_product_meta['_urwc_beer_slug'] ) ) {
				$urwc_beer_slug = filter_var( $urwc_product_meta['_urwc_beer_slug'], FILTER_SANITIZE_URL );
				$urwc_beer_link = ( $urwc_beer_slug ) ? 'https://untappd.com/b/' . $urwc_beer_slug . '/' . (string) $urwc_beer_id : '';
			}
		}
	}

	/* translators: %s rating: Total ratings */
	$urwc_rating_text = sprintf( _n( '%s rating', '%s ratings', $rating_count, 'untappd-ratings-for-woocommerce' ), $rating_count );
} else {
	/* translators: %s customer review: Total customer reviews */
	$urwc_rating_text = sprintf( _n( '%s customer review', '%s customer reviews', $review_count, 'untappd-ratings-for-woocommerce' ), $review_count );
}

/**
 * We can ignore warnings related to wc_get_rating_html since all output data is generated securely by Woo.
 */
if ( $urwc_ratings_enabled && $rating_count > 0 && $average ) : ?>
	<div class="woocommerce-product-rating">
		<div><?php esc_html_e( 'Untappd Ratings', 'untappd-ratings-for-woocommerce' ); ?></div>
			<?php echo wc_get_rating_html( $average, $rating_count ); //phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped ?><span class="urwc-review-text"><?php echo esc_html( $urwc_ratings_show_text ); ?></span>
			<?php if ( urwc_show_total() ) : ?>
			<a target="_blank" href="<?php echo esc_attr( $urwc_beer_link ); ?>" class="woocommerce-review-link" rel="noopener noreferer"><span class="count">(<?php echo esc_html( $urwc_rating_text ); ?>)</span></a> 
			<?php endif; ?>
		</div>

<?php elseif ( $rating_count > 0 && $average ) : ?>

	<div class="woocommerce-product-rating">
		<?php echo wc_get_rating_html( $average, $rating_count ); //phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped ?>
		<?php if ( comments_open() ) : ?>
			<a href="#reviews" class="woocommerce-review-link" rel="nofollow"><span class="count">(<?php echo esc_html( $urwc_rating_text ); ?>)</span></a>
		<?php endif ?>
	</div>

<?php endif; ?>
