<?php
/**
 * URWC_Error
 *
 * @author    ChillCode
 * @copyright Copyright (c) 2003, ChillCode All rights reserved.
 * @license   http://www.gnu.org/licenses/gpl-3.0.html GNU General Public License v3.0
 * @package   Untappd Ratings for WooCommerce
 */

defined( 'ABSPATH' ) || exit;

/**
 * URWC_Error class.
 */
class URWC_Error extends Exception {

	/**
	 * Error code.
	 *
	 * @var int
	 */
	protected $error_code;

	/**
	 * Constructor
	 *
	 * @param int    $error_code       Error code.
	 * @param string $error_message    Error message.
	 */
	public function __construct( $error_code, $error_message ) {
		$this->error_code = (int) $error_code;

		parent::__construct( $error_message, (int) $error_code );
	}

	/**
	 * Get error code.
	 *
	 * @return int
	 */
	public function getErrorCode(): int {
		return $this->error_code;
	}
}
