<?php
if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

// Unplug REST API endpoints for queue progress
add_action('rest_api_init', function () {
    register_rest_route('unplug/v1', '/queue-progress/(?P<id>\\d+)', array(
        'methods' => 'GET',
        'callback' => function ($request) {
            global $wpdb;
            require_once __DIR__ . '/class-unplug-database.php';
            $table = UNPLUG_Database::get_table_name('queue');
            $task_id = intval($request['id']);
            // phpcs:ignore WordPress.DB.DirectDatabaseQuery.DirectQuery,WordPress.DB.DirectDatabaseQuery.NoCaching -- Plugin-specific queue table query
            $task = $wpdb->get_row($wpdb->prepare("SELECT * FROM %s WHERE id = %d", $table, $task_id), ARRAY_A);
            if (!$task) {
                return new WP_Error('not_found', 'Task not found', array('status' => 404));
            }
            return array(
                'id' => $task['id'],
                'status' => $task['status'],
                'progress_percent' => intval($task['progress_percent']),
                'last_update' => $task['last_update'],
                'progress_log' => maybe_unserialize($task['progress_data']),
            );
        },
        'permission_callback' => function () {
            return current_user_can('manage_options'); // Adjust as needed
        }
    ));
}); 