<?php
if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

/**
 * Fired during plugin activation
 *
 * @link       https://mulberrytech.ca/unplug
 * @since      1.0.0
 *
 * @package    Unplug
 * @subpackage Unplug/includes
 */

/**
 * Fired during plugin activation.
 *
 * This class defines all code necessary to run during the plugin's activation.
 *
 * @since      1.0.0
 * @package    Unplug
 * @subpackage Unplug/includes
 * @author     Mulberry <support@mulberrytech.ca>
 */
class UNPLUG_Activator {

    /**
     * Short Description. (use period)
     *
     * Long Description.
     *
     * @since    1.0.0
     */
    public static function activate() {
        // Create database tables
        self::create_tables();
        
        // Set default options
        self::set_default_options();
        
        // Create upload directory if needed
        self::create_upload_directory();
        
        // Set plugin version
        update_option( 'unplug_version', UNPLUG_VERSION );
    }

    /**
     * Create plugin database tables.
     *
     * @since    1.0.0
     */
    private static function create_tables() {
        // Load database helper class
        require_once plugin_dir_path( dirname( __FILE__ ) ) . 'includes/class-unplug-database.php';
        
        // Create all tables using the database helper
        UNPLUG_Database::create_tables();
    }

    /**
     * Set default plugin options.
     *
     * @since    1.0.0
     */
    private static function set_default_options() {
        // Load options helper class
        require_once plugin_dir_path( dirname( __FILE__ ) ) . 'includes/class-unplug-options.php';
        
        // Initialize all plugin options with defaults and validation
        UNPLUG_Options::init_options();
    }

    /**
     * Create upload directory for plugin files.
     *
     * @since    1.0.0
     */
    private static function create_upload_directory() {
        $upload_dir = wp_upload_dir();
        $unplug_dir = trailingslashit( $upload_dir['basedir'] ) . 'unplug';

        if ( ! file_exists( $unplug_dir ) ) {
            wp_mkdir_p( $unplug_dir );
            
            // Create .htaccess file to protect directory using WordPress file system
            $htaccess_content = "Order deny,allow\nDeny from all\n";
            
            // Initialize WordPress file system
            global $wp_filesystem;
            if ( empty( $wp_filesystem ) ) {
                require_once ABSPATH . '/wp-admin/includes/file.php';
                WP_Filesystem();
            }
            
            $wp_filesystem->put_contents( trailingslashit( $unplug_dir ) . '.htaccess', $htaccess_content );
        }
    }
} 