jQuery(document).ready(function($) {

    // -----------------------
    // Tab Switching 
    // -----------------------
    const $tabs = $('.unlocktoview-tab-wrapper a.unlocktoview-tab');
    const $contents = $('.tab-content');
    
    // Activate first tab if none active
    let $active = $tabs.filter('.unlocktoview-tab-active');
    if (!$active.length) $active = $tabs.first().addClass('unlocktoview-tab-active');
    
    // Show content for active tab
    const targetId = $active.attr('href');
    if (targetId && $(targetId).length) {
        $contents.hide();
        $(targetId).show();
    } else {
        $contents.hide(); // 👈 important: don't show all by default
    }
    
    $tabs.on('click', function(e) {
        e.preventDefault();
        const $this = $(this);
        const target = $this.attr('href');
    
        $tabs.removeClass('unlocktoview-tab-active');
        $this.addClass('unlocktoview-tab-active');
    
        $contents.hide();
        if ($(target).length) $(target).fadeIn(200);
    });

    // -----------------------
    // Toggle Admin Email Field
    // -----------------------
    const $checkbox = $('input[name="unlocktoview_options[notify_admin]"]');
    const $emailWrap = $('.admin-email-wrap');

    function toggleEmail() {
        if ($checkbox.is(':checked')) {
            $emailWrap.show();
        } else {
            $emailWrap.hide().find('input[type="email"]').val('');
        }
    }
    toggleEmail();
    $checkbox.on('change', toggleEmail);

    // -----------------------
    // Global Defaults
    // -----------------------
    const defaults = window.unlocktoview_admin_ajax || {};
    const price    = defaults.price || '';
    const currency = defaults.currency || '';
    const duration = defaults.duration || '';
    const payment  = defaults.payment_link || '';
    const siteName = defaults.site_name || '';
    const defaultBuyerSubject = defaults.defaultSubject || 'Unlock video on {site_name}';

    // -----------------------
    // Buyer Email Preview + Reset
    // -----------------------
    const $buyerTextarea = $('#buyer-message-textarea');
    const $buyerPreview  = $('#buyer-preview-message pre, #buyer-preview-message');
    const $resetBuyerMsg = $('#reset-buyer-message');
    const $buyerSubject  = $('#buyer-subject');
    const $resetBuyerSubj= $('#reset-buyer-subject');

    function replacePlaceholders(msg) {
        return (msg || '')
            .replace(/\$price/g, price)
            .replace(/\$currency/g, currency)
            .replace(/\$duration/g, duration)
            .replace(/\$payment_link/g, payment)
            .replace(/\$site_name/g, siteName);
    }

    if ($buyerTextarea.length && $buyerPreview.length) {
        const defaultMsg = $buyerTextarea.data('default') || '';
        if (!$buyerTextarea.val()) $buyerTextarea.val(defaultMsg);

        $buyerTextarea.on('input', function() {
            $buyerPreview.text(replacePlaceholders($(this).val()));
        });

        $resetBuyerMsg.on('click', function(e) {
            e.preventDefault();
            $buyerTextarea.val(defaultMsg).trigger('input');
        });

        $buyerTextarea.trigger('input');
    }

    if ($buyerSubject.length && $resetBuyerSubj.length) {
        $resetBuyerSubj.on('click', function(e) {
            e.preventDefault();
            const defSubj = $buyerSubject.data('default') || defaultBuyerSubject;
            $buyerSubject.val(defSubj.replace(/\{site_name\}/g, siteName)).trigger('input');
        });
    }

    // -----------------------
    // Reminder Email Preview + Reset
    // -----------------------
    const $reminderTextarea = $('#unlocktoview_reminder_template');
    const $reminderPreview  = $('#unlocktoview_preview_message');
    const $reminderSubject  = $('#unlocktoview_reminder_subject');
    const $reminderPreviewSubj = $('#unlocktoview_preview_subject');
    const $resetReminderBtn = $('#reset-reminder-email');

    if ($reminderTextarea.length && $resetReminderBtn.length) {
        const reminderDefault = $reminderTextarea.data('default') || '';
        const reminderSubjDefault = $reminderSubject.data('default') || '';

        $resetReminderBtn.on('click', function(e) {
            e.preventDefault();
            $reminderTextarea.val(reminderDefault);
            if ($reminderPreview.length) $reminderPreview.text(reminderDefault);
            if ($reminderSubject.length) $reminderSubject.val(reminderSubjDefault);
            if ($reminderPreviewSubj.length) $reminderPreviewSubj.text(reminderSubjDefault);
        });

        $reminderTextarea.on('input', function() {
            if ($reminderPreview.length) $reminderPreview.text($(this).val());
        }).trigger('input');

        $reminderSubject.on('input', function() {
            if ($reminderPreviewSubj.length) $reminderPreviewSubj.text($(this).val());
        }).trigger('input');
    }

    // -----------------------
    // Shortcode Generator
    // -----------------------
    const $generate = $('#unlocktoview-generate-shortcode');
    const $wrapper  = $('#unlocktoview-shortcode-wrapper');
    const $result   = $('#unlocktoview-shortcode-result');
    const $copyForm = $('#unlocktoview-copy-shortcode');

    function escapeHtml(str) {
        return (str || '')
            .replace(/&/g, "&amp;")
            .replace(/</g, "&lt;")
            .replace(/>/g, "&gt;")
            .replace(/"/g, "&quot;")
            .replace(/'/g, "&#039;");
    }

    $generate.on('click', function(e) {
        e.preventDefault();

        const slug   = $('#unlocktoview_video_slug').val().trim();
        const id     = $('#unlocktoview_video_id').val().trim();
        const playerVal = $('#unlocktoview_media_player').val();
        const player = playerVal ? String(playerVal).trim() : '';

        if (!slug || !id) return alert('⚠️ Please add both Slug and Media ID/URL.');

        let shortcode = `[unlocktoview slug="${slug}" id="${id}"`;
        if (player) shortcode += ` player="${player}"`;
        shortcode += `]`;

        $result.val(shortcode);
        $wrapper.fadeIn();

        $.post(unlocktoview_admin_ajax.ajax_url, {
            action: 'unlocktoview_add_shortcode',
            _wpnonce: unlocktoview_admin_ajax.nonce,
            slug: slug,
            id: id,
            player: player
        }, function(res) {
            if (res.success) {
                const rowId = `unlocktoview-${slug}-${id}`;
                const row = `
                    <tr id="${rowId}">
                        <td>${slug}</td>
                        <td><input type="text" class="unlocktoview-shortcode-input" value="${escapeHtml(shortcode)}" readonly style="width:100%;"></td>
                        <td>
                            <button class="button unlocktoview-copy" data-target="#${rowId} .unlocktoview-shortcode-input">Copy</button>
                            <button class="button unlocktoview-delete-shortcode" data-slug="${slug}" data-id="${id}">Delete</button>
                        </td>
                    </tr>`;
                $('.widefat tbody').prepend(row);

                $('#unlocktoview_video_slug, #unlocktoview_video_id, #unlocktoview_media_player').val('');
            } else {
                console.error(res);
                alert(res.data?.message || 'Failed to add shortcode ❌');
            }
        }, 'json').fail(function(jqXHR, textStatus, errorThrown) {
            console.error('AJAX failed:', textStatus, errorThrown, jqXHR.responseText);
            alert('AJAX request failed ❌');
        });
    });

    // Copy shortcode
    $copyForm.on('click', function(e) {
        e.preventDefault();
        const text = $result.val();
        if (!text) return;

        if (navigator.clipboard && navigator.clipboard.writeText) {
            navigator.clipboard.writeText(text).then(() => showCopyMsg($(this)));
        } else {
            $result.select();
            document.execCommand('copy');
            showCopyMsg($(this));
        }

        function showCopyMsg($btn) {
            $('<span class="copy-msg" style="color:#1a7f37;margin-left:10px;">Copied!</span>')
                .insertAfter($btn)
                .fadeOut(1500, function(){ $(this).remove(); });
        }
    });

    // Copy from table
    $(document).on('click', '.unlocktoview-copy', function(e) {
        e.preventDefault();
        const $btn = $(this);
        const $input = $($btn.data('target'));
        if (!$input.length) return;

        $input.select();
        document.execCommand('copy');
        $('<span class="copy-msg" style="color:#1a7f37;margin-left:10px;">Copied!</span>')
            .insertAfter($btn)
            .fadeOut(1500, function(){ $(this).remove(); });
    });

    // Delete shortcode
    $(document).on('click', '.unlocktoview-delete-shortcode', function(e) {
        e.preventDefault();
        if (!confirm('Are you sure you want to delete this shortcode?')) return;

        const $btn = $(this);
        const slug = $btn.data('slug');
        const id   = $btn.data('id');
        const rowId = `#unlocktoview-${slug}-${id}`;

        $.post(unlocktoview_admin_ajax.ajax_url, {
            action: 'unlocktoview_delete_shortcode',
            _wpnonce: unlocktoview_admin_ajax.nonce,
            slug: slug,
            id: id
        }, function(res) {
            if (res.success) $(rowId).fadeOut(300, function() { $(this).remove(); });
            else alert(res.data?.message || 'Failed to delete shortcode ❌');
        }, 'json').fail(function() { alert('AJAX request failed ❌'); });
    });

    // -----------------------
    // Rentals Table Actions
    // -----------------------
    function handleAjax(btn, action, columnClass, successVal) {
        if (btn.prop('disabled')) return;
        const row = btn.closest('tr');
        btn.prop('disabled', true);
        $.post(unlocktoview_admin_ajax.ajax_url, {
            action: action,
            _wpnonce: unlocktoview_admin_ajax.nonce,
            email: btn.data('email'),
            video: btn.data('video')
        }, function(res) {
            if (res?.success && columnClass && successVal !== undefined) {
                row.find('.' + columnClass).text(successVal);
            } else if (!res?.success) {
                alert(res?.data?.message || 'AJAX action failed ❌');
            }
        }, 'json').fail(function() { alert('AJAX request failed ❌'); })
          .always(function() { btn.prop('disabled', false); });
    }

    $(document).on('click', '.unlocktoview-reminder', function(e){
        e.preventDefault(); e.stopPropagation();
        handleAjax($(this), 'unlocktoview_send_reminder', 'reminder-column', 'Yes');
    });

    $(document).on('click', '.unlocktoview-mark-paid', function(e){
        e.preventDefault();
        const btn = $(this);
        if (btn.prop('disabled')) return;

        const row = btn.closest('tr');
        btn.prop('disabled', true);

        $.post(unlocktoview_admin_ajax.ajax_url, {
            action: 'unlocktoview_mark_paid',
            _wpnonce: btn.data('nonce'),
            email: btn.data('email'),
            video: btn.data('video')
        }, function(res){
            if (res?.success){
                row.find('.paid-column').text(res.data.paid_status || 'Yes');
                btn.text('Paid');
            } else {
                alert(res?.data?.message || 'Failed to mark as paid ❌');
                btn.prop('disabled', false);
            }
        }, 'json').fail(function(){
            alert('AJAX request failed ❌');
            btn.prop('disabled', false);
        });
    });

    $(document).on('click', '.unlocktoview-delete', function(e){
        e.preventDefault(); e.stopPropagation();
        const btn = $(this);
        if (!confirm('Are you sure you want to delete this rental?')) return;

        const row = btn.closest('tr');
        btn.prop('disabled', true);

        $.post(unlocktoview_admin_ajax.ajax_url, {
            action: 'unlocktoview_delete_rental',
            _wpnonce: unlocktoview_admin_ajax.nonce,
            email: btn.data('email'),
            video: btn.data('video')
        }, function(res){
            if (res?.success) row.fadeOut(300, function(){ $(this).remove(); });
            else alert(res?.data?.message || 'Delete failed ❌');
        }, 'json').fail(function(){ alert('AJAX request failed ❌'); })
          .always(function(){ btn.prop('disabled', false); });
    });
});
