<?php
if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly
?>

<div class="unlocktoview-logo">
    <img 
        src="<?php echo esc_url( UNLOCK_TO_VIEW_PLUGIN_URL . 'assets/img/logo_unlocktoview.svg' ); ?>" 
        width="300" 
        alt="<?php echo esc_attr__( 'Unlock To View Logo', 'unlock-to-view' ); ?>" 
    />
</div>

<div class="wrap utv-about-page">

    <!-- Hero Section -->
    <div class="hero">

        <!-- Top Menu -->
        <div id="utv-menu">
            <ul class="utv-nav-links">
                <li><a href="https://liserasmussen.se/unlock-to-view/index.html" target="_blank"><?php esc_html_e( 'Home', 'unlock-to-view' ); ?></a></li>
                <li><a href="https://liserasmussen.se/unlock-to-view/unlocktoview_plans.html" target="_blank"><?php esc_html_e( 'Features', 'unlock-to-view' ); ?></a></li>
                <li><a href="https://liserasmussen.se/unlock-to-view/installation.html" target="_blank"><?php esc_html_e( 'Installation', 'unlock-to-view' ); ?></a></li>
                <li><a href="https://liserasmussen.se/unlock-to-view/faq.html" target="_blank"><?php esc_html_e( 'FAQ', 'unlock-to-view' ); ?></a></li>
                <li><a href="https://liserasmussen.se/unlock-to-view/support.html" target="_blank"><?php esc_html_e( 'Support', 'unlock-to-view' ); ?></a></li>
            </ul>
        </div>

        <!-- Hero Content -->
        <div class="hero-inner utv-container">
            <div class="hero-content">
                <h1><?php esc_html_e( 'Lock Videos. Sell Rentals. Send Reminders.', 'unlock-to-view' ); ?></h1>
                <p class="lead">
                    <?php esc_html_e( 'Unlock To View makes it easy to monetize video content on WordPress. Restrict playback until your visitors unlock it with a code or rental workflow.', 'unlock-to-view' ); ?>
                </p>
                <div class="hero-buttons">
                    <a href="https://liserasmussen.se/unlock-to-view/unlocktoview_plans.html" class="btn btn-primary" target="_blank">
                        <?php esc_html_e( 'Get the Plugin', 'unlock-to-view' ); ?>
                    </a>
                </div>

                <!-- Video -->
                <div class="hero-video">
                    <video controls autoplay muted loop>
                        <source src="<?php echo esc_url( UNLOCK_TO_VIEW_PLUGIN_URL . 'assets/video/UnlockToViewDemo.mp4' ); ?>" type="video/mp4">
                        <?php esc_html_e( 'Your browser does not support the video tag.', 'unlock-to-view' ); ?>
                    </video>
                </div>

            </div>
        </div>

    </div>

    <!-- Highlights Section -->
    <div class="highlights-section">
        <div class="utv-container highlights-container">

            <div class="highlight-item">
                <div class="icon">🔒</div>
                <h3><?php esc_html_e( 'Secure', 'unlock-to-view' ); ?></h3>
                <p><?php esc_html_e( 'Protect your videos with unlock codes and timed rentals.', 'unlock-to-view' ); ?></p>
            </div>

            <div class="highlight-item">
                <div class="icon">💳</div>
                <h3><?php esc_html_e( 'Monetize', 'unlock-to-view' ); ?></h3>
                <p><?php esc_html_e( 'Sell video rentals directly from your WordPress site.', 'unlock-to-view' ); ?></p>
            </div>

            <div class="highlight-item">
                <div class="icon">📧</div>
                <h3><?php esc_html_e( 'Engage', 'unlock-to-view' ); ?></h3>
                <p><?php esc_html_e( 'Send automated email reminders to boost return visitors.', 'unlock-to-view' ); ?></p>
            </div>

        </div>
    </div>

</div>
